VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_Interface"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
  Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SCREEN_NAME As String = "DPC_Interface"
Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9700

Private Const ROWIDTRANSTATUS_NEW = "NEW"
Private Const ROWIDTRANSTATUS_OK = "OK"
Private Const ROWIDTRANSTATUS_ERROR = "ERROR"

Private Const MAX_SPLIT = 10
Private Const CODEPAGE_ANSI_LATIN1 = 1252
Private Const RANKWEIL_PLANT_CODE = "P571-RANK"

' FTP settings
Private Const FTP_PASIVE As Boolean = True

Private mb_Initialized              As Boolean

Private mb_copyAbort As Boolean         ' Global flag for file transfer operation
Private ms_copyFile As String           ' Actualy transfering file
Private mb_runCancel As Boolean         ' Global flag
Private ms_FTPRoot As String            ' root directory for opened FTP session

Private ms_TempDir As String

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

#If ENV = LIVE Then
Private mo_FSO As Object
Private mo_Db As Object
Private mo_DbBaeurer As Object
Private mo_Shell As Object
#Else
Private mo_FSO As Scripting.FileSystemObject
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_DbBaeurer As ARMSYSCOMLib.ArmDb
Private mo_Shell As Object
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private ms_Language_Code As String
Private ms_CT_Code As String
Private ValidityDate As Date

Private ms_BaeurerServer As String
Private ms_BaeurerDatabase As String
Private ms_BaeurerLoginName As String
Private ms_BaeurerPassword As String
Private ml_BaeurerFi_Nr As Long
Private ms_BaeurerSource As String
Private ms_BaeurerLang As String
Private ms_PC_Name As String
Private mo_Generate As DPC_Generate
Private ml_BaeurerConnectID As Long
Private mo_XMLAttrib As Dictionary

'Private me_RawMaterial As eDPCBOMMaterial
'Private ms_NewIdentNr As String
'Private ms_MaterialName As String
'Private md_CoilWidth As Double
'Private md_CoilThickness As Double
'Private ms_Material As String
'
'Private md_InlayLength As Double
'Private md_InlayWidth As Double

Private mta_XmlSql() As TXmlSql

Private Type TXmlSql
  Request As String
  Cursor As Long
  ATS_Id As Long
  ATS_Type As eDPCXmlSqlType
  ATS_Node As String
  ATS_IsSubNode As Boolean
  ATS_IsMaster As Boolean
  ATS_ImportName As String
  ATS_Profile As String
  ATS_Version As Long
End Type

'logging variables ...
Private Type DPCLogInterface
    ILO_Interface As eDPCXmlExportType
    ILO_MasterId As String
    ILO_Status As Integer
    ILO_RespMsg As String
    ILO_Error As String
    ILO_Connection As String
    ILO_XMLSent As String
    ILO_DateSent As Date
    ILO_XMLResponse As String
    ILO_Performance As Double
End Type

Dim mo_ILO As DPCLogInterface

' remarks - need DB user to write export tables and read all other
' when the result is ready ? which status to check ?
' how to send the same article to secretbox again ?
' is it possible to update article ?
' Link BOM to agpos fuer material abbuchung
' definier ag bennenung (nr:benennng)
' abw_plus = 500%

Public Property Set ArmDb(ByVal ao_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = ao_Db
  Exit Property
ErrHandler:
  Call ErrHandler("ArmDb.Set")
End Property

Public Property Get ArmDbBaeurer() As Object
On Error GoTo ErrHandler
  
  Set ArmDbBaeurer = mo_DbBaeurer
  Exit Property
ErrHandler:
  Call ErrHandler("ArmDbBaeurer.Get")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrHandler:
  Call ErrHandler("Tools.Set")
End Property

Property Let U_Code(al_Code As Long)
On Error GoTo ErrHandler
  
  ml_U_Code = al_Code
  Exit Property
ErrHandler:
  Call ErrHandler("U_Code.Let")
End Property

Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = as_Language_Code
  Exit Property
ErrHandler:
  Call ErrHandler("Language_Code.Let")
End Property

Property Let CT_Code(as_Value As String)
On Error GoTo ErrHandler
  
  ms_CT_Code = as_Value
  Exit Property
ErrHandler:
  Call ErrHandler("CT_Code.Let")
End Property


Public Sub Load_A_COM()
On Error GoTo ErrHandler

Dim ls_Connect() As String
Dim lo_NetObject As Object

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
  Set mo_Shell = CreateObject("WSCript.Shell")
  If mo_Shell Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet, "CreateObject()", "Cannot create WSCript.Shell.")
  End If

  ms_PC_Name = mo_Tools.GetComputerName
  ms_TempDir = mo_Tools.GetAndCreateTempDir(mo_FSO, SCREEN_NAME)
  
#If ENV = LIVE Then
    Set mo_DbBaeurer = CreateObject("ArmSysCOM.ArmDb")
#Else
    Set mo_DbBaeurer = New ARMSYSCOMLib.ArmDb
#End If
  
  Set mo_Generate = New DPC_Generate
  Set mo_Generate.ArmDb = mo_Db
  Set mo_Generate.Tools = mo_Tools
  
  ls_Connect = Split(mo_Tools.GetAConfigData("DPC_BaeurerConnection"), SEP)
  If UBound(ls_Connect) = 5 Then
    ms_BaeurerServer = ls_Connect(0)
    ms_BaeurerDatabase = ls_Connect(1)
    ms_BaeurerLoginName = ls_Connect(2)
    ms_BaeurerPassword = ls_Connect(3)
    ms_BaeurerSource = ls_Connect(4)
    ml_BaeurerFi_Nr = Val(ls_Connect(5))
    ms_BaeurerLang = "de_de"
  Else
      Err.Raise ArmErr.PropertyNotSet, "Split(mo_Tools.GetAConfigData(""DPC_BaeurerConnection"")", "Missing or invalid configuration"
  End If
  ml_BaeurerConnectID = 0
  Set mo_XMLAttrib = New Dictionary
'    ms_BaeurerServer = "10.68.16.40\LIVE_SAGE"
'    ms_BaeurerDatabase = "test70"
'    ms_BaeurerLoginName = "test70"
'    ms_BaeurerPassword = "erp"
'    ms_BaeurerSource = "Capture"
'    ml_BaeurerFi_Nr = 1
  If ms_Language_Code = "" Then ms_Language_Code = "E"
  Exit Sub
ErrHandler:
  Call ErrHandler("Load_A_Com")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lc_Cursor As Long

  Call mo_Tools.DeleteTemporaryFolder(mo_FSO, SCREEN_NAME)
  If mo_DbBaeurer.CursorCount > 0 Then
    For ll_Idx = 0 To mo_DbBaeurer.CursorCount - 1
      Debug.Print "Baeurer Cursor #" & (ll_Idx + 1) & "-" & mo_DbBaeurer.Cursors(ll_Idx) & mo_DbBaeurer.SQLRequest(mo_DbBaeurer.Cursors(ll_Idx))
    Next
  End If
  
  For ll_Idx = 0 To mo_XMLAttrib.Count - 1
    lc_Cursor = mo_XMLAttrib.Items(ll_Idx)
    Call mo_Db.Close(lc_Cursor)
  Next
  
  Call mo_XMLAttrib.RemoveAll
  Set mo_XMLAttrib = Nothing
  
  Call mo_DbBaeurer.Disconnect
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Set mo_DbBaeurer = Nothing
  Exit Sub
ErrHandler:
  Call ErrHandler("Unload_A_Com")
End Sub

Private Sub Bae_LoadGrid(ByVal ao_grid As ArmGrid, ByVal ac_Cursor As Long)
On Error GoTo ErrHandler

  ao_grid.Redraw = False
  Call mo_DbBaeurer.First(ac_Cursor)
  While Not mo_DbBaeurer.EOF(ac_Cursor)
    Call ao_grid.AddLine(Array(mo_DbBaeurer.GetFields(ac_Cursor, 0), mo_DbBaeurer.GetFields(ac_Cursor, 1)))
    Call mo_DbBaeurer.Next(ac_Cursor)
  Wend
  ao_grid.Redraw = True
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_LoadGrid")
End Sub

Private Function Bae_LoadBaeurerReferenceCursor(ByVal ao_Db As Object, ByVal ae_Reference As eDPCBaeurerReference, ByVal as_Code As String, ByVal av_Param As Variant) As Long
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_Idx As Long
  
  Bae_LoadBaeurerReferenceCursor = 0
  ls_req = ""
  If ae_Reference = eDPCBaeurerReference.brOrderType Then
    ls_req = "SELECT v902.auf_art as Code, v9022.txt AS Text "
    ls_req = ls_req & "FROM v902 "
    ls_req = ls_req & "INNER JOIN v9022 ON (v9022.auf_art=v902.auf_art AND v9022.fi_nr=v902.fi_nr and v9022.lang=$lang$) "
    ls_req = ls_req & "WHERE v902.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "((v902.auf_art=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brPartner Then
    ls_req = "SELECT g620.ansprnr as Code, g620.name_1 AS Text "
    ls_req = ls_req & "FROM g620 "
    ls_req = ls_req & "WHERE g620.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "g620.konto=$konto$ AND "
    ls_req = ls_req & "((g620.ansprnr=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brDeliveryCondition Then
    ls_req = "SELECT v908.lb as Code, v9082.txt AS Text "
    ls_req = ls_req & "FROM v908 "
    ls_req = ls_req & "INNER JOIN v9082 ON (v9082.lb=v908.lb AND v9082.fi_nr=v908.fi_nr and v9082.lang_ext=$lang$) "
    ls_req = ls_req & "WHERE v908.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "((v908.lb=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brDeliveryType Then
    ls_req = "SELECT v907.vers_art as Code, v9072.txt AS Text "
    ls_req = ls_req & "FROM v907 "
    ls_req = ls_req & "INNER JOIN v9072 ON (v9072.vers_art=v907.vers_art AND v9072.fi_nr=v907.fi_nr and v9072.lang_ext=$lang$) "
    ls_req = ls_req & "WHERE (v907.fi_nr=$fi_nr$) AND "
    ls_req = ls_req & "((v907.vers_art=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brClerkInCharge Then
    ls_req = "SELECT g915.sb_schl as Code, g915.sb_name AS Text "
    ls_req = ls_req & "FROM g915 "
    ls_req = ls_req & "WHERE g915.fi_nr=$fi_nr$ AND "
    ls_req = ls_req & "((g915.sb_schl=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brPackType Then
    ls_req = "SELECT g741.ausprid as Code, g7412.txt AS Text "
    ls_req = ls_req & "FROM g741 "
    ls_req = ls_req & "INNER JOIN g7412 ON (g741.kritnr = g7412.kritnr AND g741.ausprid = g7412.ausprid AND g7412.lang_ext=$lang$) "
    ls_req = ls_req & "INNER JOIN g730 ON (g7412.kritnr = g730.kritnr) "
    ls_req = ls_req & "WHERE g730.fldname = 'VERP_ART' AND "
    ls_req = ls_req & "((g741.ausprid=$Code$) OR ($Code$ IS NULL))"
  ElseIf ae_Reference = eDPCBaeurerReference.brKonto Then
    ls_req = "SELECT v600.konto as Code, g693.name_1 AS Text "
    ls_req = ls_req & "FROM g600 "
    ls_req = ls_req & "INNER JOIN v600 ON (g600.konto = v600.konto) "
    ls_req = ls_req & "INNER JOIN g693 ON (g600.adressid = g693.adressid) "
    ls_req = ls_req & "WHERE (g600.fi_nr=$fi_nr$) AND "
    ls_req = ls_req & "(g600.satzart = 1) AND "
    ls_req = ls_req & "((g600.konto=$Code$) OR ($Code$ IS NULL))"
  End If
  
  If ls_req <> "" Then
    If IsArray(av_Param) Then
      For ll_Idx = 0 To UBound(av_Param) Step 2
        ls_req = Replace(ls_req, av_Param(ll_Idx), av_Param(ll_Idx + 1), , , vbTextCompare)
      Next
    End If
    ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
    ls_req = Replace(ls_req, "$Code$", as_Code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$lang$", mo_Tools.SQLStr(ms_BaeurerLang), , , vbTextCompare)
    Bae_LoadBaeurerReferenceCursor = mo_Tools.OpenSQLSafe(ao_Db, ls_req)
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_LoadBaeurerReferenceCursor")
End Function

Public Function Bae_LoadBaeurerReferenceText(ByVal ae_Reference As eDPCBaeurerReference, ByVal as_Code As String, ByVal av_Param As Variant, ByRef as_Text As String) As Boolean
On Error GoTo ErrHandler

Dim lc_Cursor As Long

  as_Text = ""
  Bae_LoadBaeurerReferenceText = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  lc_Cursor = Bae_LoadBaeurerReferenceCursor(mo_DbBaeurer, ae_Reference, as_Code, av_Param)
  If lc_Cursor <> 0 Then
    If mo_DbBaeurer.RowCount(lc_Cursor) = 1 Then
      as_Text = mo_DbBaeurer.GetFields(lc_Cursor, "Text")
      Bae_LoadBaeurerReferenceText = True
    End If
    Call mo_DbBaeurer.Close(lc_Cursor)
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_LoadBaeurerReferenceText")
End Function

Public Sub Bae_LoadBaeurerReferenceGrid(ByVal ao_grid As ArmGrid, ByVal ae_Reference As eDPCBaeurerReference, ByVal av_Param As Variant)
On Error GoTo ErrHandler

Dim lc_Cursor As Long

  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Sub
  End If
  
  lc_Cursor = Bae_LoadBaeurerReferenceCursor(mo_DbBaeurer, ae_Reference, "NULL", av_Param)
  Call ao_grid.ClearGrid
  If lc_Cursor <> 0 Then
    Call Bae_LoadGrid(ao_grid, lc_Cursor)
    Call mo_DbBaeurer.Close(lc_Cursor)
  End If
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_LoadBaeurerReferenceGrid")
End Sub

Private Function Bae_SaveXMLDocument(ByVal ao_XML As Object, ByVal as_FileName As String, ByRef as_ErrMsg As String) As String
On Error GoTo ErrHandler

Dim lo_shell As Object
Dim ls_XmlPath As String

  Set lo_shell = CreateObject("WSCript.Shell")
  If lo_shell Is Nothing Then
      as_ErrMsg = "Cannot create WSCript.Shell."
      Exit Function
  End If
  
  ls_XmlPath = ms_TempDir & "\" & as_FileName & ".xml"
  Call ao_XML.Save(ls_XmlPath)
  If InStr(1, mo_Tools.GetAConfigData("DPC_DEBUG_XML"), ms_PC_Name, vbTextCompare) >= 1 Then
  Call lo_shell.Run("""" & ls_XmlPath & """")
  End If
  Set lo_shell = Nothing
  Bae_SaveXMLDocument = ms_TempDir & "\" & as_FileName & ".xml"
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_SaveXMLDocument")
End Function

Private Function SAP_SaveXMLDocument(ByVal ao_XML As Object, ByVal as_FileName As String, ByVal as_ATI_Name As String, ByRef as_ErrMsg As String, ByVal ab_DebugXML As Boolean) As String
On Error GoTo ErrHandler

Dim lo_shell As Object
Dim ls_XmlPath As String
Dim lo_XmlIndentedDocument As MSXML2.DOMDocument
Dim lo_XmlIndenter As MSXML2.DOMDocument
Dim ls_ValidationXSD As String
Dim ls_FormatterXML As String

  Set lo_shell = CreateObject("WSCript.Shell")
  If lo_shell Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet, "CreateObject()", "Cannot create WSCript.Shell.")
  End If
  
  Set lo_XmlIndentedDocument = CreateObject("MSXML2.DOMDocument")
  Set lo_XmlIndenter = CreateObject("MSXML2.DOMDocument")

  lo_XmlIndenter.async = False
  
  Call LoadXMLFiles(as_ATI_Name, ls_ValidationXSD, ls_FormatterXML)
  
  Call lo_XmlIndenter.Load(ls_FormatterXML)

  Call ao_XML.transformNodeToObject(lo_XmlIndenter, lo_XmlIndentedDocument)
  
  If ab_DebugXML Then
    ls_XmlPath = ms_TempDir & "\" & as_FileName & ".xml"
    Call lo_XmlIndentedDocument.Save(ls_XmlPath)
    If InStr(1, mo_Tools.GetAConfigData("DPC_DEBUG_XML"), ms_PC_Name, vbTextCompare) >= 1 Then
    Call lo_shell.Run("""" & ls_XmlPath & """")
  End If
  End If
  
    Call ValidateXMLFile(lo_XmlIndentedDocument.xml, "", ls_ValidationXSD, as_ErrMsg, True)
    
  SAP_SaveXMLDocument = lo_XmlIndentedDocument.xml
  Set lo_shell = Nothing
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_SaveXMLDocument")
End Function

Private Function LoadXMLFiles(ByVal as_ATI_Name As String, ByRef as_SchemaFile As String, ByRef as_FormatterFile As String) As Boolean
On Error GoTo ErrHandler

Dim ls_path As String
Dim lc_Cursor As Long
Dim ls_Request As String
Dim ls_Schema As String
Dim ls_SchemaName As String
Dim ls_Formatter As String
Dim ls_FormatterName As String

  LoadXMLFiles = False
  
  ls_Request = "SELECT ATI_Schema,ATI_SchemaName, ATI_Formatter,ATI_FormatterName FROM DPC_AttribInterface WHERE ATI_Name = $ATI_Name$"
  
  ls_Request = Replace(ls_Request, "$ATI_Name$", mo_Tools.SQLStr(as_ATI_Name), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_Schema = mo_Db.GetFields(lc_Cursor, "ATI_Schema")
    ls_SchemaName = mo_Db.GetFields(lc_Cursor, "ATI_SchemaName")
    ls_Formatter = mo_Db.GetFields(lc_Cursor, "ATI_Formatter")
    ls_FormatterName = mo_Db.GetFields(lc_Cursor, "ATI_FormatterName")
  Else
    Err.Raise ArmErr.InvalidArgument, "as_ATI_Name", "Invalid ATI_Name: " & as_ATI_Name
  End If
  
  Call mo_Db.Close(lc_Cursor)
  
  ls_path = App.Path & "\Download\XMLSchema\"
    
  If Not mo_FSO.FolderExists(ls_path) Then
    Call mo_FSO.CreateFolder(ls_path)
  End If
  
  as_SchemaFile = ls_path & ls_SchemaName
  
  If Not mo_FSO.FileExists(as_SchemaFile) Then
    If Not mo_Db.BlobToFileSQL("SELECT F_Data_File FROM A_Files WHERE F_File_Key='" & ls_Schema & "'", as_SchemaFile, True, False) Then
      Err.Raise ArmErr.CompFncFailed, "BlobToFileSQL", "File download failed A_File_Key:" & ls_Schema & "," & mo_Db.LastErrorMessage
      Exit Function
    End If
  End If
    
  If Len(ls_FormatterName) > 0 Then
    as_FormatterFile = ls_path & ls_FormatterName
    
    If Not mo_FSO.FileExists(as_FormatterFile) Then
      If Not mo_Db.BlobToFileSQL("SELECT F_Data_File FROM A_Files WHERE F_File_Key='" & ls_Formatter & "'", as_FormatterFile, True, False) Then
        Err.Raise ArmErr.CompFncFailed, "BlobToFileSQL", "File download failed A_File_Key:" & ls_Formatter & "," & mo_Db.LastErrorMessage
        Exit Function
      End If
    End If
  End If
  
  LoadXMLFiles = True
  
  Exit Function
  
ErrHandler:
  
  If lc_Cursor <> 0 Then
      Call mo_Db.Close(lc_Cursor)
  End If

  LoadXMLFiles = False
  Call ErrHandler("LoadXMLFiles")
End Function

Private Function ValidateXMLFile(ByVal ls_strXmlFile As String, ls_strUrn As String, ls_strXsdFile As String, ByRef as_ErrMsg As String, Optional ab_ParseString = False) As Boolean
On Error GoTo ErrHandler
Dim ls_Desc As String
    
   'Create an XML DOMDocument object.
   Dim lo_Schema As Object
   Dim lo_XMLDoc As Object
    
   ValidateXMLFile = False
   
   Set lo_Schema = CreateObject("MSXML2.XMLSchemaCache.4.0")
   Call lo_Schema.Add(ls_strUrn, ls_strXsdFile)

   ' Create an XML DOMDocument object.
   Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument.4.0")

   ' Assign the schema cache to the DOM document.
   ' schemas collection.
   Set lo_XMLDoc.schemas = lo_Schema

   lo_XMLDoc.async = False
   
   If ab_ParseString = False Then
        lo_XMLDoc.Load ls_strXmlFile
   Else
        lo_XMLDoc.loadXML ls_strXmlFile
   End If

   ' Return validation results in message to the user.
   If lo_XMLDoc.parseError.errorCode <> 0 Then
        
        If ab_ParseString = False Then
            ls_Desc = "Validation failed on " & ls_strXmlFile & vbCrLf
        Else
            ls_Desc = "Validation failed" & vbCrLf
        End If
        
        ls_Desc = ls_Desc & "Reason: " & lo_XMLDoc.parseError.reason & _
             vbCrLf & "Source: " & _
             lo_XMLDoc.parseError.srcText & _
             vbCrLf & "Line: " & _
             lo_XMLDoc.parseError.line & vbCrLf
             
        as_ErrMsg = as_ErrMsg & ls_Desc
    Else
        ValidateXMLFile = True
    End If
    
    Set lo_Schema = Nothing
    Set lo_XMLDoc = Nothing
    
    Exit Function
ErrHandler:
  
    Set lo_Schema = Nothing
    Set lo_XMLDoc = Nothing
  
  Call ErrHandler("ValidateXMLFile")
End Function

Private Function Bae_CreateXMLDocument(ByVal ao_Db As Object, ByVal ae_ATR_Id As eDPCXmlExportType, ByVal as_Key As String, ByRef al_Version As Long, ByVal ao_CustomData As Dictionary) As Object
On Error GoTo ErrHandler

Dim lo_parentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorMaster As Long
Dim lc_CursorXML As Long
Dim ll_ATS_Id As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ll_CodePage As Long

  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  lo_XMLDoc.async = False
  
  Set lo_parentNode = lo_MainNode
  lc_CursorXML = Bae_GetXmlCursor(ae_ATR_Id)
  Call InitSqlData(ao_Db, lc_CursorXML, as_Key)
  
  lt_XmlMaster = GetXmlMasterSql
  al_Version = lt_XmlMaster.ATS_Version
  ll_CodePage = Val(ao_Db.GetFields(lt_XmlMaster.Cursor, "CodePage"))
  If ll_CodePage = 0 Then
    ll_CodePage = CODEPAGE_ANSI_LATIN1
  End If
  
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "Data", "")
  Set lo_MainNode = AppendElement(lo_XMLDoc, lo_MainNode, lt_XmlMaster.ATS_ImportName, "")
  
  Call AppendElement(lo_XMLDoc, lo_MainNode, "heute", Bae_FormatXMLDateTime(Now))
  Call AppendElement(lo_XMLDoc, lo_MainNode, "profil", lt_XmlMaster.ATS_Profile)
  
  lc_CursorMaster = lt_XmlMaster.Cursor
  If ao_Db.RowCount(lc_CursorMaster) = 0 Then
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, lt_XmlMaster.ATS_Node, "")
  Else
    Call ao_Db.First(lc_CursorMaster)
    While Not ao_Db.EOF(lc_CursorMaster)
      Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, lt_XmlMaster.ATS_Node, "")
    
      Call mo_Db.First(lc_CursorXML)
      While Not mo_Db.EOF(lc_CursorXML)
      
        ll_ATS_Id = mo_Db.GetFields(lc_CursorXML, "ATS_Id")
        lt_XmlSql = GetXmlSql(ll_ATS_Id)
        If ll_ATS_Id = lt_XmlMaster.ATS_Id Then
          Call Bae_CreateXMLNode(lc_CursorXML, ao_Db, lc_CursorMaster, lo_XMLDoc, lo_parentNode, ao_CustomData, ll_CodePage)
          Call mo_Db.Next(lc_CursorXML)
        Else
          If lt_XmlSql.ATS_Type = eDPCXmlSqlType.stList Then
            Call CreateXMLGroupList(lc_CursorXML, ao_Db, ll_ATS_Id, lo_XMLDoc, lo_parentNode, ao_CustomData)
          ElseIf lt_XmlSql.ATS_Type = eDPCXmlSqlType.stFlat Then
            Call CreateXMLGroupFlat(lc_CursorXML, ao_Db, ll_ATS_Id, lo_XMLDoc, lo_parentNode, ao_CustomData)
          End If
        End If
      Wend
      Call ao_Db.Next(lc_CursorMaster)
    Wend
  End If
  'Call mo_Db.Close(lc_CursorXML)
  Call CloseSqlData(ao_Db)
  Set Bae_CreateXMLDocument = lo_XMLDoc
  Exit Function
ErrHandler:

  'Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("Bae_CreateXMLDocument")
End Function

Private Function CreateXMLGroupFlat(ByVal ac_CursorXML As Long, ByVal ao_DbData As Object, ByVal al_ATS_Id As Long, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, ByVal ao_CustomData As Dictionary)
On Error GoTo ErrHandler

Dim ll_RecIdx As Long
Dim lo_CurrentNode As Object
Dim ls_NodeName As String
Dim lt_XmlSql As TXmlSql
Dim lc_CursorData As Long
Dim ll_CodePage As Long

  lt_XmlSql = GetXmlSql(al_ATS_Id)
  lc_CursorData = lt_XmlSql.Cursor

  ll_CodePage = Val(ao_DbData.GetFields(lc_CursorData, "CodePage"))
  If ll_CodePage = 0 Then
    ll_CodePage = CODEPAGE_ANSI_LATIN1
  End If
  
  ls_NodeName = Trim(mo_Db.GetFields(ac_CursorXML, "ATS_Node"))
  If mo_Db.GetFields(ac_CursorXML, "ATS_IsSubNode") = "X" Then
    ls_NodeName = Replace(ls_NodeName, "$N$", CStr(ll_RecIdx), , , vbTextCompare)
    Set lo_CurrentNode = AppendElement(ao_XMLDoc, ao_parentNode, ls_NodeName, "")
  Else
    Set lo_CurrentNode = ao_parentNode
  End If
  While (Not mo_Db.EOF(ac_CursorXML)) And (al_ATS_Id = mo_Db.GetFields(ac_CursorXML, "ATS_Id"))
    ll_RecIdx = mo_Db.GetFields(ac_CursorXML, "ATR_RecIdx")
    If (ll_RecIdx > 0) And (ll_RecIdx <= ao_DbData.RowCount(lc_CursorData)) Then
      mo_Db.Position(lc_CursorData) = ll_RecIdx - 1
      Call Bae_CreateXMLNode(ac_CursorXML, ao_DbData, lc_CursorData, ao_XMLDoc, lo_CurrentNode, ao_CustomData, ll_CodePage)
    Else
      Call Bae_CreateXMLNode(ac_CursorXML, ao_DbData, 0, ao_XMLDoc, lo_CurrentNode, ao_CustomData, ll_CodePage)
    End If
    Call mo_Db.Next(ac_CursorXML)
  Wend
  Exit Function
ErrHandler:
  Call ErrHandler("CreateXMLGroupFlat")
End Function

Private Function CreateXMLGroupList(ByVal ac_CursorXML As Long, ByVal ao_DbData As Object, ByVal al_ATS_Id As Long, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, ByVal ao_CustomData As Dictionary)
On Error GoTo ErrHandler

Dim ll_XMLPosition As Long
Dim ll_RecIdx As Long
Dim lo_CurrentNode As Object
Dim ls_NodeName As String
Dim lt_XmlSql As TXmlSql
Dim lc_CursorData As Long
Dim ll_CodePage As Long

  lt_XmlSql = GetXmlSql(al_ATS_Id)
  lc_CursorData = lt_XmlSql.Cursor
  
  ll_CodePage = Val(ao_DbData.GetFields(lc_CursorData, "CodePage"))
  If ll_CodePage = 0 Then
    ll_CodePage = CODEPAGE_ANSI_LATIN1
  End If
  
  ll_XMLPosition = mo_Db.Position(ac_CursorXML)
  
  If mo_Db.RowCount(lc_CursorData) = 0 Then
    'skip group if no data
    While (Not mo_Db.EOF(ac_CursorXML)) And (al_ATS_Id = mo_Db.GetFields(ac_CursorXML, "ATS_Id"))
      Call mo_Db.Next(ac_CursorXML)
    Wend
  Else
    Call ao_DbData.First(lc_CursorData)
    While Not ao_DbData.EOF(lc_CursorData)
      mo_Db.Position(ac_CursorXML) = ll_XMLPosition
      ll_RecIdx = mo_Db.Position(lc_CursorData) + 1
      ls_NodeName = Trim(mo_Db.GetFields(ac_CursorXML, "ATS_Node"))
      
      If mo_Db.GetFields(ac_CursorXML, "ATS_IsSubNode") = "X" Then
        ls_NodeName = Replace(ls_NodeName, "$N$", CStr(ll_RecIdx), , , vbTextCompare)
        Set lo_CurrentNode = AppendElement(ao_XMLDoc, ao_parentNode, ls_NodeName, "")
      Else
        Set lo_CurrentNode = ao_parentNode
      End If
      
      While (Not mo_Db.EOF(ac_CursorXML)) And (al_ATS_Id = mo_Db.GetFields(ac_CursorXML, "ATS_Id"))
        
        Call Bae_CreateXMLNode(ac_CursorXML, ao_DbData, lc_CursorData, ao_XMLDoc, lo_CurrentNode, ao_CustomData, ll_CodePage)
        
        Call mo_Db.Next(ac_CursorXML)
      Wend
      Call ao_DbData.Next(lc_CursorData)
    Wend
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("CreateXMLGroupList")
End Function

'Private Function ReplaceMaterialValues(ByVal as_Value As String) As String
'On Error GoTo ErrHandler
'
'  If me_RawMaterial = eDPCBOMMaterial.bcCoil Then
'    as_Value = Replace(as_Value, "$IdentNr$", FormatXML(ms_NewIdentNr, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$ben$", FormatXML(ms_MaterialName, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$werkstoff$", FormatXML(ms_Material, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$breiteb$", FormatXML(md_CoilWidth, "N", 2), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$matdicke$", FormatXML(md_CoilThickness, "N", 2), , , vbTextCompare)
'
'
'  ElseIf me_RawMaterial = eDPCBOMMaterial.bcInlay Then
'    as_Value = Replace(as_Value, "$IdentNr$", FormatXML(ms_NewIdentNr, "C", 0), , , vbTextCompare)
'    as_Value = Replace(as_Value, "$ben$", FormatXML(ms_MaterialName, "C", 0), , , vbTextCompare)
'  End If
'  ReplaceMaterialValues = as_Value
'  Exit Function
'ErrHandler:
'  Call ErrHandler("ReplaceMaterialValues")
'End Function

Private Function Bae_ReplaceCustomData(ByVal as_Value As String, ByVal ao_CustomData As Dictionary, ByVal as_DataType As String, ByVal al_DataLength As Long, ByVal al_DataPrecision As Long, ByVal al_CodePage As Long) As String
On Error GoTo ErrHandler

Dim ll_Idx As Long

  For ll_Idx = 0 To ao_CustomData.Count - 1
    If StrComp(as_Value, ao_CustomData.keys(ll_Idx), vbTextCompare) = 0 Then
      as_Value = Replace(as_Value, ao_CustomData.keys(ll_Idx), Bae_FormatXML(ao_CustomData.Items(ll_Idx), as_DataType, al_DataLength, al_DataPrecision, al_CodePage), , , vbTextCompare)
      Exit For
    End If
  Next
  Bae_ReplaceCustomData = as_Value
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ReplaceCustomData")
End Function

Private Function Bae_CreateXMLNode(ByVal ac_CursorXML As Long, ByVal ao_Db As Object, ByVal ac_CursorData As Long, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, ByVal ao_CustomData As Dictionary, ByVal al_CodePage As Long)
On Error GoTo ErrHandler

Dim ls_DataType As String
Dim ll_DataLength As Long
Dim ll_DataPrecision As Long
Dim ls_Name As String
Dim ll_Idx As Long
Dim ls_Value As String
Dim ls_Default As String
Dim ls_CodeLookup As String
Dim le_ATR_Type As eDPCXmlExportType

  ls_Default = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DefaultValue"))
  ls_Value = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_Value"))
  ls_DataType = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataType"))
  ll_DataLength = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataLength"))
  ll_DataPrecision = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataPrecision"))
  ls_CodeLookup = Trim(mo_Db.GetFields(ac_CursorXML, "AC_CodeLookup"))
  le_ATR_Type = mo_Db.GetFields(ac_CursorXML, "ATR_Type")
  
  If Left(ls_Default, 1) = "'" And right(ls_Default, 1) = "'" Then
    ls_Default = Mid(ls_Default, 2, Len(ls_Default) - 2)
  End If
  
  If ls_Value = "" Then
    ls_Value = ls_Default
  Else
    If ac_CursorData = 0 Then
      ls_Value = ""
    Else
      ls_Value = Replace(ls_Value, "$RowIndex$", CStr(ao_Db.Position(ac_CursorData) + 1), , , vbTextCompare)
      If Not ao_CustomData Is Nothing Then
        ls_Value = Bae_ReplaceCustomData(ls_Value, ao_CustomData, ls_DataType, ll_DataLength, ll_DataPrecision, al_CodePage)
      End If
      For ll_Idx = 0 To ao_Db.FieldCount(ac_CursorData) - 1
        ls_Name = "$" & ao_Db.GetFieldName(ac_CursorData, ll_Idx) & "$"
        If StrComp(ls_Value, ls_Name, vbTextCompare) = 0 Then
          If ls_CodeLookup = "" Then
            ls_Value = Bae_FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), ls_DataType, ll_DataLength, ll_DataPrecision, al_CodePage)
          Else
            ls_Value = mo_Tools.ConvertCodeToBaeurer(mo_Db, mo_Tools.GetConversionCode(ls_CodeLookup), ao_Db.GetFields(ac_CursorData, ll_Idx))
            ls_Value = Bae_FormatXML(ls_Value, ls_DataType, ll_DataLength, ll_DataPrecision, al_CodePage)
          End If
          Exit For
        ElseIf InStr(1, ls_Value, ls_Name, vbTextCompare) > 0 Then
          If ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_I4 Then
            ls_Value = Replace(ls_Value, ls_Name, Bae_FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "N", 0, 0), , , vbTextCompare)
          ElseIf (ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_R4) Or (ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_R8) Then
            ls_Value = Replace(ls_Value, ls_Name, Bae_FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "N", 0, 2), , , vbTextCompare)
          ElseIf (ao_Db.GetFieldType(ac_CursorData, ll_Idx) = ArmSysType.DBTYPE_DATE) Then
            ls_Value = Replace(ls_Value, ls_Name, Bae_FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "D", 0, 0), , , vbTextCompare)
          Else
            ls_Value = Replace(ls_Value, ls_Name, Bae_FormatXML(ao_Db.GetFields(ac_CursorData, ll_Idx), "C", ll_DataLength, 0, al_CodePage), , , vbTextCompare)
          End If
        End If
      Next
    End If
    If Left(ls_Value, 1) = "$" And right(ls_Value, 1) = "$" Then
      ls_Value = ls_Default
    End If
  End If
  Call AppendElement(ao_XMLDoc, ao_parentNode, mo_Db.GetFields(ac_CursorXML, "ATR_B7Name"), ls_Value)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_CreateXMLNode")
End Function

Private Function SAP_CreateXMLNode(ByVal as_Name As String, ByVal ac_CursorXML As Long, ByVal av_Value As Variant, ByVal ao_XMLDoc As Object, ByVal ao_parentNode As Object, Optional ByVal al_CodePage As Long = CODEPAGE_ANSI_LATIN1)
On Error GoTo ErrHandler

Dim ls_DataType As String
Dim ll_DataLength As Long
Dim ll_DataPrecision As Long
Dim ls_Name As String
Dim ll_Idx As Long
Dim ls_Value As String
Dim ls_Default As String
Dim ls_CodeLookup As String
Dim ls_AtrName As String

  If mo_Db.Find(ac_CursorXML, "ATR_Name", as_Name, 0, 1) < 0 Then
       Err.Raise ArmErr.SQLBadRowExpectedCount, "Find", "No SQL Data for XML export found. ATR_B7Name missing:" + as_Name
       Exit Function
  End If

  ls_AtrName = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_Name"))
  ls_Default = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DefaultValue"))
  ls_Value = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_Value"))
  ls_DataType = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataType"))
  ll_DataLength = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataLength"))
  ll_DataPrecision = Trim(mo_Db.GetFields(ac_CursorXML, "ATR_DataPrecision"))
  ls_CodeLookup = Trim(mo_Db.GetFields(ac_CursorXML, "AC_CodeLookup"))
  
  If Left(ls_Default, 1) = "'" And right(ls_Default, 1) = "'" Then
    ls_Default = Mid(ls_Default, 2, Len(ls_Default) - 2)
  End If
  
  If ls_Value = "" Then
    ls_Value = ls_Default
  Else
    If ls_CodeLookup = "" Then
      ls_Value = SAP_FormatXML(av_Value, ls_DataType, ll_DataPrecision, al_CodePage)
    Else
      ls_Value = ConvertCodeToAMC(ls_CodeLookup, av_Value)
      ls_Value = SAP_FormatXML(ls_Value, ls_DataType, ll_DataPrecision, al_CodePage)
    End If
  End If
  
  If Len(ls_Value) > ll_DataLength Then
    ls_Value = Left(ls_Value, ll_DataLength)
  End If
  
  Call AppendElement(ao_XMLDoc, ao_parentNode, mo_Db.GetFields(ac_CursorXML, "ATR_B7Name"), ls_Value)
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_CreateXMLNode ATR_Name=" & ls_AtrName)
End Function

Private Function Bae_FormatXML(ByVal av_Data As Variant, ByVal as_DataType As String, ByVal al_DataLength As Long, ByVal al_DataPrecision As Long, Optional ByVal al_CodePage As Long = CODEPAGE_ANSI_LATIN1)
On Error GoTo ErrHandler

  Bae_FormatXML = ""
  Select Case UCase(as_DataType)
  Case "N"
    If al_DataPrecision = 0 Then
      Bae_FormatXML = BAE_FormatXMLInt(Val(av_Data))
    Else
      Bae_FormatXML = BAE_FormatXMLFloat(av_Data, al_DataPrecision)
    End If
  Case "D"
    Bae_FormatXML = Bae_FormatXMLDateTime(av_Data)
  Case Else
    If al_DataLength = 0 Then
      Bae_FormatXML = CStr(av_Data)
    Else
      'Bae_FormatXML = Left(CStr(av_Data), al_DataLength)
      Bae_FormatXML = Left(CStr(ConvertCodePageFromAnsi(av_Data, al_CodePage)), al_DataLength)
    End If
  End Select
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_FormatXML")
End Function

Private Function SAP_FormatXML(ByVal av_Data As Variant, ByVal as_DataType As String, ByVal al_DataPrecision As Long, Optional ByVal al_CodePage As Long = CODEPAGE_ANSI_LATIN1)
On Error GoTo ErrHandler

  SAP_FormatXML = ""
  Select Case UCase(as_DataType)
  Case "N"
    If al_DataPrecision = 0 Then
      SAP_FormatXML = SAP_FormatXMLInt(Val(av_Data))
    Else
      SAP_FormatXML = SAP_FormatXMLFloat(av_Data, 2)
    End If
  Case "D"
    SAP_FormatXML = SAP_FormatXMLDateTime(av_Data)
  Case Else
    SAP_FormatXML = CStr(ConvertCodePageFromAnsi(av_Data, al_CodePage))
  End Select
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_FormatXML")
End Function

Private Function Bae_GetXmlCursor(ByVal ae_ATR_Type As eDPCXmlExportType) As Long
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long

  If mo_XMLAttrib.Exists(ae_ATR_Type) Then
    Bae_GetXmlCursor = mo_XMLAttrib.Item(ae_ATR_Type)
  Else
    ls_Request = "exec DPC_AttribXML_lst $ATR_Type$"
  
    ls_Request = Replace(ls_Request, "$ATR_Type$", mo_Tools.SqlInt(ae_ATR_Type), , , vbTextCompare)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    Call mo_XMLAttrib.Add(ae_ATR_Type, lc_Cursor)
    Bae_GetXmlCursor = lc_Cursor
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_GetXmlCursor")
End Function

Private Function SAP_GetXmlCursor(ByVal ae_ATR_Type As eDPCXmlExportType) As Long
On Error GoTo ErrHandler

Dim ls_Request As String

  ls_Request = "exec DPC_AttribXML_SAP_lst $ATR_Type$"
  ls_Request = Replace(ls_Request, "$ATR_Type$", mo_Tools.SqlInt(ae_ATR_Type), , , vbTextCompare)
  SAP_GetXmlCursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_GetXmlCursor")
End Function

Private Sub InitSqlData(ByVal ao_Db As Object, ByVal ac_XmlCursor As Long, ByVal as_Key As String)
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lc_Cursor As Long
Dim ll_RowCount As Long
Dim ls_Request As String

  ReDim mta_XmlSql(-1 To -1)
  lc_Cursor = mo_Db.Distinct(ac_XmlCursor, Array("ATS_Id", "ATS_Sql", "ATS_Type", "ATS_Node", "ATS_IsSubNode", "ATS_IsMaster", "ATS_ImportName", "ATS_Profile", "ATS_Version"), False)
  ll_RowCount = mo_Db.RowCount(lc_Cursor)
  If ll_RowCount > 0 Then
    ReDim mta_XmlSql(ll_RowCount - 1)
    Call mo_Db.First(lc_Cursor)
    ll_Idx = 0
    While Not mo_Db.EOF(lc_Cursor)
      mta_XmlSql(ll_Idx).ATS_Id = mo_Db.GetFields(lc_Cursor, "ATS_Id")
      mta_XmlSql(ll_Idx).Request = mo_Db.GetFields(lc_Cursor, "ATS_Sql")
      mta_XmlSql(ll_Idx).ATS_Type = mo_Db.GetFields(lc_Cursor, "ATS_Type")
      mta_XmlSql(ll_Idx).ATS_Node = mo_Db.GetFields(lc_Cursor, "ATS_Node")
      mta_XmlSql(ll_Idx).ATS_IsSubNode = StrComp(mo_Db.GetFields(lc_Cursor, "ATS_IsSubNode"), "X", vbTextCompare) = 0
      mta_XmlSql(ll_Idx).ATS_IsMaster = StrComp(mo_Db.GetFields(lc_Cursor, "ATS_IsMaster"), "X", vbTextCompare) = 0
      mta_XmlSql(ll_Idx).ATS_ImportName = mo_Db.GetFields(lc_Cursor, "ATS_ImportName")
      mta_XmlSql(ll_Idx).ATS_Profile = mo_Db.GetFields(lc_Cursor, "ATS_Profile")
      mta_XmlSql(ll_Idx).ATS_Version = mo_Db.GetFields(lc_Cursor, "ATS_Version")
      
      ls_Request = Replace(mta_XmlSql(ll_Idx).Request, "$Key$", mo_Tools.SQLStr(as_Key), , , vbTextCompare)
      mta_XmlSql(ll_Idx).Cursor = mo_Tools.OpenSQLSafe(ao_Db, ls_Request)
      Call mo_Db.Next(lc_Cursor)
      ll_Idx = ll_Idx + 1
    Wend
  Else
    Err.Raise ArmErr.SQLBadRowExpectedCount, "Distinct", "No SQL Data for XML export found."
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrHandler("InitSqlData")
End Sub

Private Sub CloseSqlData(ByVal ao_Db As Object)
On Error GoTo ErrHandler

Dim ll_Idx As Long

  For ll_Idx = 0 To UBound(mta_XmlSql)
    Call ao_Db.Close(mta_XmlSql(ll_Idx).Cursor)
  Next
  ReDim mta_XmlSql(-1 To -1)
  Exit Sub
ErrHandler:
  Call ErrHandler("CloseSqlData")
End Sub

Private Function GetXmlSql(ByVal al_ATS_Id As Long) As TXmlSql
On Error GoTo ErrHandler

Dim ll_Idx As Long
  
  For ll_Idx = 0 To UBound(mta_XmlSql)
    If al_ATS_Id = mta_XmlSql(ll_Idx).ATS_Id Then
      GetXmlSql = mta_XmlSql(ll_Idx)
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrHandler("GetXmlSql")
End Function

Private Function GetOfferCursor(ByVal as_COF_Id As String) As Long
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  GetOfferCursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req, 1)
  Exit Function
ErrHandler:
  Call ErrHandler("GetOfferCursor")
End Function

Private Function GetOfferDetailCursor(ByVal as_COF_Id As String) As Long
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "X", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  GetOfferDetailCursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  Exit Function
ErrHandler:
  Call ErrHandler("GetOfferDetailCursor")
End Function

Private Function GetXmlMasterSql() As TXmlSql
On Error GoTo ErrHandler

Dim ll_Idx As Long
  
  For ll_Idx = 0 To UBound(mta_XmlSql)
    If mta_XmlSql(ll_Idx).ATS_IsMaster Then
      GetXmlMasterSql = mta_XmlSql(ll_Idx)
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrHandler("GetXmlMasterSql")
End Function

Private Function Bae_FormatXMLDateTime(ByVal ad_Value As Date) As String
On Error GoTo ErrHandler
  
  Bae_FormatXMLDateTime = Format(ad_Value, "mm\/dd\/yyyy hh:mm:ss")
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_FormatXMLDateTime")
End Function

Private Function SAP_FormatXMLDateTime(ByVal ad_Value As Date) As String
On Error GoTo ErrHandler
  
  If ad_Value = 0 Then
    SAP_FormatXMLDateTime = ""
  Else
    SAP_FormatXMLDateTime = Format(ad_Value, "yyyymmdd")
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_FormatXMLDateTime")
End Function

Private Function BAE_FormatXMLFloat(ByVal ad_Value As Double, ByVal al_Precision As Long) As String
On Error GoTo ErrHandler

  If al_Precision = 0 Then
    BAE_FormatXMLFloat = Format(Round(ad_Value, al_Precision), "0")
  Else
    BAE_FormatXMLFloat = Replace(Format(Round(ad_Value, al_Precision), "0." & String(al_Precision, "0")), ".", ",", , , vbTextCompare)
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("BAE_FormatXMLFloat")
End Function

Private Function SAP_FormatXMLFloat(ByVal ad_Value As Double, ByVal al_Precision As Long) As String
On Error GoTo ErrHandler

  If al_Precision = 0 Then
    SAP_FormatXMLFloat = Format(Round(ad_Value, al_Precision), "0")
  Else
    SAP_FormatXMLFloat = Replace(Format(Round(ad_Value, al_Precision), "0." & String(al_Precision, "0")), ",", ".", , , vbTextCompare)
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_FormatXMLFloat")
End Function

Private Function BAE_FormatXMLInt(ByVal al_Value As Long) As String
On Error GoTo ErrHandler
  
  BAE_FormatXMLInt = CStr(al_Value)
  Exit Function
ErrHandler:
  Call ErrHandler("BAE_FormatXMLInt")
End Function

Private Function SAP_FormatXMLInt(ByVal al_Value As Long) As String
On Error GoTo ErrHandler
  
  SAP_FormatXMLInt = CStr(al_Value)
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_FormatXMLInt")
End Function

Private Function AppendElement(ByRef ao_Document As MSXML2.DOMDocument, ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_Name As String, ByVal as_Value As String) As MSXML2.IXMLDOMNode
On Error GoTo ErrHandler
    
   Set AppendElement = Nothing
    
#If LIVE = 1 Then
    Dim lo_newNode As Object
#Else
    Dim lo_newNode As MSXML2.IXMLDOMElement
#End If
    Set lo_newNode = ao_Document.createElement(as_Name)
    
    lo_newNode.Text = as_Value
    If ao_parentNode Is Nothing Then
      Set AppendElement = ao_Document.appendChild(lo_newNode)
    Else
      Set AppendElement = ao_parentNode.appendChild(lo_newNode)
    End If
    Exit Function
ErrHandler:
    Call ErrHandler("AppendElement")
End Function

'Public Sub Bae_ImportArticleAll()
'On Error GoTo ErrHandler
'
'Dim lc_Cursor As Long
'Dim ls_req As String
'Dim ll_RowIdTran As Long
'Dim ls_Result As String
'Dim le_Status As Long
'
'  ls_req = "exec DPC_BaeurerPrd_lst $PRD_Id$,$PMaster_Status$,$SBox_Status$"
'  ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
'  ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esExported), , vbTextCompare)
'  ls_req = Replace(ls_req, "$SBox_Status$", "NULL", , , vbTextCompare)
'  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
'  While Not mo_Db.EOF(lc_Cursor)
'    ll_RowIdTran = mo_Db.GetFields(lc_Cursor, "PMaster_Rowidtran")
'    ls_Result = Bae_CheckArticleExportResult(ll_RowIdTran)
'
'    le_Status = eDPCBaeurerExportStatus.esNone
'    If StrComp(ls_Result, ROWIDTRANSTATUS_ERROR, vbTextCompare) = 0 Then
'      le_Status = eDPCBaeurerExportStatus.esExportFailed
'    ElseIf StrComp(ls_Result, ROWIDTRANSTATUS_ERROR, vbTextCompare) = 0 Then
'      le_Status = eDPCBaeurerExportStatus.esExportOK
'    End If
'
'    If le_Status <> eDPCBaeurerExportStatus.esNone Then
'      ls_req = "UPDATE DPC_PrdBaeurer SET "
'      ls_req = ls_req & "PMaster_Status=$PMaster_Status$,"
'      ls_req = ls_req & "PMaster_Date=getdate(),"
'      ls_req = ls_req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
'      ls_req = ls_req & "Z_Last_Upd=getdate(),"
'      ls_req = ls_req & "WHERE PRD_Id=$PRD_Id$"
'      ls_req = Replace(ls_req, "$PRD_Id$", "NULL", , , vbTextCompare)
'      ls_req = Replace(ls_req, "$PMaster_Status$", mo_Tools.SqlInt(le_Status), , vbTextCompare)
'      Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req, 1)
'    End If
'    Call mo_Db.Next(lc_Cursor)
'  Wend
'  Call mo_Db.Close(lc_Cursor)
'  Exit Sub
'ErrHandler:
'  Call ErrHandler("Bae_ImportArticleAll")
'End Sub

'Public Sub Bae_ExportArticleAll()
'On Error GoTo ErrHandler
'
'Dim lc_Cursor As Long
'Dim ls_Req As String
'Dim ll_RowIdTran As Long
'
'  ls_Req = "exec DPC_BaeurerPrd_lst $PRD_Id$,$PMaster_Status$,$SBox_Status$"
'  ls_Req = Replace(ls_Req, "$PRD_Id$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esReadyToExport), , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$SBox_Status$", "NULL", , , vbTextCompare)
'  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Req)
'  While Not mo_Db.EOF(lc_Cursor)
'    ll_RowIdTran = Bae_ExportArticle(mo_Db.GetFields(mo_Db, "PRD_Id"))
'
'    ls_Req = "UPDATE DPC_PrdBaeurer SET "
'    ls_Req = ls_Req & "PMaster_Status=$PMaster_Status$,"
'    ls_Req = ls_Req & "PMaster_Date=getdate(),"
'    ls_Req = ls_Req & "PMaster_Rowidtran=$Rowidtran$,"
'    ls_Req = ls_Req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
'    ls_Req = ls_Req & "Z_Last_Upd=getdate(),"
'    ls_Req = ls_Req & "WHERE PRD_Id=$PRD_Id$"
'    ls_Req = Replace(ls_Req, "$PRD_Id$", "NULL", , , vbTextCompare)
'    ls_Req = Replace(ls_Req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esExported), , vbTextCompare)
'    ls_Req = Replace(ls_Req, "$Rowidtran$", mo_Tools.SqlInt(ll_RowIdTran), , vbTextCompare)
'    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Req, 1)
'    Call mo_Db.Next(lc_Cursor)
'  Wend
'  Call mo_Db.Close(lc_Cursor)
'  Exit Sub
'ErrHandler:
'  Call ErrHandler("Bae_ExportArticleAll")
'End Sub

Public Function Bae_ExportBOMMaterial(ByVal as_PRD_Id As String) As Boolean
On Error GoTo ErrHandler

Dim lo_DPC_Product As DPC_Product
Dim lo_BOM As DPC_BOM

  Bae_ExportBOMMaterial = False
  Set lo_DPC_Product = New DPC_Product
  Set lo_DPC_Product.Tools = mo_Tools
  Set lo_DPC_Product.ArmDb = mo_Db
  lo_DPC_Product.U_Code = ml_U_Code
  lo_DPC_Product.CT_Code = ms_CT_Code
  lo_DPC_Product.CURR_Code = "EUR"
  lo_DPC_Product.ValidityDate = ValidityDate
  lo_DPC_Product.Language_Code = ms_Language_Code
  Call lo_DPC_Product.Load_A_COM
  Call lo_DPC_Product.Load(as_PRD_Id)
  Call lo_DPC_Product.LoadBOM
  For Each lo_BOM In lo_DPC_Product.BOMs
    If (StrComp(lo_BOM.BOM_IdentNr, DPC_BOM_NEW_IDENTNR, vbTextCompare) = 0) And (lo_BOM.BOM_IdentNrTmp <> "") Then
      If lo_BOM.BOM_Categ = eDPCBOMMaterial.bcCoil Then
        lo_BOM.BOM_Thick = lo_DPC_Product.RPL_Thick
        If Bae_ExportCoil(lo_BOM) Then
          lo_DPC_Product.COI_Code = lo_BOM.BOM_IdentNr
          Call lo_DPC_Product.UpdatePrdRectPanel
          Call lo_BOM.UpdateBOMExport(mo_Db, ml_U_Code)
        Else
          Exit Function
        End If
      ElseIf lo_BOM.BOM_Categ = eDPCBOMMaterial.bcInlay Then
        lo_BOM.BOM_Name = lo_BOM.CreateInlayName(mo_Db, "Akustikvlieszuschnitt")
        If Bae_ExportInlay(lo_BOM) Then
          Call lo_BOM.UpdateBOMExport(mo_Db, ml_U_Code)
        Else
          Exit Function
        End If
      Else
        Exit Function
      End If
    End If
  Next
  Call lo_DPC_Product.Unload_A_COM
  Set lo_DPC_Product = Nothing
  Bae_ExportBOMMaterial = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ExportBOMMaterial")
End Function

Public Function Bae_ExportCoil(ByVal ao_BOM As DPC_BOM) As Boolean
On Error GoTo ErrHandler

Dim lo_XmlDocCoil As Object
Dim ll_RowIdTran As Long
Dim lc_Cursor As Long
Dim ll_VersionCoil As Long
Dim ls_req As String
Dim ls_ThickPrefix As String
Dim ls_IdentPrefix As String
Dim ls_IdentNr As String
Dim ls_IdentNrTmp As String
Dim le_RawMaterial As eDPCBOMMaterial
Dim ls_Material As String
Dim ls_MaterialName As String
Dim lo_CustomData As Dictionary

  Bae_ExportCoil = False
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  'Call Bae_DeleteMaterialCache(mo_DbBaeurer)
  
  ls_IdentNr = ""
  ls_IdentNrTmp = ao_BOM.BOM_IdentNrTmp
  ls_IdentPrefix = Left(ao_BOM.BOM_IdentNrTmp, 2)
  
  le_RawMaterial = eDPCBOMMaterial.bcCoil
  ls_Material = ao_BOM.BOM_Material
  ls_MaterialName = "Spaltband " & mo_Tools.DblToScreen(ao_BOM.BOM_CutWidth) & " x " & mo_Tools.DblToScreen(ao_BOM.BOM_Thick)
  
  ls_req = "exec DPC_Bae_Material_sel $IdentNr$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$"
  ls_req = Replace(ls_req, "$IdentNr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(le_RawMaterial), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", mo_Tools.SqlDbl(ao_BOM.BOM_Thick), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_IdentNr = mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr")
    ls_MaterialName = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Name")
    ls_Material = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Mat")
  End If
  Call mo_Db.Close(lc_Cursor)
  
  If ls_IdentNr <> "" Then
    ao_BOM.BOM_IdentNr = ls_IdentNr
    ao_BOM.BOM_Name = ls_MaterialName
    ao_BOM.BOM_Material = ls_Material
    Bae_ExportCoil = True
    Exit Function
  End If
   
'  ls_req = "SELECT TOP 1 g000.IdentNr "
'  ls_req = ls_req & "FROM g000 "
'  ls_req = ls_req & "LEFT JOIN g040 ON (g000.fi_nr = g040.fi_nr AND g000.identnr = g040.identnr ) "
'  ls_req = ls_req & "LEFT JOIN g0402 ON (g000.fi_nr = g0402.fi_nr AND g000.identnr = g0402.identnr and g0402.lang_ext ='de_de') "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Width ON (g000.objektid = g711Width.objektid and g711Width.kritnr = 12) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Thick ON (g000.objektid = g711Thick.objektid and g711Thick.kritnr = 17) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711SpecWeight ON (g000.objektid = g711SpecWeight.objektid and g711SpecWeight.kritnr = 20) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Waste ON (g000.objektid = g711Waste.objektid and g711Waste.kritnr = 54) "
'  ls_req = ls_req & "LEFT JOIN g020 ON (g000.identnr = g020.identnr) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711StdCoil ON (g000.objektid = g711StdCoil.objektid and g711StdCoil.kritnr = 1181) "
'  ls_req = ls_req & "LEFT JOIN g023 ON (g000.fi_nr = g023.fi_nr AND g000.identnr = g023.identnr) "
'  ls_req = ls_req & "LEFT JOIN g030 on (g000.identnr = g030.identnr AND g000.fi_nr = g030.fi_nr) "
'  ls_req = ls_req & "WHERE "
'  ls_req = ls_req & "(g000.identnr LIKE $MAT_Pefx$) AND "
'  ls_req = ls_req & "(g0402.werkstoff = $MAT_Werk$) AND "
'  ls_req = ls_req & "(g040.ts = $ts$) AND "
'  ls_req = ls_req & "(g020.lgnr = $lgnr$) "
'
'  ls_req = Replace(ls_req, "$MAT_Pefx$", mo_Tools.SQLStr(as_IdentPrefix & "%"), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$ts$", mo_Tools.SQLStr(1), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$lgnr$", mo_Tools.SqlInt(0), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$MAT_Werk$", mo_Tools.SQLStr(as_Material), , , vbTextCompare)
'
'
'  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
'  ls_Key = mo_DbBaeurer.GetFields(lc_Cursor, 0)
'  Call mo_DbBaeurer.Close(lc_Cursor)
  
  ls_req = "SELECT MAX(g000.identnr) "
  ls_req = ls_req & "FROM g000 "
  ls_req = ls_req & "WHERE "
  ls_req = ls_req & "(g000.identnr LIKE $MAT_Pefx$) AND (LEN(g000.identnr) = $lenght$)"
  
'  ls_req = "SELECT MAX(g000.identnr) as IdentNr "
'  ls_req = ls_req & "FROM g000 "
'  ls_req = ls_req & "LEFT JOIN g040 ON (g000.fi_nr = g040.fi_nr AND g000.identnr = g040.identnr ) "
'  ls_req = ls_req & "LEFT JOIN g0402 ON (g000.fi_nr = g0402.fi_nr AND g000.identnr = g0402.identnr and g0402.lang_ext ='de_de') "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Width ON (g000.objektid = g711Width.objektid and g711Width.kritnr = 12) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Thick ON (g000.objektid = g711Thick.objektid and g711Thick.kritnr = 17) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711SpecWeight ON (g000.objektid = g711SpecWeight.objektid and g711SpecWeight.kritnr = 20) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711Waste ON (g000.objektid = g711Waste.objektid and g711Waste.kritnr = 54) "
'  ls_req = ls_req & "LEFT JOIN g020 ON (g000.identnr = g020.identnr) "
'  ls_req = ls_req & "LEFT JOIN g711 as g711StdCoil ON (g000.objektid = g711StdCoil.objektid and g711StdCoil.kritnr = 1181) "
'  ls_req = ls_req & "LEFT JOIN g023 ON (g000.fi_nr = g023.fi_nr AND g000.identnr = g023.identnr) "
'  ls_req = ls_req & "LEFT JOIN g030 on (g000.identnr = g030.identnr AND g000.fi_nr = g030.fi_nr) "
'  ls_req = ls_req & "WHERE "
'  ls_req = ls_req & "((g000.identnr LIKE $MAT_Pefx$) AND (LEN(g000.identnr) = $lenght$)) AND "
'  ls_req = ls_req & "(g0402.werkstoff = $MAT_Werk$ OR $MAT_Werk$ IS NULL) AND "
'  ls_req = ls_req & "(g040.ts = $ts$) AND "
'  ls_req = ls_req & "(g020.lgnr = $lgnr$) "
  
  
  ls_ThickPrefix = Trim(Str(ao_BOM.BOM_Thick))
  If Left(ls_ThickPrefix, 1) = "." Then ls_ThickPrefix = "0" & ls_ThickPrefix
  ls_ThickPrefix = Replace(ls_ThickPrefix, ".", "")
  
  ls_req = Replace(ls_req, "$MAT_Pefx$", mo_Tools.SQLStr(ls_IdentPrefix & ls_ThickPrefix & "%"), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$ts$", mo_Tools.SQLStr(1), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$lgnr$", mo_Tools.SqlInt(0), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$MAT_Werk$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$lenght$", mo_Tools.SqlInt(Len(ls_IdentPrefix & ls_ThickPrefix) + 4), , , vbTextCompare)
  
  ls_IdentNr = mo_Tools.SelectValue(mo_DbBaeurer, ls_req)
  
  Do
    If ls_IdentNr = "" Then
      ls_IdentNr = ls_IdentPrefix & ls_ThickPrefix & "0001"
    Else
      If right(ls_IdentNr, 4) = "9999" Then
        Call MsgBox("Counter IdentNr for coil prefix: " & ls_IdentPrefix & ls_ThickPrefix & " overflow")
        Exit Function
      Else
        ls_IdentNr = ls_IdentPrefix & ls_ThickPrefix & (right("0000" & Val(right(ls_IdentNr, 4)) + 1, 4))
      End If
    End If
    'check if we recently did not use this identnr for another coil, need to create new identr by incrementing
    ls_req = "exec DPC_Bae_Material_sel $IdentNr$, $BMN_Type$, $BMN_Prefix$, $BMN_Mat$, $BMN_Length$, $BMN_Width$, $BMN_Height$, $BMN_Thick$"
    ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcCoil), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Prefix$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Mat$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Length$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Width$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Thick$", "NULL", , , vbTextCompare)
  Loop Until mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr") = ""
  
  Set lo_CustomData = New Dictionary
  Call lo_CustomData.Add("$identnr$", ls_IdentNr)
  Call lo_CustomData.Add("$ben$", ls_MaterialName)
  Call lo_CustomData.Add("$werkstoff$", ls_Material)
  Call lo_CustomData.Add("$breiteb$", ao_BOM.BOM_CutWidth)
  Call lo_CustomData.Add("$matdicke$", ao_BOM.BOM_Thick)
  Call lo_CustomData.Add("$stlidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$aplidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$vpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$orpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$invpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$datvon$", ao_BOM.BOM_DatVon)
  Call lo_CustomData.Add("$menge_ab$", ao_BOM.BOM_Menge_Ab)
  Set lo_XmlDocCoil = Bae_CreateXMLDocument(mo_DbBaeurer, eDPCXmlExportType.etBae_Material, ls_IdentNrTmp, ll_VersionCoil, lo_CustomData)
  
  Call Bae_SaveXMLDocument(lo_XmlDocCoil, "PMASTER", "")
  
  ll_RowIdTran = Bae_ExportPMasterRecord(mo_DbBaeurer, 0, ls_IdentNr, eDPCXmlExportType.etBae_Material, lo_XmlDocCoil, ll_VersionCoil)
  Call Bae_ExportPMasterComplete(mo_DbBaeurer, ll_RowIdTran)
  'insert exported ident nr into our historical table
  ls_req = "exec DPC_Bae_Material_ins $IdentNr$,$BMN_Name$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$, $U_Code$"
  ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Name$", mo_Tools.SQLStr(ls_MaterialName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcCoil), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", mo_Tools.SQLStr(ls_IdentPrefix), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_Material), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", "0", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "0", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", mo_Tools.SqlDbl(ao_BOM.BOM_Thick), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  ao_BOM.BOM_IdentNr = ls_IdentNr
  ao_BOM.BOM_Name = ls_MaterialName
  ao_BOM.BOM_Material = ls_Material
  
  Call lo_CustomData.RemoveAll
  Set lo_CustomData = Nothing
  Bae_ExportCoil = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ExportCoil")
End Function

Private Function Bae_DeleteMaterialCache(ByVal ao_DbBaeurer As Object)
On Error GoTo ErrHandler

Dim ls_req As String
Dim ls_ReqCache As String
Dim lc_Cursor As Long
Dim ls_IdentNr As String

  ls_ReqCache = "exec DPC_Bae_Material_del $IdentNr$, $U_Code$"
  ls_req = "SELECT DBM.IdentNr FROM DPC_Bae_Material DBM "
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    ls_IdentNr = mo_Db.GetFields(lc_Cursor, "IdentNr")
  
    If mo_Tools.SelectValue(ao_DbBaeurer, "SELECT COUNT(*) FROM g000 WHERE IdentNr= " & mo_Tools.SQLStr(ls_IdentNr)) = 1 Then
      ls_req = ls_ReqCache
      ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
      ls_req = ReplaceCommonPlaceholders(ls_req)
      Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
    End If
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_DeleteMaterialCache")
End Function

Public Function Bae_ExportInlay(ByVal ao_BOM As DPC_BOM) As Boolean
On Error GoTo ErrHandler

Dim lo_XmlDocInlay As Object
Dim ll_RowIdTran As Long
Dim lc_Cursor As Long
Dim ll_VersionInlay As Long
Dim ls_req As String
Dim ls_IdentNr As String
Dim ls_IdentPrefix As String
Dim ls_IdentNrTmp As String
Dim le_RawMaterial As eDPCBOMMaterial
Dim ls_Material As String
Dim ls_MaterialName As String
Dim lo_CustomData As Dictionary
Dim ls_UoM_PCS As String

  Bae_ExportInlay = False
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  'Call Bae_DeleteMaterialCache(mo_DbBaeurer)
  
  ls_IdentNr = ""
  ls_IdentNrTmp = ao_BOM.BOM_IdentNrTmp
  ls_IdentPrefix = Trim(mo_Tools.GetAConfigData("DPC_BAE_INLAYPREFIX"))
  ls_MaterialName = ao_BOM.BOM_Name
  le_RawMaterial = eDPCBOMMaterial.bcInlay
  ls_Material = ao_BOM.BOM_Material
  
  ls_req = "exec DPC_Bae_Material_sel $IdentNr$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$"
  ls_req = Replace(ls_req, "$IdentNr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcInlay), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", mo_Tools.SQLStr(ls_IdentPrefix), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_IdentNrTmp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", mo_Tools.SqlDbl(ao_BOM.BOM_CutLength), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", "NULL", , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ls_IdentNr = mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr")
    ls_MaterialName = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Name")
    ls_Material = mo_Tools.SelectValue(mo_Db, ls_req, "BMN_Mat")
  End If
  Call mo_Db.Close(lc_Cursor)

  If ls_IdentNr <> "" Then
    ao_BOM.BOM_IdentNr = ls_IdentNr
    ao_BOM.BOM_Name = ls_MaterialName
    ao_BOM.BOM_Material = ls_Material
    Bae_ExportInlay = True
    Exit Function
  End If
  
  
  ls_req = "SELECT MAX(g000.identnr) "
  ls_req = ls_req & "FROM g000 "
  ls_req = ls_req & "WHERE "
  ls_req = ls_req & "(g000.identnr LIKE $MAT_Pefx$) AND (LEN(g000.identnr) = $lenght$)"
  
  ls_req = Replace(ls_req, "$MAT_Pefx$", mo_Tools.SQLStr(ls_IdentPrefix & "%"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lenght$", mo_Tools.SqlInt(Len(ls_IdentPrefix) + 4), , , vbTextCompare)
  
  ls_IdentNr = mo_Tools.SelectValue(mo_DbBaeurer, ls_req)
  
  Do
    If ls_IdentNr = "" Then
      ls_IdentNr = ls_IdentPrefix & "0001"
    Else
      If right(ls_IdentNr, 4) = "9999" Then
        Call MsgBox("Counter IdentNr for inlay prefix: " & ls_IdentPrefix & " overflow")
        Exit Function
      Else
        ls_IdentNr = ls_IdentPrefix & (right("0000" & Val(right(ls_IdentNr, 4)) + 1, 4))
      End If
    End If
    'check if we recently did not use this identnr for another coil, need to create new identr by incrementing
    ls_req = "exec DPC_Bae_Material_sel $IdentNr$, $BMN_Type$, $BMN_Prefix$, $BMN_Mat$, $BMN_Length$, $BMN_Width$, $BMN_Height$, $BMN_Thick$"
    ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcInlay), , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Prefix$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Mat$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Length$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Width$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Height$", "NULL", , , vbTextCompare)
    ls_req = Replace(ls_req, "$BMN_Thick$", "NULL", , , vbTextCompare)
  Loop Until mo_Tools.SelectValue(mo_Db, ls_req, "IdentNr") = ""
  
  
  Set lo_CustomData = New Dictionary
  ls_UoM_PCS = mo_Tools.ConvertCodeToBaeurer(mo_Db, eDPCCodeConversionBaeurer.ccUnitOfMeasure, ao_BOM.UM_Code)
  Call lo_CustomData.Add("$identnr$", ls_IdentNr)
  Call lo_CustomData.Add("$ben$", ls_MaterialName)
  Call lo_CustomData.Add("$werkstoff$", ls_Material)
  Call lo_CustomData.Add("$laengea$", ao_BOM.BOM_CutLength)
  Call lo_CustomData.Add("$breiteb$", ao_BOM.BOM_CutWidth)
  Call lo_CustomData.Add("$me$", ls_UoM_PCS)
  Call lo_CustomData.Add("$mes$", ls_UoM_PCS)
  Call lo_CustomData.Add("$stlidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$aplidentnr$", ls_IdentNr)
  Call lo_CustomData.Add("$qm$", (ao_BOM.BOM_CutLength * ao_BOM.BOM_CutWidth) / 1000000)
  Call lo_CustomData.Add("$vpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$orpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$invpreis$", ao_BOM.BOM_Cost)
  Call lo_CustomData.Add("$datvon$", ao_BOM.BOM_DatVon)
  Call lo_CustomData.Add("$menge_ab$", ao_BOM.BOM_Menge_Ab)
  
  Set lo_XmlDocInlay = Bae_CreateXMLDocument(mo_DbBaeurer, eDPCXmlExportType.etBae_Material, ls_IdentNrTmp, ll_VersionInlay, lo_CustomData)
  
  Call Bae_SaveXMLDocument(lo_XmlDocInlay, "PMASTER", "")
  
  ll_RowIdTran = Bae_ExportPMasterRecord(mo_DbBaeurer, 0, ls_IdentNr, eDPCXmlExportType.etBae_Material, lo_XmlDocInlay, ll_VersionInlay)
  Call Bae_ExportPMasterComplete(mo_DbBaeurer, ll_RowIdTran)
  'insert exported ident nr into our historical table
  ls_req = "exec DPC_Bae_Material_ins $IdentNr$,$BMN_Name$,$BMN_Type$,$BMN_Prefix$,$BMN_Mat$,$BMN_Length$,$BMN_Width$,$BMN_Height$,$BMN_Thick$, $U_Code$"
  ls_req = Replace(ls_req, "$IdentNr$", mo_Tools.SQLStr(ls_IdentNr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Name$", mo_Tools.SQLStr(ls_MaterialName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Type$", mo_Tools.SqlInt(eDPCBOMMaterial.bcInlay), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Prefix$", mo_Tools.SQLStr(ls_IdentPrefix), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Mat$", mo_Tools.SQLStr(ls_IdentNrTmp), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Length$", mo_Tools.SqlDbl(ao_BOM.BOM_CutLength), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Width$", mo_Tools.SqlDbl(ao_BOM.BOM_CutWidth), , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Height$", "0", , , vbTextCompare)
  ls_req = Replace(ls_req, "$BMN_Thick$", "0", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  ao_BOM.BOM_IdentNr = ls_IdentNr
  ao_BOM.BOM_Name = ls_MaterialName
  ao_BOM.BOM_Material = ls_Material
  
  Call lo_CustomData.RemoveAll
  Set lo_CustomData = Nothing
  
  Bae_ExportInlay = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ExportInlay")
End Function

Public Function Bae_ExportArticleCollection(ByVal ao_Collection As Collection, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim ls_PRD_Id As String
Dim ls_PRD_Code As String
Dim lb_Result As Boolean
Dim lc_Cursor As Long
Dim ls_BOM_PRD_Code As String, ls_BOR_PRD_Code As String
Dim lsa_PRD_Code() As String
Dim ll_Idx As Long

  Bae_ExportArticleCollection = False
  
  If (ao_Collection Is Nothing) Then
    Exit Function
  End If
  If (ao_Collection.Count = 0) Then
    Exit Function
  End If
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    Exit Function
  End If
  
  as_ErrorMsg = ""
  ls_BOM_PRD_Code = ""
  ls_BOR_PRD_Code = ""
  lb_Result = True
  ReDim lsa_PRD_Code(ao_Collection.Count - 1)
  
  For ll_Idx = 1 To ao_Collection.Count
    ls_PRD_Id = ao_Collection(ll_Idx)
    ls_req = "exec DPC_Bae_ArticleCheck_lst $PRD_Id$"
    ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(ls_PRD_Id), , , vbTextCompare)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    ls_PRD_Code = mo_Db.GetFields(lc_Cursor, "PRD_Code")
    If (mo_Db.GetFields(lc_Cursor, "BOMCount") = 0) Or (mo_Db.GetFields(lc_Cursor, "BOMErrorCount") > 0) Then
      If ls_BOM_PRD_Code <> "" Then
        ls_BOM_PRD_Code = ls_BOM_PRD_Code & ", "
      End If
      ls_BOM_PRD_Code = ls_BOM_PRD_Code & ls_PRD_Code
      lb_Result = False
    End If
    If (mo_Db.GetFields(lc_Cursor, "BORCount") = 0) Or (mo_Db.GetFields(lc_Cursor, "BORErrorCount") > 0) Then
      If ls_BOR_PRD_Code <> "" Then
        ls_BOR_PRD_Code = ls_BOR_PRD_Code & ", "
      End If
      ls_BOR_PRD_Code = ls_BOR_PRD_Code & ls_PRD_Code
      lb_Result = False
    End If
    lsa_PRD_Code(ll_Idx - 1) = ls_PRD_Code
    Call mo_Db.Close(lc_Cursor)
  Next
  
  If ls_BOM_PRD_Code <> "" Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9869, "#Article has empty or error BOM: $PRD_Code$", Array("$PRD_Code$", ls_BOM_PRD_Code)) & vbCrLf
  End If
  If ls_BOR_PRD_Code <> "" Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9870, "#Article has empty or error BOR: $PRD_Code$", Array("$PRD_Code$", ls_BOR_PRD_Code)) & vbCrLf
  End If
  If Not lb_Result Then
    Bae_ExportArticleCollection = False
    Exit Function
  End If
  
  For ll_Idx = 1 To ao_Collection.Count
    ls_PRD_Id = ao_Collection(ll_Idx)
    ls_PRD_Code = lsa_PRD_Code(ll_Idx - 1)
    ls_req = "UPDATE DPC_PrdCommon SET PRD_StaBae=$PRD_StaBae$,PRD_InfoBae=$PRD_InfoBae$ WHERE PRD_Id=$PRD_Id$"
    
    If Bae_ExportArticle(ls_PRD_Id, ls_PRD_Code) Then
      ls_req = Replace(ls_req, "$PRD_StaBae$", mo_Tools.SqlInt(eDPCInterfaceStatus.isOK), , , vbTextCompare)
    Else
      ls_req = Replace(ls_req, "$PRD_StaBae$", mo_Tools.SqlInt(eDPCInterfaceStatus.isFailed), , , vbTextCompare)
      lb_Result = False
      If as_ErrorMsg <> "" Then
        as_ErrorMsg = as_ErrorMsg & ", "
      End If
      as_ErrorMsg = as_ErrorMsg & ls_PRD_Code
    End If
    ls_req = Replace(ls_req, "$PRD_InfoBae$", mo_Tools.SQLStr("", 250), , , vbTextCompare)
    ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(ls_PRD_Id), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Next
  Bae_ExportArticleCollection = lb_Result
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ExportArticleCollection")
End Function

Private Function Bae_ExportArticle(ByVal as_PRD_Id As String, ByVal as_PRD_Code As String) As Boolean
On Error GoTo ErrHandler

Dim lo_XmlDocPMaster As Object
Dim lo_XmlDocBOM As Object
Dim lo_XmlDocBOR As Object
Dim ll_RowIdTran As Long
Dim ll_VersionPMaster As Long
Dim ll_VersionBOM As Long
Dim ll_VersionBOR As Long

  Bae_ExportArticle = False
 
  If Not Bae_ExportBOMMaterial(as_PRD_Id) Then
    Exit Function
  End If
  
  Set lo_XmlDocPMaster = Bae_CreateXMLDocument(mo_Db, eDPCXmlExportType.etBae_ArticleMaster, as_PRD_Id, ll_VersionPMaster, Nothing)
  Set lo_XmlDocBOM = Bae_CreateXMLDocument(mo_Db, eDPCXmlExportType.etBae_BOM, as_PRD_Id, ll_VersionBOM, Nothing)
  Set lo_XmlDocBOR = Bae_CreateXMLDocument(mo_Db, eDPCXmlExportType.etBae_BOR, as_PRD_Id, ll_VersionBOR, Nothing)
  
  Call Bae_SaveXMLDocument(lo_XmlDocPMaster, "PMASTER", "")
  Call Bae_SaveXMLDocument(lo_XmlDocBOM, "BOM", "")
  Call Bae_SaveXMLDocument(lo_XmlDocBOR, "BOR", "")
  
  ll_RowIdTran = Bae_ExportPMasterRecord(mo_DbBaeurer, 0, as_PRD_Code, eDPCXmlExportType.etBae_ArticleMaster, lo_XmlDocPMaster, ll_VersionPMaster)
  Call Bae_ExportPMasterRecord(mo_DbBaeurer, ll_RowIdTran, as_PRD_Code, eDPCXmlExportType.etBae_BOM, lo_XmlDocBOM, ll_VersionBOM)
  Call Bae_ExportPMasterRecord(mo_DbBaeurer, ll_RowIdTran, as_PRD_Code, eDPCXmlExportType.etBae_BOR, lo_XmlDocBOR, ll_VersionBOR)
  Call Bae_ExportPMasterComplete(mo_DbBaeurer, ll_RowIdTran)
  
  Bae_ExportArticle = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ExportArticle")
End Function

Private Function Bae_CheckArticleExportResult(ByVal al_RowIdTran As Long) As String
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim lc_FilterError As Long
Dim ll_CountError As Long
Dim lc_FilterOK As Long
Dim ll_CountOK As Long

  Bae_CheckArticleExportResult = ""
  ls_req = "SELECT status_tran FROM tran_sc WHERE rowidtran=$rowidtran$"
  ls_req = Replace(ls_req, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  If mo_DbBaeurer.RowCount(lc_Cursor) = 3 Then
  
    lc_FilterError = mo_DbBaeurer.Filter(lc_Cursor, "status_tran", "=", ROWIDTRANSTATUS_ERROR, 1)
    ll_CountError = mo_DbBaeurer.RowCount(lc_FilterError)
    Call mo_DbBaeurer.Close(lc_FilterError)
    
    lc_FilterOK = mo_DbBaeurer.Filter(lc_Cursor, "status_tran", "=", ROWIDTRANSTATUS_OK, 1)
    ll_CountOK = mo_DbBaeurer.RowCount(lc_FilterOK)
    Call mo_DbBaeurer.Close(lc_FilterOK)
    
    If ll_CountError > 0 Then
      Bae_CheckArticleExportResult = ROWIDTRANSTATUS_ERROR
    ElseIf ll_CountOK = 3 Then
      Bae_CheckArticleExportResult = ROWIDTRANSTATUS_OK
    End If
  End If
  Call mo_DbBaeurer.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_CheckArticleExportResult")
End Function

Private Function Bae_CheckCustomerExportResult(ByVal al_RowIdTran As Long) As String
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Bae_CheckCustomerExportResult = ""
  ls_req = "SELECT status_tran FROM tran_cus WHERE rowidtran=$rowidtran$"
  ls_req = Replace(ls_req, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  If mo_DbBaeurer.RowCount(lc_Cursor) = 1 Then
  
    If StrComp(mo_DbBaeurer.GetFields(lc_Cursor, "status_tran"), ROWIDTRANSTATUS_ERROR, vbTextCompare) = 0 Then
      Bae_CheckCustomerExportResult = ROWIDTRANSTATUS_ERROR
    ElseIf StrComp(mo_DbBaeurer.GetFields(lc_Cursor, "status_tran"), ROWIDTRANSTATUS_OK, vbTextCompare) = 0 Then
      Bae_CheckCustomerExportResult = ROWIDTRANSTATUS_OK
    End If
  End If
  Call mo_DbBaeurer.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_CheckCustomerExportResult")
End Function

Private Function Bae_CreateBaeurerConnection(ByVal ao_Db As Object) As Long
On Error GoTo ErrHandler

Dim ll_ConnectId As Long
Dim ls_req As String

  ls_req = "INSERT INTO b050 "
  ls_req = ls_req & "(connect_id ,logname, tty, datuhr, gruppe, session_id, logname_os, serverapp)"
  ls_req = ls_req & " VALUES "
  ls_req = ls_req & "($connect_id$ ,$logname$, $tty$, getdate(), $gruppe$, @@SPID, $logname_os$, $serverapp$)"
  
  ls_req = Replace(ls_req, "$connect_id$", mo_Tools.SqlInt(DPC_DEFUALT_BAEURER_CONNECTID), , , vbTextCompare)
  ls_req = Replace(ls_req, "$logname$", mo_Tools.SQLStr(ms_BaeurerLoginName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$tty$", mo_Tools.SQLStr(ms_PC_Name), , , vbTextCompare)
  ls_req = Replace(ls_req, "$gruppe$", mo_Tools.SQLStr("badmin"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$session_id$", mo_Tools.SqlInt(DPC_DEFUALT_BAEURER_CONNECTID), , , vbTextCompare)
  ls_req = Replace(ls_req, "$logname_os$", mo_Tools.SQLStr(ms_BaeurerLoginName), , , vbTextCompare)
  ls_req = Replace(ls_req, "$serverapp$", mo_Tools.SQLStr(ms_BaeurerServer), , , vbTextCompare)
  
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  Bae_CreateBaeurerConnection = DPC_DEFUALT_BAEURER_CONNECTID
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_CreateBaeurerConnection")
End Function

Private Function Bae_CloseBaeurerConnection(ByVal ao_Db As Object, ByVal al_Connect_Id As Long) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
  
  ls_req = "DELETE FROM b050 WHERE connect_id=$connect_id$"
  ls_req = Replace(ls_req, "$connect_id$", mo_Tools.SqlInt(al_Connect_Id), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_CloseBaeurerConnection")
End Function

Private Function Bae_LockRecord(ByVal ao_Db As Object, ByVal as_Table As String, ByVal av_Key As Variant, as_Screen As String) As Long
On Error GoTo ErrHandler

Dim ls_req As String
Dim ls_Key As String

  Bae_LockRecord = 0
  If IsArray(av_Key) Then
    ls_Key = Join(av_Key, "@")
  Else
    ls_Key = Str(av_Key)
  End If
 
  Call Bae_CloseBaeurerConnection(mo_DbBaeurer, DPC_DEFUALT_BAEURER_CONNECTID)
  ml_BaeurerConnectID = Bae_CreateBaeurerConnection(ao_Db)
  If ml_BaeurerConnectID = 0 Then
    Exit Function
  End If
  
  ls_req = "SELECT COUNT(*) FROM b030 WHERE schluessel=$schluessel$"
  ls_req = Replace(ls_req, "$schluessel$", mo_Tools.SQLStr(ls_Key), , , vbTextCompare)
  If mo_Tools.SelectValue(ao_Db, ls_req) > 0 Then
    Call Bae_CloseBaeurerConnection(ao_Db, ml_BaeurerConnectID)
    ml_BaeurerConnectID = 0
    Exit Function
  End If

  ls_req = "INSERT INTO [b030] "
  ls_req = ls_req & "([tabelle] ,[fi_nr], [schluessel], [logname], [connect_id], [maske], [datuhr]) "
  ls_req = ls_req & " VALUES "
  ls_req = ls_req & "($tabelle$ ,$fi_nr$, $schluessel$, $logname$, $connect_id$, $maske$, getdate())"
  
  ls_req = Replace(ls_req, "$tabelle$", mo_Tools.SQLStr(as_Table), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$schluessel$", mo_Tools.SQLStr(ls_Key), , , vbTextCompare)
  ls_req = Replace(ls_req, "$logname$", mo_Tools.SQLStr(ms_BaeurerSource), , , vbTextCompare)
  ls_req = Replace(ls_req, "$maske$", mo_Tools.SQLStr(as_Screen), , , vbTextCompare)
  ls_req = Replace(ls_req, "$connect_id$", mo_Tools.SqlInt(ml_BaeurerConnectID), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req, 1)
  
  Bae_LockRecord = mo_Tools.GetLastIdentity(ao_Db)
  Exit Function
ErrHandler:
  'do nothing, lock was not succesfull it will be shown in the message
End Function

Private Sub Bae_UnlockRecord(ByVal ao_Db As Object, ByVal al_RowId As Long)
On Error GoTo ErrHandler
  
Dim ls_Request As String
  
  ls_Request = "DELETE FROM [b030] WHERE rowid=$rowid$"
  ls_Request = Replace(ls_Request, "$rowid$", mo_Tools.SqlInt(al_RowId), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  Call Bae_CloseBaeurerConnection(mo_DbBaeurer, ml_BaeurerConnectID)
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_UnlockRecord")
End Sub

Private Function CreateNextIdOfferPos(ByVal ao_Collection As Collection)
On Error GoTo ErrHandler

Dim ls_OFD_IdParNew As String
Dim lo_Offer As DPC_OfferPos
  
  ls_OFD_IdParNew = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
  For Each lo_Offer In ao_Collection
    If lo_Offer.OFD_Main = eDPCOfferDetailMain.odMain Then
      lo_Offer.OFD_Id = ls_OFD_IdParNew
      lo_Offer.OFD_IdPar = ls_OFD_IdParNew
    Else
      lo_Offer.OFD_Id = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
      lo_Offer.OFD_IdPar = ls_OFD_IdParNew
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrHandler("CreateNextIdOfferPos")
End Function

Private Function CopyOfferPos(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByVal al_SplitNr As Long, ByRef al_OFD_PosSrc As Long) As String
On Error GoTo ErrHandler

Dim ls_req As String
Dim ls_OFD_IdParNew As String
Dim lo_Offer As DPC_OfferPos
Dim lo_Collection As Collection
Dim ls_Request As String
Dim lc_Cursor As Long

  Set lo_Collection = New Collection
  
  ls_Request = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_IdPar$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", "NULL", , , vbTextCompare)
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_Offer = New DPC_OfferPos
    Set lo_Offer.Tools = mo_Tools
    Call lo_Offer.ReadOfferPos(mo_Db, lc_Cursor)
    Call lo_Collection.Add(lo_Offer)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  
  ls_OFD_IdParNew = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
  For Each lo_Offer In lo_Collection
    lo_Offer.OFD_IdPar = ls_OFD_IdParNew
    lo_Offer.OFD_Pos = lo_Offer.OFD_Pos + (al_SplitNr * 10)
    If (lo_Offer.DOF_Id = eDPCOfferDetail.odPosition) Or _
       (lo_Offer.DOF_Id = eDPCOfferDetail.odSubconstPosition) Or _
       (lo_Offer.DOF_Id = eDPCOfferDetail.odManualPosition) Then
      lo_Offer.OFD_Id = ls_OFD_IdParNew
      al_OFD_PosSrc = lo_Offer.OFD_Pos
    Else
      lo_Offer.OFD_Id = mo_Tools.GetNextID(mo_Db, "Cap_OfferDetail")
    End If
    Call lo_Offer.Insert(mo_Db, ml_U_Code)
  Next
  CopyOfferPos = ls_OFD_IdParNew
  Exit Function
ErrHandler:
  Call ErrHandler("CopyOfferPos")
End Function

Private Sub Bae_UpdateOrderPositionFromPlaningBox(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByVal al_OFD_Split As Long, ByVal ac_PlanBoxCursor As Long)
On Error GoTo ErrHandler

Dim lo_Product As DPC_Product
Dim lo_Offer As DPC_OfferPos
Dim lo_Cutout As DPC_Cutout
Dim lo_Inlay As DPC_Inlay
Dim ls_PRD_Id As String
Dim ls_req As String
Dim ll_QtyPCS As Long

  'ls_req = "SELECT PRD_Id FROM Cap_OfferDetail WHERE COF_Id=$COF_Id$ AND OFD_Id=$OFD_Id$"
  ls_req = "exec Cap_OfferDetail_sel $COF_Id$, $OFD_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  ls_PRD_Id = mo_Tools.SelectValue(mo_Db, ls_req, "PRD_Id")
  
  If ls_PRD_Id = "" Then
    Err.Raise ArmErr.InvalidArgument, "ls_PRD_Id", "Article ID not found: as_COF_Id=" & as_COF_Id & " as_OFD_Id=" & as_OFD_Id
  End If
  
  Set lo_Product = New DPC_Product
  Set lo_Product.Tools = mo_Tools
  Set lo_Product.ArmDb = mo_Db
  lo_Product.CT_Code = ms_CT_Code
  lo_Product.ValidityDate = ValidityDate
  lo_Product.Language_Code = ms_Language_Code
  lo_Product.COF_Id = as_COF_Id
  lo_Product.U_Code = ml_U_Code
  Call lo_Product.Load_A_COM
  Call lo_Product.InitOffer
  Call lo_Product.Load(ls_PRD_Id)
  Call lo_Product.LoadOffer(as_COF_Id, as_OFD_Id)
    
  ll_QtyPCS = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "menge_best")
  If lo_Product.PanelQtyPCS <> ll_QtyPCS Then
    For Each lo_Offer In lo_Product.OfferPrice
      If (Not lo_Offer.DOF_IsStp) And (Not lo_Offer.DOF_IsTxt) Then
        Call lo_Offer.SetQty(DPC_UOM_PCS, ll_QtyPCS)
        Call lo_Offer.Update(mo_Db, ml_U_Code)
      End If
    Next
    For Each lo_Cutout In lo_Product.Cutouts
      For Each lo_Offer In lo_Cutout.OfferPrice
        If (Not lo_Offer.DOF_IsStp) And (Not lo_Offer.DOF_IsTxt) Then
          Call lo_Offer.SetQty(DPC_UOM_PCS, ll_QtyPCS)
          Call lo_Offer.Update(mo_Db, ml_U_Code)
        End If
      Next
    Next
    For Each lo_Inlay In lo_Product.Inlays
      For Each lo_Offer In lo_Inlay.OfferPrice
        If (Not lo_Offer.DOF_IsStp) And (Not lo_Offer.DOF_IsTxt) Then
          Call lo_Offer.SetQty(DPC_UOM_PCS, ll_QtyPCS)
          Call lo_Offer.Update(mo_Db, ml_U_Code)
        End If
      Next
    Next
    Call lo_Product.CalcPositionPrice
  End If
    
  Set lo_Offer = lo_Product.GetOfferPos(eDPCOfferDetail.odPosition)
  lo_Offer.OFD_ShpDat = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "lief_termb")
  lo_Offer.OFD_DelDat = lo_Offer.OFD_ShpDat
  lo_Offer.OFD_PlaDat = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "dataen")
  lo_Offer.OFD_PlaUsr = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "useraen")
  lo_Offer.OFD_B7Sta = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "kn_verarb")
  lo_Offer.OFD_Split = al_OFD_Split
  lo_Offer.OFD_InfoB7 = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "info_b7")
  lo_Offer.OFD_OrdNrB7 = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "aufnr")
  lo_Offer.OFD_PosB7 = mo_DbBaeurer.GetFields(ac_PlanBoxCursor, "aufpos")
  Call lo_Offer.Update(mo_Db, ml_U_Code)
  Call lo_Product.Unload_A_COM
  Set lo_Product = Nothing
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_UpdateOrderPositionFromPlaningBox")
End Sub

Private Sub Bae_UpdatePlaningBoxFromOrderPosition(ByVal as_COF_Code As String, ByVal al_OFD_Pos As Long, ByVal al_OFD_Split As Long, ByVal al_OFD_PosSrc As Long)
On Error GoTo ErrHandler

Dim ls_req As String
  ', kn_verarb=$kn_verarb_new$  - changed, status will be changed after XML export to SAP/B7
  ls_req = "UPDATE va1101 SET seblpos_q=$aufpos_q_new$, aufpos_q=$aufpos_q_new$ WHERE aufnr_q=$aufnr_q$ AND aufpos_q=$aufpos_q_old$ AND seblpos=$seblpos$ AND fi_nr=$fi_nr$ AND kn_verarb=$kn_verarb_old$"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q_old$", mo_Tools.SqlInt(al_OFD_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q_new$", mo_Tools.SqlInt(al_OFD_PosSrc), , , vbTextCompare)
  ls_req = Replace(ls_req, "$seblpos$", mo_Tools.SqlInt(al_OFD_Split), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SQLStr(BAE_PLABOX_RequestReadyForCapture), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestAcceptedByCapture), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_UpdatePlaningBoxFromOrderPosition")
End Sub

Private Function Bae_GetPlaningBoxStatus(ByVal as_COF_Code As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long
Dim ls_Status As String

  ' planning box needs to be locked
  ls_req = "SELECT DISTINCT kn_verarb FROM va1101 WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb NOT IN ($kn_verarb$) ORDER BY kn_verarb"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestConfirmationMarkedDelete, _
                                                                  BAE_PLABOX_RequestRefusedByCapture, _
                                                                  BAE_PLABOX_RequestConfirmationDeletedByBaeurer, _
                                                                  BAE_PLABOX_RequestTrashed, _
                                                                  BAE_PLABOX_RequestChangedByCapture)), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  ls_Status = ""
  While Not mo_DbBaeurer.EOF(lc_Cursor)
    If ls_Status <> "" Then
      ls_Status = ls_Status & ","
    End If
    ls_Status = ls_Status & mo_DbBaeurer.GetFields(lc_Cursor, "kn_verarb")
    Call mo_DbBaeurer.Next(lc_Cursor)
  Wend
  Call mo_DbBaeurer.Close(lc_Cursor)
  Bae_GetPlaningBoxStatus = ls_Status
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_GetPlaningBoxStatus")
End Function

Private Function Bae_UpdatePlaningBoxOfferStatus(ByVal as_COF_Code As String, ByVal av_kn_verarb_old As Variant, ByVal as_kn_verarb_new As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String

  ' planning box needs to be locked
  ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb IN ($kn_verarb_old$)"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(av_kn_verarb_old), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(as_kn_verarb_new), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  Bae_UpdatePlaningBoxOfferStatus = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_UpdatePlaningBoxOfferStatus")
End Function

Private Function Bae_UpdateOfferDetailStatus(ByVal as_COF_Id As String, ByVal as_kn_verarb_old As Variant, ByVal as_kn_verarb_new As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String

  ' planning box needs to be locked
  ls_req = "UPDATE Cap_OfferDetail SET OFD_B7Sta=$kn_verarb_new$ WHERE COF_Id=$COF_Id$ AND OFD_B7Sta IN ($kn_verarb_old$) AND Drop_Flag=''"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(as_kn_verarb_old), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(as_kn_verarb_new), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Bae_UpdateOfferDetailStatus = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_UpdateOfferDetailStatus")
End Function

Private Function Bae_CheckExistCustPurchOrderNumber(ByVal as_COF_CodeCus As String, ByVal al_Konto As Long) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim ll_LockRowId As Long

  Bae_CheckExistCustPurchOrderNumber = True
  ls_req = "SELECT best_nr from v100 where konto = $konto$ and vvorgart = '1' and fi_nr = $fi_nr$ and best_nr = $COF_CodeCus$"
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(al_Konto), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COF_CodeCus$", mo_Tools.SQLStr(as_COF_CodeCus), , , vbTextCompare)
  Bae_CheckExistCustPurchOrderNumber = mo_Tools.SelectValue(mo_DbBaeurer, ls_req) <> ""
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_CheckExistCustPurchOrderNumber")
End Function

Private Function FindOrderPositionLink(ByVal as_COF_Id As String, ByVal al_OFD_Pos As Long, ByVal as_PRD_Code As String, ByVal al_OFD_Split As Long) As String
On Error GoTo ErrHandler

Dim ls_req As String
  
  ls_req = "SELECT TOP 1 OFD_IdPar FROM Cap_OfferDetail WHERE COF_Id=$COF_Id$ AND OFD_Pos=$OFD_Pos$ AND OFD_Main=$OFD_Main$ AND PRD_Code=$PRD_Code$ AND ISNULL(OFD_Split,0)=$OFD_Split$ AND Drop_Flag=''"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Pos$", mo_Tools.SqlInt(al_OFD_Pos), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", mo_Tools.SqlInt(eDPCOfferDetailMain.odMain), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(as_PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Split$", mo_Tools.SqlInt(al_OFD_Split), , , vbTextCompare)
  FindOrderPositionLink = mo_Tools.SelectValue(mo_Db, ls_req)
  Exit Function
ErrHandler:
  Call ErrHandler("FindOrderPositionLink")
End Function

'Public Function Bae_AcceptPlanningBox(ByVal as_COF_Id As String, ByVal as_COF_Code As String, ByRef as_ErrorMsg As String) As Boolean
'On Error GoTo ErrHandler
'
'Dim ls_req As String
'Dim lc_PlanBoxCursor As Long
'Dim ls_OFD_Id As String, ls_OFD_IdSrc As String
'Dim ll_OFD_Pos As Long, ll_OFD_PosSrc As Long
'Dim ls_PRD_Code As String, ls_COF_Code As String
'Dim ll_OFD_Split As Long
'Dim ll_ConnectId As Long
'Dim ll_LockRowId As Long
'
'  as_ErrorMsg = ""
'  Bae_AcceptPlanningBox = False
'  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
'    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
'    Exit Function
'  End If
'
'  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, as_COF_Code), "vva100")
'  If ll_LockRowId = 0 Then
'    as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress")
'    Exit Function
'  End If
'
'  ls_req = "SELECT * FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
'  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(as_COF_Code), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
'  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
'
'  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) = 0 Then
'    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'    Call mo_Db.Close(lc_PlanBoxCursor)
'    as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 666, "#No item is approved in planning box")
'    Exit Function
'  End If
'
'  If mo_DbBaeurer.Find(lc_PlanBoxCursor, "kn_verarb", BAE_PLABOX_RequestDeadlineTimeout) >= 0 Then
'    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'    Call mo_Db.Close(lc_PlanBoxCursor)
'    as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 666, "#Request deadline timeout")
'    Exit Function
'  Else
'
'    Call mo_DbBaeurer.First(lc_PlanBoxCursor)
'    While Not mo_DbBaeurer.EOF(lc_PlanBoxCursor)
'      ls_COF_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr_q")
'      ll_OFD_Pos = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufpos_q")
'      ll_OFD_PosSrc = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos_q")
'      ls_PRD_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "identnr")
'      ll_OFD_Split = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos")
'      ls_OFD_Id = ""
'      ' find source order line position - original order line exported to planning box which may or may not be splitted
'      ls_OFD_IdSrc = FindOrderPositionLink(as_COF_Id, ll_OFD_Pos, ls_PRD_Code, 0)
'      ' update link of capture order line into planning box and change status as it was imported ok by Capture
'      Call Bae_UpdatePlaningBoxFromOrderPosition(ls_COF_Code, ll_OFD_Pos, ll_OFD_Split, ll_OFD_PosSrc)
'      ' go to next planning box line
'      Call mo_DbBaeurer.Next(lc_PlanBoxCursor)
'    Wend
'    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
'  End If
'  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'  Call mo_DbBaeurer.Disconnect
'  Bae_AcceptPlanningBox = True
'  Exit Function
'ErrHandler:
'  Call mo_Tools.UpdateError(True)
'  If ll_LockRowId <> 0 Then
'    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'    Call mo_DbBaeurer.Disconnect
'  End If
'  Call mo_Tools.UpdateError(False)
'  Call ErrHandler("Bae_AcceptPlanningBox")
'End Function

Public Function Bae_ImportSecretBox(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_PlanBoxCursor As Long, lc_Offer As Long
Dim ls_OFD_Id As String, ls_OFD_IdSrc As String
Dim ll_OFD_Pos As Long, ll_OFD_PosSrc As Long
Dim ls_PRD_Code As String, ls_COF_Code As String
Dim ll_OFD_Split As Long
Dim ll_SplitNr As Long
Dim ll_LockRowId As Long
Dim ls_COF_CodeBae As String, ls_Status As String

  as_ErrorMsg = ""
  Bae_ImportSecretBox = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  
  If (mo_Db.GetFields(lc_Offer, "COF_Stat") <> eOfferStatus.osPlanningProcess) And _
     (mo_Db.GetFields(lc_Offer, "COF_Stat") <> eOfferStatus.osBaeurerSalesOrderChange) And _
     (mo_Db.GetFields(lc_Offer, "COF_Stat") <> eOfferStatus.osSAPSalesOrderChange) Then
    Call mo_Db.Close(lc_Offer)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$'", Array("$STATUS$", "Planning Process, SAP Sales Order change, Bauerer Sales Order change"))
    Exit Function
  End If
  
  Call mo_Db.Close(lc_Offer)
  
  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress")
    Exit Function
  End If
  
  ls_Status = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  If ls_Status = "" Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9872, "#No item is approved in planning box")
    Exit Function
  ElseIf StrComp(ls_Status, BAE_PLABOX_RequestReadyForCapture, vbTextCompare) = 0 Then
    ' this is ok to import all
  ElseIf StrComp(ls_Status, BAE_PLABOX_RequestReadyForCapture & "," & BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) = 0 Then
    ' this is ok to import all
  Else
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9873, "#You cannot import planning box items with status $STATUS$", Array("$STATUS$", ls_Status))
    Exit Function
  End If
  
  ls_req = "SELECT aufnr_q, identnr, COUNT(*) FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) GROUP BY aufnr_q, identnr HAVING COUNT(*) > $MAX_SPLIT$"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture)), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAX_SPLIT$", mo_Tools.SqlInt(MAX_SPLIT), , , vbTextCompare)
  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) > 0 Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9874, "#Maximum split line count allowed for one position in planning box is $MAXSPLIT$", Array("$MAXSPLIT$", MAX_SPLIT))
    Exit Function
  End If
  Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
  
  ls_req = "SELECT * FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture)), , , vbTextCompare)
  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  
  ls_COF_CodeBae = ""
  Call mo_DbBaeurer.First(lc_PlanBoxCursor)
  While Not mo_DbBaeurer.EOF(lc_PlanBoxCursor)
    ls_COF_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr_q")
    ll_OFD_Pos = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufpos_q")
    ll_OFD_PosSrc = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos_q")
    ls_PRD_Code = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "identnr")
    ll_OFD_Split = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "seblpos")
    ls_OFD_Id = ""
    If (ls_COF_CodeBae = "") And (mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr") <> "") Then
      ls_COF_CodeBae = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "aufnr")
    End If
    ' find source order line position - original order line exported to planning box which may or may not be splitted
    ls_OFD_IdSrc = FindOrderPositionLink(as_COF_Id, ll_OFD_Pos, ls_PRD_Code, 0)
    If ls_OFD_IdSrc = "" Then
      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
      Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
      ' we did not found line in capture order
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9875, "#Order line not found for article: $TEXT$", Array("$TEXT$", ls_PRD_Code & "-" & ll_OFD_Pos & "-" & ll_OFD_Split))
      Exit Function
    End If
    
    ' calculate real split "position offset" - if line is split, copied line will get new position number with offset to original line position number
    If ll_OFD_Split = 0 Then
      ll_SplitNr = 0
      ls_OFD_Id = ls_OFD_IdSrc
    Else
      ' we have some split, increment position counter (maybe we can user ll_OFD_Split, but is it consistent?)
      ll_SplitNr = ll_SplitNr + 1
      ' in case we try to import the same order from planning box again - line is marked and linked to existing order line
      If ll_OFD_PosSrc > 0 Then
        ls_OFD_Id = FindOrderPositionLink(as_COF_Id, ll_OFD_PosSrc, ls_PRD_Code, ll_OFD_Split)
        ' link exist, but line not found in Capture.. hmm create it again or how error ?
        If (ls_OFD_Id = "") Then
          ls_OFD_Id = CopyOfferPos(as_COF_Id, ls_OFD_IdSrc, ll_SplitNr, ll_OFD_PosSrc)
        End If
      Else
        ' in case we detected split and dont have link in planing box, copy base offer description
        ls_OFD_Id = CopyOfferPos(as_COF_Id, ls_OFD_IdSrc, ll_SplitNr, ll_OFD_PosSrc)
      End If
    End If
    
    If ls_OFD_Id = "" Then
      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
      Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9875, "#Order line not found for article: $TEXT$", Array("$TEXT$", ls_PRD_Code & "-" & ll_OFD_Pos & "-" & ll_OFD_Split))
      Exit Function
    End If
    ' update qty, shipment date and other attributes from planning box into capture order line position
    Call Bae_UpdateOrderPositionFromPlaningBox(as_COF_Id, ls_OFD_Id, ll_OFD_Split, lc_PlanBoxCursor)
    ' update link of capture order line into planning box and change status as it was imported ok by Capture
    Call Bae_UpdatePlaningBoxFromOrderPosition(ls_COF_Code, ll_OFD_Pos, ll_OFD_Split, ll_OFD_PosSrc)
    ' go to next planning box line
    Call mo_DbBaeurer.Next(lc_PlanBoxCursor)
  Wend
  Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
  
  If ls_COF_CodeBae <> "" Then
    ls_req = "UPDATE Cap_Offer SET COF_CodeBae=$COF_CodeBae$ WHERE COF_Id=$COF_Id$"
    ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$COF_CodeBae$", mo_Tools.SQLStr(ls_COF_CodeBae), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  End If
  
  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_DbBaeurer.Disconnect
  Bae_ImportSecretBox = True
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrHandler("Bae_ImportSecretBox")
End Function

Private Sub UpdateOfferStatus(ByVal as_COF_Id As String, ByVal ae_COF_Stat As eOfferStatus)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "UPDATE Cap_Offer SET COF_Stat=$COF_Stat$, Z_Last_Upd_User=$Z_Last_Upd_User$,Z_Last_Upd=getdate(),iConcurrency=iConcurrency+1 WHERE COF_Id=$COF_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COF_Stat$", mo_Tools.SqlInt(ae_COF_Stat), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrHandler("UpdateOfferStatus")
End Sub

Private Sub Bae_UpdateOfferCode(ByVal as_COF_Id As String, ByVal as_COF_CodeBae As String)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "UPDATE Cap_Offer SET COF_CodeBae=$COF_CodeBae$, Z_Last_Upd_User=$Z_Last_Upd_User$,Z_Last_Upd=getdate(),iConcurrency=iConcurrency+1 WHERE COF_Id=$COF_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$COF_CodeBae$", mo_Tools.SQLStr(as_COF_CodeBae), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrHandler("UpdateOfferStatus")
End Sub

Private Sub Bae_ClearOfferDetailCodePos(ByVal as_COF_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "UPDATE Cap_OfferDetail SET OFD_OrdNrB7='',OFD_PosB7=0,OFD_InfoB7='',OFD_B7Sta=0,OFD_SAPAct='',Z_Last_Upd_User=$Z_Last_Upd_User$,Z_Last_Upd=getdate(),iConcurrency=iConcurrency+1 WHERE COF_Id=$COF_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_ClearOfferDetailCodePos")
End Sub

Private Sub ResetActionCode(ByVal as_COF_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  ls_req = "SELECT OFD_IdPar FROM Cap_OfferDetail WHERE COF_Id=$COF_Id$ AND (OFD_SAPAct IN ('D','K'))"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    ls_req = "UPDATE Cap_OfferDetail SET Drop_Flag='X', Drop_Date=getdate() WHERE (COF_Id=$COF_Id$) AND (OFD_IdPar=$OFD_IdPar$)"
    ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$OFD_IdPar$", mo_Tools.SQLStr(mo_Db.GetFields(lc_Cursor, "OFD_IdPar")), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  
  
  ls_req = "UPDATE Cap_OfferDetail SET OFD_SAPAct='', Z_Last_Upd_User=$Z_Last_Upd_User$,Z_Last_Upd=getdate(),iConcurrency=iConcurrency+1 WHERE COF_Id=$COF_Id$ AND OFD_SAPAct<>''"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrHandler("ResetActionCode")
End Sub

Private Function CheckNode(ByRef ao_Node As MSXML2.IXMLDOMNode, ByVal as_Name As String, ByRef as_ErrMsg As String) As Boolean
On Error GoTo ErrHandler
    
    CheckNode = True
    
    If ao_Node.selectSingleNode(as_Name) Is Nothing Then
        If Len(as_ErrMsg) > 0 Then
            as_ErrMsg = as_ErrMsg + ";"
        End If
        as_ErrMsg = as_ErrMsg + "Missing node: " + as_Name
        CheckNode = False
    End If
    
    Exit Function
ErrHandler:
    Call ErrHandler("CheckNode")
End Function

Public Function Bae_ReadSalesOrderResponse(ByVal as_COF_Id As String, ByRef as_ErrMsg As String) As Boolean
On Error GoTo ErrHandler

Dim lo_XMLDoc As Object
Dim lo_NodeElem As Object
Dim lo_NodeElem2 As Object
Dim lo_NodeList As Object
Dim lo_NodeList2 As Object
Dim lo_NodeId As Object
Dim ls_Value As String
Dim ls_Error As String
Dim ls_Request As String
Dim ls_Filename As String
Dim ls_COF_Code As String
Dim ls_COF_ID As String
Dim ll_iConcurrency As Long
Dim ls_Bae_Code As String
Dim ls_OFD_Pos() As String
Dim ls_OFD_PosBae() As String
Dim ls_OrdNrB7 As String
Dim lb_Failed, lb_inTransaction As Boolean
Dim ll_Cursor, ll_Index As Long
Dim lb_LogInfo As Boolean


    Bae_ReadSalesOrderResponse = False
    lb_LogInfo = True
    
    Call ClearLogInterface
    
    If DownloadXMLDocument(as_COF_Id, ls_Filename, as_ErrMsg) = True Then
        Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
                
        lo_XMLDoc.async = False
        Call lo_XMLDoc.Load(ms_TempDir & "\" & ls_Filename)
        'Call lo_XMLDoc.Load(App.Path & "\051898-13052014-135122.xml")
        'ls_Filename = "051898-13052014-135122.xml.xml"
        If (lo_XMLDoc.parseError.errorCode <> 0) Then
        
            mo_ILO.ILO_Error = lo_XMLDoc.parseError.reason
            mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
        
            Call LogInterface(mo_Db, ml_U_Code)
            
            as_ErrMsg = "Parse Error:" & lo_XMLDoc.parseError.reason
           
        Else
            'get OrdNrB7 from filename
            ls_OrdNrB7 = Left(ls_Filename, InStr(1, ls_Filename, "-") - 1)
            ls_Bae_Code = ""
            
            Set lo_NodeList = lo_XMLDoc.selectNodes("//AMC_STOCK_REPLENISH_PL_ORD_MAINT")
          
            If lo_NodeList.length > 0 Then
                
                'first check if all codes are right and successful
                lb_Failed = False
                For Each lo_NodeElem In lo_NodeList
                    
                    If CheckNode(lo_XMLDoc, "//EPC_ORD_NO", as_ErrMsg) = False Or _
                       CheckNode(lo_NodeElem, "//SUCC_FAIL_IND", as_ErrMsg) = False Or _
                       CheckNode(lo_NodeElem, "//SAP_ORD_NO", as_ErrMsg) = False Or _
                       CheckNode(lo_NodeElem, "//SAP_ORD_LINE_POS", as_ErrMsg) = False Or _
                       CheckNode(lo_NodeElem, "//EPC_ORD_LINE_POS", as_ErrMsg) = False Then
                       
                        lb_Failed = True
                        Exit For
                    End If
                    
                    If ls_Bae_Code = "" Then
                        ls_Bae_Code = lo_XMLDoc.selectSingleNode("//EPC_ORD_NO").nodeTypedValue
                    End If
                    
                    If lo_NodeElem.selectSingleNode("//SUCC_FAIL_IND").nodeTypedValue <> "S" Or _
                        lo_NodeElem.selectSingleNode("//EPC_ORD_NO").nodeTypedValue <> ls_Bae_Code Or _
                        lo_NodeElem.selectSingleNode("//SAP_ORD_NO").nodeTypedValue <> ls_OrdNrB7 Then
                    
                        lb_Failed = True
                        
                        'read error, warrning, info messages
                        Set lo_NodeList2 = lo_NodeElem.selectSingleNode("//ERRORS").childNodes()
                             
                        For Each lo_NodeElem2 In lo_NodeList2
                            If CheckNode(lo_NodeElem2, "MSG_TEXT", as_ErrMsg) = False Then
                                lb_Failed = True
                                Exit For
                            Else
                                as_ErrMsg = as_ErrMsg & "Bae_Code: " & lo_NodeElem.selectSingleNode("SAP_ORD_LINE_POS").nodeTypedValue & ", " & lo_NodeElem2.selectSingleNode("MSG_TEXT").nodeTypedValue & vbCrLf
                            End If
                        Next
                    
                        Set lo_NodeElem2 = Nothing
                        Set lo_NodeList2 = Nothing
                    End If
                                        
                Next
            
                If lb_Failed = False Then
                
                    ls_Request = "exec CAP_Offer_sel2 $COF_Code$,'E'"
                    ls_Request = Replace(ls_Request, "$COF_Code$", mo_Tools.SQLStr(ls_Bae_Code), , , vbTextCompare)
                    ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
        
                    If mo_Db.RowCount(ll_Cursor) = 1 Then
                        
                        ls_COF_ID = mo_Db.GetFields(ll_Cursor, "COF_Id")
                        ll_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")

                        Call mo_Db.Close(ll_Cursor)
                
                        ReDim ls_OFD_Pos(lo_NodeList.length - 1)
                        ReDim ls_OFD_PosBae(lo_NodeList.length - 1)
                        ll_Index = 0
                      
                        For Each lo_NodeElem In lo_NodeList
                          ls_OFD_Pos(ll_Index) = lo_NodeElem.selectSingleNode("EPC_ORD_LINE_POS").nodeTypedValue
                          ls_OFD_PosBae(ll_Index) = lo_NodeElem.selectSingleNode("SAP_ORD_LINE_POS").nodeTypedValue
                          ll_Index = ll_Index + 1
                        Next
                                                
                        Call mo_Tools.BeginTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_BaeResponse")
                        lb_inTransaction = True
                          
                        ls_Request = "exec CAP_Offer_BaeResponse_upd $COF_Id$,$COF_CodeSAP$,$COF_SAPStat$,$iConcurrency$,$Z_Last_Upd_User$"
                        ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(ls_COF_ID), , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$COF_CodeSAP$", mo_Tools.SQLStr(ls_Bae_Code), , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$COF_SAPStat$", 1, , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$iConcurrency$", ll_iConcurrency, , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$Z_Last_Upd_User$", ml_U_Code, , , vbTextCompare)
                        'Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
                                                
                        For ll_Index = 0 To lo_NodeList.length - 1
                      
                          ls_Request = "exec CAP_OfferDetail_SAPResponse_upd $COF_Id$,$OFD_Pos$,$OFD_PosSAP$,$Z_Last_Upd_User$"
                          ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(ls_COF_ID), , , vbTextCompare)
                          ls_Request = Replace(ls_Request, "$OFD_Pos$", mo_Tools.SQLStr(ls_OFD_Pos(ll_Index)), , , vbTextCompare)
                          ls_Request = Replace(ls_Request, "$OFD_PosSAP$", mo_Tools.SQLStr(ls_OFD_PosBae(ll_Index)), , , vbTextCompare)
                          ls_Request = Replace(ls_Request, "$Z_Last_Upd_User$", ml_U_Code, , , vbTextCompare)
                          'Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
                      
                        Next
                                                            
                        Call mo_Tools.CommitTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_BaeResponse")
                        lb_inTransaction = False
                          
                        mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
                        Bae_ReadSalesOrderResponse = True
                    Else
                       Call mo_Db.Close(ll_Cursor)
                       as_ErrMsg = as_ErrMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9876, "#Response process cannot find offer for offer code: $COF_Code$", Array("$COF_Code$", ls_Bae_Code)) & vbCrLf
                       'as_ErrMsg = "Bae Response process cannot find offer for offer code: " & ls_Bae_Code
                       mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
                       mo_ILO.ILO_Error = as_ErrMsg
                    End If
                Else
                    mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
                End If
           Else
                as_ErrMsg = "Main node AMC_STOCK_REPLENISH_PL_ORD_MAINT missing!"
                mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
                mo_ILO.ILO_Error = as_ErrMsg
           End If
                  
        End If
    Else
        If Len(as_ErrMsg) > 0 Then
            mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
            mo_ILO.ILO_Error = as_ErrMsg
        Else
            'file not found ... maybe not created yet?
            lb_LogInfo = False
        End If
    End If
           
    If lb_LogInfo = True Then
        Call LogInterface(mo_Db, ml_U_Code)
    End If
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
    Exit Function
ErrHandler:
    If lb_inTransaction Then
        Call mo_Tools.RollbackTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_BaeResponse")
    End If
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
    Call LogInterface(mo_Db, ml_U_Code)
    
    Call ErrHandler("Bae_ReadSalesOrderResponse")
End Function

Public Function Bae_KillSecretBox(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Offer As Long
Dim ll_LockRowId As Long
Dim ls_KN_Verarb_Old As String
Dim ls_KN_Verarb_New As String
Dim ls_COF_Code As String

  as_ErrorMsg = ""
  Bae_KillSecretBox = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  
  If (mo_Db.GetFields(lc_Offer, "COF_Stat") <> eOfferStatus.osPlanningProcess) And (mo_Db.GetFields(lc_Offer, "COF_Stat") <> eOfferStatus.osBaeurerSalesOrderChange) Then
    Call mo_Db.Close(lc_Offer)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$'", Array("$STATUS$", "Planning Process, Sales order change"))
    Exit Function
  End If
  Call mo_Db.Close(lc_Offer)
  
  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress")
    Exit Function
  End If
  
  'ls_req = "SELECT * FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
  'ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_FromCaptureReady, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestInProgress, BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
  'lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
  
  
  'ls_KN_Verarb_Old = mo_DbBaeurer.GetFields(lc_Status, "kn_verarb")
  
  ls_KN_Verarb_Old = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  
  If ls_KN_Verarb_Old = "" Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    'Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9877, "#No item to delete in planning box")
    Exit Function
  ElseIf PlanningBoxStatusIsSubset(ls_KN_Verarb_Old, Array(BAE_PLABOX_FromCaptureReady, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestDeadlineTimeout)) Then
    ls_KN_Verarb_New = BAE_PLABOX_RequestConfirmationMarkedDelete
  Else
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    'Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9878, "#You cannot delete planning box items with status $STATUS$", Array("$STATUS$", ls_KN_Verarb_Old))
    Exit Function
  End If
  
  If Not Bae_UpdatePlaningBoxOfferStatus(ls_COF_Code, Split(ls_KN_Verarb_Old, ","), ls_KN_Verarb_New, as_ErrorMsg) Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Exit Function
  End If
  
  'ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb IN ($kn_verarb_old$)"
  'ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(ls_KN_Verarb_Old), , , vbTextCompare)
  'ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(ls_KN_Verarb_New), , , vbTextCompare)
  'Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
  
  Call Bae_ClearOfferDetailCodePos(as_COF_Id)
  Call Bae_UpdateOfferCode(as_COF_Id, "")
  
  'ls_req = "UPDATE Cap_Offer SET COF_CodeBae='' WHERE COF_Id=$COF_Id$"
  'ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  'Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  'ls_req = "UPDATE Cap_OfferDetail SET OFD_OrdNrB7='', OFD_PosB7=0, OFD_InfoB7='' WHERE COF_Id=$COF_Id$"
  'ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  'Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  
  
  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_DbBaeurer.Disconnect
  Bae_KillSecretBox = True
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrHandler("KillSecretBox")
End Function

Public Function Bae_GetOrderType(ByVal ao_Db As Object, ByVal al_Konto As Long) As Long
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "SELECT auf_art FROM g600 WHERE fi_nr=$fi_nr$ AND satzart=$satzart$ AND konto=$konto$"
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$satzart$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(al_Konto), , , vbTextCompare)
  Bae_GetOrderType = mo_Tools.SelectValue(ao_Db, ls_req)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_GetOrderType")
End Function

Private Function Bae_GetUserAccount(ByVal ao_Db As Object, ByVal al_Konto As Long, ByVal as_Email As String) As Long
On Error GoTo ErrHandler

Dim ls_req As String

'  ls_req = "SELECT sb_schl FROM g915 WHERE fi_nr=$fi_nr$ AND email=$email$"
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$email$", mo_Tools.SQLStr(as_Email), , , vbTextCompare)
  ls_req = "SELECT ansprnr FROM g620 WHERE fi_nr=$fi_nr$ AND satzart=$satzart$ AND konto=$konto$ AND email=$email$"
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$satzart$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(al_Konto), , , vbTextCompare)
  ls_req = Replace(ls_req, "$email$", mo_Tools.SQLStr(as_Email), , , vbTextCompare)
  Bae_GetUserAccount = mo_Tools.SelectValue(ao_Db, ls_req)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_GetUserAccount")
End Function

Private Sub Bae_InsertProductSecretBox(ByVal ao_Db As Object, ByVal ac_Offer As Long, ByVal ac_OfferPos As Long)
On Error GoTo ErrHandler

Dim ls_req As String
  
  ls_req = "INSERT INTO [va1101] "
  ls_req = ls_req & "([abrmenge], [aendnr], [identnr], [var], [aufnr_q], [aufpos_q], [auf_dat], [best_dat], [datbis], [lief_prio],"
  ls_req = ls_req & "[dataen], [datneu], [wunsch_term], [fi_nr], [kn_abruf], [sb_schl_q], [kn_verarb], [useraen], [userneu], [status_menge],"
  ls_req = ls_req & "[status_termin], [status_ruestko], [lief_termb], [menge_best], [sb_schl], [datum_frei], [konto], [satzart], [auf_art],"
  ls_req = ls_req & "[ben], [mevk], [projekt_id], [vvorgart], [lgnr], [info_b7], [aufnr], [aufpos], [ruestko], [info_txt], [info_b7_k],"
  ls_req = ls_req & "[seblpos], [seblpos_q], [kn_rueko], [vers_art], [lb]) "
  ls_req = ls_req & "VALUES"
  ls_req = ls_req & "($abrmenge$, $aendnr$, $identnr$, $var$, $aufnr_q$, $aufpos_q$, $auf_dat$, $best_dat$, $datbis$, $lief_prio$,"
  ls_req = ls_req & "$dataen$, $datneu$, $wunsch_term$, $fi_nr$, $kn_abruf$, $sb_schl_q$, $kn_verarb$, $useraen$, $userneu$, $status_menge$,"
  ls_req = ls_req & "$status_termin$, $status_ruestko$, $lief_termb$, $menge_best$, $sb_schl$, $datum_frei$, $konto$, $satzart$, $auf_art$,"
  ls_req = ls_req & "$ben$, $mevk$, $projekt_id$, $vvorgart$, $lgnr$, $info_b7$, $aufnr$, $aufpos$, $ruestko$, $info_txt$, $info_b7_k$,"
  ls_req = ls_req & "$seblpos$, $seblpos_q$, $kn_rueko$, $vers_art$, $lb$) "

  ls_req = Replace(ls_req, "$abrmenge$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_QtyPCS")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aendnr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$identnr$", mo_Tools.SQLStr(mo_Db.GetFields(ac_OfferPos, "PRD_Code")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$var$", mo_Tools.SQLStr(" "), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(Left(mo_Db.GetFields(ac_Offer, "COF_Code"), 10)), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$auf_dat$", mo_Tools.SqlDate(mo_Db.GetFields(ac_Offer, "Z_Creation")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$best_dat$", mo_Tools.SqlDate(mo_Db.GetFields(ac_Offer, "Z_Creation")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$datbis$", mo_Tools.SqlDate(mo_Db.GetFields(ac_Offer, "COF_ExDat")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lief_prio$", mo_Tools.SQLStr("5"), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$dataen$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$datneu$", "getdate()", , , vbTextCompare)
  ls_req = Replace(ls_req, "$wunsch_term$", mo_Tools.SqlDate(mo_Db.GetFields(ac_OfferPos, "OFD_WshDat")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_abruf$", "NULL", , , vbTextCompare)
  'ls_Req = Replace(ls_Req, "$sb_schl_q$", mo_Tools.SqlInt(GetUserAccount(ao_Db, mo_Db.GetFields(ac_Offer, "LEN_BaeKonto"), mo_Db.GetFields(ac_Offer, "Z_CreatorEmail"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$sb_schl_q$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_Partner"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SQLStr(BAE_PLABOX_FromCaptureReady), , , vbTextCompare)
  ls_req = Replace(ls_req, "$useraen$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$userneu$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "Z_CreatorDesc")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$status_menge$", "NULL", , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$status_termin$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$status_ruestko$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$lief_termb$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$menge_best$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$sb_schl$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$datum_frei$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$konto$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_Konto"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$satzart$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$auf_art$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_OrdTyp"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ben$", mo_Tools.SQLStrUnicode(mo_Db.GetFields(ac_Offer, "SP_Desc"), mo_Db.GetFields(ac_Offer, "SP_CodePage"), 40), , , vbTextCompare)
  ls_req = Replace(ls_req, "$mevk$", mo_Tools.SQLStr("STK"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$projekt_id$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "SP_Capkey")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$vvorgart$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$lgnr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$info_b7$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufnr$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$ruestko$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$info_txt$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "COF_Comm"), 70), , , vbTextCompare)
  ls_req = Replace(ls_req, "$info_b7_k$", "NULL", , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$seblpos$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$seblpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$kn_rueko$", "NULL", , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$vers_art$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_DelType"))), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lb$", mo_Tools.SqlInt(Val(mo_Db.GetFields(ac_Offer, "COF_Bae_DelCond"))), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req, 1)
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_InsertProductSecretBox")
End Sub

Private Function Bae_DeleteProductSecretBox(ByVal ao_Db As Object, ByVal ac_Offer As Long, ByVal ac_OfferPos As Long) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
  
  ' planning box needs to be locked
  ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND aufpos_q=$aufpos_q$ and fi_nr=$fi_nr$"
  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(Left(mo_Db.GetFields(ac_Offer, "COF_Code"), 10)), , , vbTextCompare)
  ls_req = Replace(ls_req, "$aufpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestRefusedByCapture), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  Bae_DeleteProductSecretBox = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_DeleteProductSecretBox")
End Function

'Private Sub Bae_UpdateProductSecretBox(ByVal ao_Db As Object, ByVal ac_Offer As Long, ByVal ac_OfferPos As Long)
'On Error GoTo ErrHandler
'
'Dim ls_req As String
'
'  ls_req = "INSERT INTO [va1101] "
'  ls_req = ls_req & "([abrmenge], [aendnr], [identnr], [var], [aufnr_q], [aufpos_q], [auf_dat], [best_dat], [datbis], [lief_prio],"
'  ls_req = ls_req & "[dataen], [datneu], [wunsch_term], [fi_nr], [kn_abruf], [sb_schl_q], [kn_verarb], [useraen], [userneu], [status_menge],"
'  ls_req = ls_req & "[status_termin], [status_ruestko], [lief_termb], [menge_best], [sb_schl], [datum_frei], [konto], [satzart], [auf_art],"
'  ls_req = ls_req & "[ben], [mevk], [projekt_id], [vvorgart], [lgnr], [info_b7], [aufnr], [aufpos], [ruestko], [info_txt], [info_b7_k],"
'  ls_req = ls_req & "[seblpos], [seblpos_q], [kn_rueko], [vers_art], [lb]) "
'  ls_req = ls_req & "SELECT "
'  ls_req = ls_req & "$abrmenge$, aendnr, identnr, var, aufnr_q, aufpos_q, auf_dat, best_dat, datbis, lief_prio,"
'  ls_req = ls_req & "NULL, getdate(), $wunsch_term$, fi_nr, kn_abruf, sb_schl_q, $kn_verarb_new$, NULL, $userneu$, status_menge,"
'  ls_req = ls_req & "status_termin, status_ruestko, lief_termb, menge_best, sb_schl, datum_frei, konto, satzart, auf_art,"
'  ls_req = ls_req & "ben, mevk, projekt_id, vvorgart, lgnr, info_b7, aufnr, aufpos, ruestko, info_txt, info_b7_k,"
'  ls_req = ls_req & "seblpos, seblpos_q, kn_rueko, vers_art, lb "
'  ls_req = ls_req & "FROM [va1101] "
'  ls_req = ls_req & "WHERE "
'  ls_req = ls_req & "fi_nr=$fi_nr$ AND "
'  ls_req = ls_req & "aufnr_q=$aufnr_q$ AND "
'  ls_req = ls_req & "aufpos_q=$aufpos_q$ AND "
'  ls_req = ls_req & "kn_verarb = $kn_verarb_old$"
'
'  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(Left(mo_Db.GetFields(ac_Offer, "COF_Code"), 10)), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$aufpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SQLStr(BAE_PLABOX_RequestAcceptedByCapture), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestReadyForCapture), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$abrmenge$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_QtyPCS")), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$wunsch_term$", mo_Tools.SqlDate(mo_Db.GetFields(ac_OfferPos, "OFD_WshDat")), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$userneu$", mo_Tools.SQLStr(mo_Db.GetFields(ac_Offer, "Z_Last_Upd_UserDesc")), , , vbTextCompare)
'  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req, 1)
'
'  ls_req = "UPDATE [va1101] "
'  ls_req = ls_req & "SET kn_verarb = $kn_verarb_new$ "
'  ls_req = ls_req & "WHERE "
'  ls_req = ls_req & "fi_nr=$fi_nr$ AND "
'  ls_req = ls_req & "aufnr_q=$aufnr_q$ AND "
'  ls_req = ls_req & "aufpos_q=$aufpos_q$ AND "
'  ls_req = ls_req & "kn_verarb = $kn_verarb_old$"
'  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(Left(mo_Db.GetFields(ac_Offer, "COF_Code"), 10)), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$aufpos_q$", mo_Tools.SqlInt(mo_Db.GetFields(ac_OfferPos, "OFD_Pos")), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SQLStr(BAE_PLABOX_RequestAcceptedByCapture), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestChangedByCapture), , , vbTextCompare)
'  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req, 1)
'  Exit Sub
'ErrHandler:
'  Call ErrHandler("Bae_InsertProductSecretBox")
'End Sub

'Public Sub SaveXml()
'
'  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
'    Exit Sub
'  End If
'  Call mo_DbBaeurer.BlobToFileSQL("select xmllong from tran_sc where rowid=2801", App.Path & "\BOR.XML", 0, 0)
'  Call mo_DbBaeurer.Disconnect
'End Sub

Public Function Bae_ExportSecretBox(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ll_LockRowId As Long
Dim lc_Offer As Long
Dim lc_OfferPos As Long
Dim ls_CurrentStatus As String
Dim lv_OldStatus As Variant, ls_NewStatus As String
Dim ls_COF_Code As String, ls_COF_Stat As String

  Bae_ExportSecretBox = False
  as_ErrorMsg = ""
  
  ls_req = "SELECT COUNT(*) "
  ls_req = ls_req & "FROM Cap_OfferDetail OFD "
  ls_req = ls_req & "INNER JOIN DPC_PrdCommon PRD ON (OFD.PRD_Id=PRD.PRD_Id) "
  ls_req = ls_req & "INNER JOIN DPC_Vendor VEN ON (OFD.VEN_Id=VEN.VEN_Id) "
  ls_req = ls_req & "WHERE OFD.COF_Id =$COF_Id$ AND "
  ls_req = ls_req & "VEN.MFGP_Code=$MFGP_Code$ AND "
  ls_req = ls_req & "OFD.OFD_Main=1 AND "
  ls_req = ls_req & "OFD.OFD_Valid='X' AND "
  ls_req = ls_req & "(OFD.DOF_Id IN (1)) AND "
  ls_req = ls_req & "(OFD.CAT_Id IN (1)) AND "
  ls_req = ls_req & "PRD.PRD_StaBae<>1 "
  ls_req = ls_req & "AND OFD.Drop_Flag=''"
  
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MFGP_Code$", mo_Tools.SQLStr(RANKWEIL_PLANT_CODE), , , vbTextCompare)
  
  
  If mo_Tools.SelectValue(mo_Db, ls_req) > 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9879, "#Not all custom materials inside sales order were successfuly exported to Baeurer B7")
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  ls_COF_Stat = mo_Db.GetFields(lc_Offer, "COF_Stat")
  
  If Trim(mo_Db.GetFields(lc_Offer, "COF_Bae_Konto")) = "" Then
    Call mo_Db.Close(lc_Offer)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9880, "#Internal customer konto is not defined")
    Exit Function
  End If
  
  If Trim(mo_Db.GetFields(lc_Offer, "COF_Bae_OrdTyp")) = "" Then
    Call mo_Db.Close(lc_Offer)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9881, "#Baeurer order type is not defined")
    Exit Function
  End If
  
  If (ls_COF_Stat <> eOfferStatus.osPlanningProcess) And _
     (ls_COF_Stat <> eOfferStatus.osBaeurerSalesOrderChange) And _
     (ls_COF_Stat <> eOfferStatus.osSAPSalesOrderChange) Then
    Call mo_Db.Close(lc_Offer)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$'", Array("$STATUS$", "Planning Process, SAP Sales Order, Bauerer Sales Order"))
    Exit Function
  End If
  
  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  lc_OfferPos = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
    Call mo_Db.Close(lc_Offer)
    Call mo_Db.Close(lc_OfferPos)
    Exit Function
  End If
  
  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, mo_Db.GetFields(lc_Offer, "COF_Code")), "vva100")
  If ll_LockRowId = 0 Then
    Call mo_Db.Close(lc_Offer)
    Call mo_Db.Close(lc_OfferPos)
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress")
    Exit Function
  End If
  
  ls_NewStatus = ""
  lv_OldStatus = ""
  ls_CurrentStatus = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  
  If (ls_COF_Stat = eOfferStatus.osBaeurerSalesOrderChange) Then
    If ls_CurrentStatus = "" Then
      ' this is fresh export (nothing in planning box)
      Call Bae_ExportOfferFullSecretbox(lc_Offer, lc_OfferPos)
    Else
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9882, "#You cannot export into planning box which has items with status $STATUS$", Array("$STATUS$", ls_CurrentStatus))
      Call mo_Db.Close(lc_Offer)
      Call mo_Db.Close(lc_OfferPos)
      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
      Exit Function
    End If
  ElseIf (ls_COF_Stat = eOfferStatus.osSAPSalesOrderChange) Then
    'needs to export only sales order change add and update
    Call Bae_ExportOfferChangeSecretbox(lc_Offer, lc_OfferPos)
  Else
    If ls_CurrentStatus = "" Then
      ' this is fresh export (nothing in planning box)
      Call Bae_ExportOfferFullSecretbox(lc_Offer, lc_OfferPos)
    ElseIf (StrComp(ls_CurrentStatus, BAE_PLABOX_FromCaptureReady, vbTextCompare) = 0) Or _
           (StrComp(ls_CurrentStatus, BAE_PLABOX_RequestReadyForCapture, vbTextCompare) = 0) Or _
           (StrComp(ls_CurrentStatus, BAE_PLABOX_RequestRefusedByManufacturing, vbTextCompare) = 0) Or _
           (StrComp(ls_CurrentStatus, BAE_PLABOX_RequestDeadlineTimeout, vbTextCompare) = 0) Then
      lv_OldStatus = Array(BAE_PLABOX_FromCaptureReady, _
                           BAE_PLABOX_RequestReadyForCapture, _
                           BAE_PLABOX_RequestRefusedByManufacturing, _
                           BAE_PLABOX_RequestDeadlineTimeout)
      ls_NewStatus = BAE_PLABOX_RequestRefusedByCapture
      If Not Bae_UpdatePlaningBoxOfferStatus(ls_COF_Code, lv_OldStatus, ls_NewStatus, as_ErrorMsg) Then
        Call mo_Db.Close(lc_Offer)
        Call mo_Db.Close(lc_OfferPos)
        Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
        Exit Function
      End If
      Call Bae_ExportOfferFullSecretbox(lc_Offer, lc_OfferPos)
    Else
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9882, "#You cannot export into planning box which has items with status $STATUS$", Array("$STATUS$", ls_CurrentStatus))
      Call mo_Db.Close(lc_Offer)
      Call mo_Db.Close(lc_OfferPos)
      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
      Exit Function
    End If
  End If
'  ls_req = "SELECT kn_verarb FROM va1101 WHERE (aufnr_q=$aufnr_q$) AND (fi_nr=$fi_nr$) AND (kn_verarb NOT IN ($kn_verarb$)) ORDER BY aufnr_q, aufpos_q, seblpos"
'  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(mo_Db.GetFields(lc_Offer, "COF_Code")), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$kn_verarb$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestConfirmationMarkedDelete, BAE_PLABOX_RequestConfirmationDeletedByBaeurer, BAE_PLABOX_RequestTrashed)), , , vbTextCompare)
'  lc_PlanBoxCursor = mo_Tools.OpenSQLSafe(mo_DbBaeurer, ls_req)
'  If mo_DbBaeurer.RowCount(lc_PlanBoxCursor) > 0 Then
'
'    Call mo_DbBaeurer.First(lc_PlanBoxCursor)
'    ls_FirstStatus = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "kn_verarb")
'    While Not mo_DbBaeurer.EOF(lc_PlanBoxCursor)
'      ls_CurrentStatus = mo_DbBaeurer.GetFields(lc_PlanBoxCursor, "kn_verarb")
'      If StrComp(ls_CurrentStatus, BAE_PLABOX_RequestInProgress, vbTextCompare) = 0 Then
'        as_ErrorMsg = "#Request is in planning progress"
'        Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
'        Call mo_Db.Close(lc_Offer)
'        Call mo_Db.Close(lc_OfferPos)
'        Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'        Exit Function
'      End If
'      If StrComp(ls_CurrentStatus, BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) = 0 Then
'        as_ErrorMsg = "#Request has been already accepted and sales order created"
'        Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
'        Call mo_Db.Close(lc_Offer)
'        Call mo_Db.Close(lc_OfferPos)
'        Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'        Exit Function
'      End If
'      If StrComp(ls_FirstStatus, ls_CurrentStatus, vbTextCompare) <> 0 Then
'        as_ErrorMsg = "#Inconsistent state of planing box - status mixed: " & ls_FirstStatus & " - " & ls_CurrentStatus
'        Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
'        Call mo_Db.Close(lc_Offer)
'        Call mo_Db.Close(lc_OfferPos)
'        Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'        Exit Function
'      End If
'
'      Call mo_DbBaeurer.Next(lc_PlanBoxCursor)
'    Wend
'    Call mo_DbBaeurer.Close(lc_PlanBoxCursor)
  
'    ls_NewStatus = ""
'    lv_OldStatus = ""
'
'    If StrComp(ls_FirstStatus, BAE_PLABOX_FromCaptureReady, vbTextCompare) = 0 Then
'      lv_OldStatus = BAE_PLABOX_FromCaptureReady
'      ls_NewStatus = BAE_PLABOX_RequestConfirmationDeletedByBaeurer
''    ElseIf StrComp(ls_FirstStatus, BAE_PLABOX_RequestInProgress, vbTextCompare) = 0 Then
''      lv_OldStatus = BAE_PLABOX_RequestInProgress
''      ls_NewStatus = BAE_PLABOX_RequestConfirmationDeletedByBaeurer
'    ElseIf StrComp(ls_FirstStatus, BAE_PLABOX_RequestReadyForCapture, vbTextCompare) = 0 Then
'      lv_OldStatus = BAE_PLABOX_RequestReadyForCapture
'      ls_NewStatus = BAE_PLABOX_RequestConfirmationMarkedDelete
'    ElseIf StrComp(ls_FirstStatus, BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) = 0 Then
'      lv_OldStatus = BAE_PLABOX_RequestAcceptedByCapture
'      ls_NewStatus = BAE_PLABOX_RequestConfirmationMarkedDelete
'    ElseIf StrComp(ls_FirstStatus, BAE_PLABOX_RequestDeadlineTimeout, vbTextCompare) = 0 Then
'      lv_OldStatus = BAE_PLABOX_RequestDeadlineTimeout
'      ls_NewStatus = BAE_PLABOX_RequestConfirmationDeletedByBaeurer
'    ElseIf StrComp(ls_FirstStatus, BAE_PLABOX_RequestRefusedByManufacturing, vbTextCompare) = 0 Then
'      lv_OldStatus = BAE_PLABOX_RequestRefusedByManufacturing
'      ls_NewStatus = BAE_PLABOX_RequestTrashed
'    Else
'      as_ErrorMsg = "#Request has invalid status: '" & ls_FirstStatus & "'"
'      Call mo_Db.Close(lc_Offer)
'      Call mo_Db.Close(lc_OfferPos)
'      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'      Exit Function
'    End If
'
'    If (ls_NewStatus <> "") Then
'      If Not Bae_UpdatePlaningBoxStatus(ls_COF_Code, lv_OldStatus, ls_NewStatus, as_ErrorMsg) Then
'        Call mo_Db.Close(lc_Offer)
'        Call mo_Db.Close(lc_OfferPos)
'        Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'        Exit Function
'      End If
'    End If
'  End If
  
'  ls_req = "UPDATE va1101 SET kn_verarb=$kn_verarb_new$ WHERE aufnr_q=$aufnr_q$ AND fi_nr=$fi_nr$ AND kn_verarb IN ($kn_verarb_old$)"
'  ls_req = Replace(ls_req, "$aufnr_q$", mo_Tools.SQLStr(mo_Db.GetFields(lc_Offer, "COF_Code")), , , vbTextCompare)
'  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(ml_BaeurerFi_Nr), , , vbTextCompare)
'  If lb_PlanningFinished Then
'    ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestConfirmationMarkedDelete), , , vbTextCompare)
'    ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestReadyForCapture)), , , vbTextCompare)
'    Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
'  ElseIf lb_PlanningNotStarted Then
'    ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestConfirmationDeletedByBaeurer), , , vbTextCompare)
'    ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_FromCaptureReady, BAE_PLABOX_RequestInProgress, BAE_PLABOX_RequestAcceptedByCapture)), , , vbTextCompare)
'    Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
'  ElseIf lb_PlanningTimeout Then
'    ls_req = Replace(ls_req, "$kn_verarb_new$", mo_Tools.SQLStr(BAE_PLABOX_RequestConfirmationDeletedByBaeurer), , , vbTextCompare)
'    ls_req = Replace(ls_req, "$kn_verarb_old$", mo_Tools.SqlStrIn(Array(BAE_PLABOX_RequestDeadlineTimeout)), , , vbTextCompare)
'    Call mo_Tools.ExecuteSQLSafe(mo_DbBaeurer, ls_req)
'  End If
  
  
  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Call mo_Db.Close(lc_Offer)
  Call mo_Db.Close(lc_OfferPos)
  Call mo_DbBaeurer.Disconnect
  Bae_ExportSecretBox = True
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrHandler("Bae_ExportSecretBox")
End Function

Private Sub Bae_ExportOfferFullSecretbox(ByVal ac_Offer As Long, ByVal ac_OfferPos As Long)
On Error GoTo ErrHandler

Dim ll_CAT_Id As Long
Dim le_DOF_Id As eDPCOfferDetail
Dim le_OFD_Main As eDPCOfferDetailMain
Dim ls_OFD_SAPAct As String
Dim ls_MFGP_Code As String
  
  Call mo_Db.First(ac_OfferPos)
  While Not mo_Db.EOF(ac_OfferPos)
    le_OFD_Main = mo_Db.GetFields(ac_OfferPos, "OFD_Main")
    ll_CAT_Id = mo_Db.GetFields(ac_OfferPos, "CAT_Id")
    le_DOF_Id = mo_Db.GetFields(ac_OfferPos, "DOF_Id")
    ls_OFD_SAPAct = mo_Db.GetFields(ac_OfferPos, "OFD_SAPAct")
    ls_MFGP_Code = mo_Db.GetFields(ac_OfferPos, "MFGP_Code")
    
      If (le_OFD_Main = eDPCOfferDetailMain.odMain) And _
         (le_DOF_Id = eDPCOfferDetail.odPosition) And _
        (ll_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) Then
      ' export rankweil vendor only
      If (StrComp(ls_MFGP_Code, RANKWEIL_PLANT_CODE, vbTextCompare) = 0) Then
        If (StrComp(ls_OFD_SAPAct, "D", vbTextCompare) <> 0) And (StrComp(ls_OFD_SAPAct, "K", vbTextCompare) <> 0) Then
          Call Bae_InsertProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)
        End If
      End If
    End If
    Call mo_Db.Next(ac_OfferPos)
  Wend
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_ExportOfferFullSecretbox")
End Sub

Private Sub Bae_ExportOfferChangeSecretbox(ByVal ac_Offer As Long, ByVal ac_OfferPos As Long)
On Error GoTo ErrHandler

Dim ll_CAT_Id As Long
Dim le_DOF_Id As eDPCOfferDetail
Dim le_OFD_Main As eDPCOfferDetailMain
Dim ls_OFD_SAPAct As String
Dim ls_MFGP_Code As String
  
  Call mo_Db.First(ac_OfferPos)
  While Not mo_Db.EOF(ac_OfferPos)
    le_OFD_Main = mo_Db.GetFields(ac_OfferPos, "OFD_Main")
    ll_CAT_Id = mo_Db.GetFields(ac_OfferPos, "CAT_Id")
    le_DOF_Id = mo_Db.GetFields(ac_OfferPos, "DOF_Id")
    ls_OFD_SAPAct = mo_Db.GetFields(ac_OfferPos, "OFD_SAPAct")
    ls_MFGP_Code = mo_Db.GetFields(ac_OfferPos, "MFGP_Code")
    
      If (le_OFD_Main = eDPCOfferDetailMain.odMain) And _
         (le_DOF_Id = eDPCOfferDetail.odPosition) And _
         (ll_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) Then
      ' export rankweil vendor only
      If (StrComp(ls_MFGP_Code, RANKWEIL_PLANT_CODE, vbTextCompare) = 0) Then
        If StrComp(ls_OFD_SAPAct, "A", vbTextCompare) = 0 Then
          Call Bae_InsertProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)
        ElseIf StrComp(ls_OFD_SAPAct, "R", vbTextCompare) = 0 Then
          Call Bae_DeleteProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)
          Call Bae_InsertProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)

          'Call Bae_UpdateProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)
        End If
      End If
    End If
    Call mo_Db.Next(ac_OfferPos)
  Wend
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_ExportOfferChangeSecretbox")
End Sub

'Public Function ExportSecretBox(ByVal ac_Offer As Long, ByVal ac_OfferPos As Long) As Boolean
'On Error GoTo ErrHandler
'
'Dim lo_Product As DPC_Product
'Dim ll_LockRowId As Long
'Dim lc_Offer As Long
'Dim lc_OfferPos As Long
'Dim lc_PlanBoxCursor As Long
'Dim ls_Req As String
'Dim ls_Status As String

    
'  ls_Req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
'  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
'  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_Req)
'
'  ls_Req = "exec Cap_OfferDetail_lst2 $COF_Id$, $Language_Code$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
'  ls_Req = Replace(ls_Req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$Language_Code$", mo_Tools.SQLStr("E"), , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_Main$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_IdPar$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_Valid$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
'  lc_OfferPos = mo_Tools.OpenSQLSafe(mo_Db, ls_Req, 1)
'
'  Set lo_Product = New DPC_Product
'  Set lo_Product.Tools = mo_Tools
'  Set lo_Product.ArmDb = mo_Db
'  lo_Product.U_Code = ml_U_Code
'  lo_Product.CT_Code = ms_CT_Code
'  lo_Product.CURR_Code = "EUR"
'  lo_Product.ValidityDate = ValidityDate
'  lo_Product.Language_Code = "E"
'  lo_Product.COF_Id = as_COF_Id
'  Call lo_Product.Load_A_COM
'  Call lo_Product.InitOffer
'  Call lo_Product.Load(mo_Db.GetFields(lc_OfferPos, "PRD_ID"))
'  Call lo_Product.LoadOffer(as_COF_Id, as_OFD_Id)
  
  'll_LockRowId = LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, mo_Db.GetFields(lc_Offer, "COF_Code")), "vva100")
'  Call InsertProductSecretBox(mo_DbBaeurer, ac_Offer, ac_OfferPos)
  'Call UnlockRecord(mo_DbBaeurer, ll_LockRowId)
'  Call mo_Db.Close(lc_Offer)
'  Call mo_Db.Close(lc_OfferPos)
'  Call lo_Product.Unload_A_COM
'  Set lo_Product = Nothing
'  ExportSecretBox = True
'  Exit Function
'ErrHandler:
'  Call ErrHandler("ExportSecretBox")
'End Function

'Public Sub Bae_ExportCustomerAll()
'On Error GoTo ErrHandler
'
'Dim lc_Cursor As Long
'Dim ls_Req As String
'Dim ll_RowIdTran As Long
'
'  ls_Req = "exec xxx_lst $PRD_Id$,$Cust_Status$"
'  ls_Req = Replace(ls_Req, "$PRD_Id$", "NULL", , , vbTextCompare)
'  ls_Req = Replace(ls_Req, "$Cust_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esReadyToExport), , vbTextCompare)
'  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Req)
'  While Not mo_Db.EOF(lc_Cursor)
'    ll_RowIdTran = Bae_ExportArticle(mo_Db.GetFields(mo_Db, "PRD_Id"))
'
'    ls_Req = "UPDATE xxxxx SET "
'    ls_Req = ls_Req & "PMaster_Status=$PMaster_Status$,"
'    ls_Req = ls_Req & "PMaster_Date=getdate(),"
'    ls_Req = ls_Req & "PMaster_Rowidtran=$Rowidtran$,"
'    ls_Req = ls_Req & "Z_Last_Upd_User=$Z_Last_Upd_User$,"
'    ls_Req = ls_Req & "Z_Last_Upd=getdate(),"
'    ls_Req = ls_Req & "WHERE PRD_Id=$PRD_Id$"
'    ls_Req = Replace(ls_Req, "$PRD_Id$", "NULL", , , vbTextCompare)
'    ls_Req = Replace(ls_Req, "$PMaster_Status$", mo_Tools.SqlInt(eDPCBaeurerExportStatus.esExported), , vbTextCompare)
'    ls_Req = Replace(ls_Req, "$Rowidtran$", mo_Tools.SqlInt(ll_RowIdTran), , vbTextCompare)
'    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Req, 1)
'    Call mo_Db.Next(lc_Cursor)
'  Wend
'  Call mo_Db.Close(lc_Cursor)
'  Exit Sub
'ErrHandler:
'  Call ErrHandler("Bae_ExportCustomerAll")
'End Sub

Public Function Bae_ExportCustomer(ByVal as_CCU_Capkey As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim lo_XmlDocCust As Object
Dim ll_RowIdTran As Long
Dim ll_Konto As Long
Dim ls_Request As String
Dim lc_Cursor As Long
Dim ll_VersionCust As Long

  Bae_ExportCustomer = False
  
  Call ClearLogInterface
  mo_ILO.ILO_Interface = eDPCXmlExportType.etBae_Customer
  mo_ILO.ILO_MasterId = as_CCU_Capkey
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
    Exit Function
  End If
  
  
  ls_Request = "SELECT CCU_B7Konto FROM claim_customer WHERE CCU_Capkey=$CCU_Capkey$"
  ls_Request = Replace(ls_Request, "$CCU_Capkey$", mo_Tools.SQLStr(as_CCU_Capkey), , , vbTextCompare)
  ll_Konto = mo_Tools.SelectValue(mo_Db, ls_Request)
  
  If ll_Konto = 0 Then
    
    ls_Request = "SELECT MAX(Konto) + 1 FROM g600 where konto < 99999999 and fi_nr = 1"
    ll_Konto = mo_Tools.SelectValue(mo_DbBaeurer, ls_Request)
    
    ls_Request = "UPDATE claim_customer SET CCU_B7Konto=$CCU_B7Konto$ WHERE CCU_CapKey=$CCU_Capkey$"
    ls_Request = Replace(ls_Request, "$CCU_B7Konto$", mo_Tools.SqlInt(ll_Konto), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$CCU_Capkey$", mo_Tools.SQLStr(as_CCU_Capkey), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
    
    Set lo_XmlDocCust = Bae_CreateXMLDocument(mo_Db, eDPCXmlExportType.etBae_Customer, as_CCU_Capkey, ll_VersionCust, Nothing)
    
    Call Bae_SaveXMLDocument(lo_XmlDocCust, "CUST", as_ErrorMsg)
    
    ll_RowIdTran = Bae_ExportCustomerRecord(mo_DbBaeurer, 0, ll_Konto, eDPCXmlExportType.etBae_Customer, lo_XmlDocCust, ll_VersionCust)
    Call Bae_ExportCustomerComplete(mo_DbBaeurer, ll_RowIdTran, as_CCU_Capkey)
    
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
    
    Bae_ExportCustomer = True
  Else
    mo_ILO.ILO_Error = "Konto <> 0"
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9904, "#Item is already exported")
  End If
  
  Call LogInterface(mo_Db, ml_U_Code)
    
  Exit Function
ErrHandler:
  
  mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
  Call LogInterface(mo_Db, ml_U_Code)
    
  Call ErrHandler("Bae_ExportCustomer")
End Function

Private Function Bae_ExportPMasterRecord(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal as_Key As String, ByVal ae_ATR_Type As eDPCXmlExportType, ByRef ao_XMLDoc As MSXML2.DOMDocument, ByVal al_Version As Long) As Long
On Error GoTo ErrHandler

Dim ls_req As String
Dim ls_path As String
Dim ll_RowId As Long
Dim lc_Cursor As Long

  Call ClearLogInterface
  mo_ILO.ILO_Interface = ae_ATR_Type
  mo_ILO.ILO_MasterId = as_Key
  
  ls_req = "INSERT INTO tran_sc " & _
              "(rowidtran,identnr,var,xmldatatype,xmllong,status_tran,msg_text,uebdat,verarbdat,versionsnr,source) " & _
              "VALUES " & _
              "($rowidtran$, $identnr$, $var$, $xmldatatype$, $xmllong$, $status_tran$, $msg_text$, $uebdat$, $verarbdat$, $versionsnr$, $source$)"
              
  
  ls_req = Replace(ls_req, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  ls_req = Replace(ls_req, "$status_tran$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$msg_text$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_req = Replace(ls_req, "$uebdat$", "getdate()", , , vbTextCompare)
  ls_req = Replace(ls_req, "$verarbdat$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$versionsnr$", mo_Tools.SqlInt(al_Version), , , vbTextCompare)
  ls_req = Replace(ls_req, "$source$", mo_Tools.SQLStr(ms_BaeurerSource), , , vbTextCompare)
  
  ls_req = Replace(ls_req, "$identnr$", mo_Tools.SqlStrKey(as_Key), , , vbTextCompare)
  ls_req = Replace(ls_req, "$var$", mo_Tools.SQLStr(""), , , vbTextCompare)
  
  Select Case ae_ATR_Type
  Case eDPCXmlExportType.etBae_ArticleMaster
    ls_path = CreateXMLPath("PMASTER", as_Key)
    ls_req = Replace(ls_req, "$xmldatatype$", mo_Tools.SQLStr("PMASTER"), , , vbTextCompare)
  Case eDPCXmlExportType.etBae_BOM
    ls_path = CreateXMLPath("BOM", as_Key)
    ls_req = Replace(ls_req, "$xmldatatype$", mo_Tools.SQLStr("BOM"), , , vbTextCompare)
  Case eDPCXmlExportType.etBae_BOR
    ls_path = CreateXMLPath("BOR", as_Key)
    ls_req = Replace(ls_req, "$xmldatatype$", mo_Tools.SQLStr("BOR"), , , vbTextCompare)
  Case eDPCXmlExportType.etBae_Material
    ls_path = CreateXMLPath("PMASTER", as_Key)
    ls_req = Replace(ls_req, "$xmldatatype$", mo_Tools.SQLStr("PMASTER"), , , vbTextCompare)
  Case Else
    mo_ILO.ILO_Error = "Invalid ATR_Type: " & ae_ATR_Type
    Err.Raise ArmErr.InvalidArgument, "ae_ATR_Type", "Invalid ATR_Type: " & ae_ATR_Type
  End Select
  
  ls_req = Replace(ls_req, "$xmllong$", mo_Tools.SQLStr(ao_XMLDoc.xml), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  ll_RowId = mo_Tools.GetLastIdentity(ao_Db)
 
  If al_RowIdTran = 0 Then
    ls_req = "UPDATE tran_sc SET rowidtran=rowid where rowid=$rowid$"
    ls_req = Replace(ls_req, "$rowid$", mo_Tools.SqlInt(ll_RowId), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_req)
  End If
  Bae_ExportPMasterRecord = ll_RowId
  
  mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
  Call LogInterface(mo_Db, ml_U_Code)
  
  Exit Function
ErrHandler:

  mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
  Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("Bae_ExportPMasterRecord")
End Function

Private Function Bae_ExportCustomerRecord(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal al_Konto As Long, ByVal ae_ATR_Type As eDPCXmlExportType, ByRef ao_XMLDoc As MSXML2.DOMDocument, ByVal al_Version As Long) As Long
On Error GoTo ErrHandler

Dim ls_Request As String
Dim ls_RequestTran As String
Dim ls_path As String
Dim ll_RowId As Long
Dim lc_Cursor As Long

  ls_Request = "INSERT INTO tran_cus (rowidtran, konto, satzart, xmldatatype, xmllong, status_tran, msg_text, uebdat, verarbdat, versionsnr, source) " & _
              " VALUES " & _
              "($rowidtran$, $konto$, $satzart$, $xmldatatype$, $xmllong$, $status_tran$, $msg_text$, $uebdat$, $verarbdat$, $versionsnr$, $source$)"
  ls_RequestTran = "UPDATE tran_cus SET rowidtran=rowid where rowid=$rowid$"
  
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$msg_text$", mo_Tools.SQLStr(""), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$uebdat$", "getdate()", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$verarbdat$", "NULL", , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$versionsnr$", mo_Tools.SqlInt(al_Version), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$source$", mo_Tools.SQLStr(ms_BaeurerSource), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$konto$", mo_Tools.SqlIntKey(al_Konto), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$satzart$", mo_Tools.SqlInt(1), , , vbTextCompare)
  
  ls_path = CreateXMLPath("CUST", al_Konto)
  
  If ae_ATR_Type = eDPCXmlExportType.etBae_Customer Then
    ls_Request = Replace(ls_Request, "$xmldatatype$", mo_Tools.SQLStr("CUSTOMER"), , , vbTextCompare)
  Else
    Err.Raise ArmErr.InvalidArgument, "ae_ATR_Type", "Invalid ATR_Type: " & ae_ATR_Type
  End If
  
  ls_Request = Replace(ls_Request, "$xmllong$", mo_Tools.SQLStr(ao_XMLDoc.xml), , , vbTextCompare)
  Call ao_XMLDoc.Save(ls_path)
  
'  If Not ao_Db.FileToBlobSQL(ls_Request, ls_Path, 0, 0) Then
'    Err.Raise ArmErr.CompFncFailed, "FileToBlobSQL", ao_Db.LastErrorMessage
'  End If
  
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  ll_RowId = mo_Tools.GetLastIdentity(ao_Db)
 
  If al_RowIdTran = 0 Then
    ls_RequestTran = Replace(ls_RequestTran, "$rowid$", mo_Tools.SqlInt(ll_RowId), , , vbTextCompare)
    Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_RequestTran)
  End If
  Bae_ExportCustomerRecord = ll_RowId
  If InStr(1, mo_Tools.GetAConfigData("DPC_DEBUG_XML"), ms_PC_Name, vbTextCompare) >= 1 Then
  Call mo_Shell.Run("""" & ls_path & """")
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_ExportCustomerRecord")
End Function

Private Function CreateXMLPath(ByVal as_ExportName As String, ByVal as_Key As String) As String
On Error GoTo ErrHandler
Dim ls_path As String

  ls_path = ms_TempDir
  as_Key = Replace(as_Key, "\", "_", , , vbTextCompare)
  as_Key = Replace(as_Key, "/", "_", , , vbTextCompare)
  as_Key = Replace(as_Key, "$", "_", , , vbTextCompare)
  as_Key = Replace(as_Key, "*", "_", , , vbTextCompare)
  
  CreateXMLPath = ls_path & "\" & as_ExportName & as_Key & ".xml"
  Exit Function
ErrHandler:
  Call ErrHandler("CreateXMLPath")
End Function

Private Sub Bae_ExportCustomerComplete(ByVal ao_Db As Object, ByVal al_RowIdTran As Long, ByVal as_CCU_Capkey As String)
On Error GoTo ErrHandler

  Dim ls_Request As String

  ls_Request = "UPDATE tran_cus SET status_tran=$status_tran$ where rowidtran=$rowidtran$"
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(ROWIDTRANSTATUS_NEW), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_ExportCustomerComplete")
End Sub

Private Sub Bae_ExportPMasterComplete(ByVal ao_Db As Object, ByVal al_RowIdTran As Long)
On Error GoTo ErrHandler

  Dim ls_Request As String

  ls_Request = "UPDATE tran_sc SET status_tran=$status_tran$ where rowidtran=$rowidtran$"
  ls_Request = Replace(ls_Request, "$status_tran$", mo_Tools.SQLStr(ROWIDTRANSTATUS_NEW), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$rowidtran$", mo_Tools.SqlInt(al_RowIdTran), , , vbTextCompare)
  Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
  Exit Sub
ErrHandler:
  Call ErrHandler("Bae_ExportPMasterComplete")
End Sub

Public Function ConvertCodeFromAMC(ByVal as_CodeConversion As String, ByVal as_CodeOut As String) As String
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_Request As String

  ConvertCodeFromAMC = ""
  ls_Request = "SELECT AC_CodeIn "
  ls_Request = ls_Request & "FROM A_CodeTranslator "
  ls_Request = ls_Request & "WHERE "
  ls_Request = ls_Request & "AC_CodeLookup = $AC_CodeLookup$ AND "
  ls_Request = ls_Request & "AC_CodeOut = $AC_CodeOut$"
    
  ls_Request = Replace(ls_Request, "$AC_CodeLookup$", mo_Tools.SQLStr(as_CodeConversion), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$AC_CodeOut$", mo_Tools.SQLStr(as_CodeOut), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ConvertCodeFromAMC = mo_Db.GetFields(lc_Cursor, "AC_CodeIn")
  Else
    Err.Raise ArmErr.InvalidArgument, "as_CodeIn", "Invalid conversion code as_CodeConversion: " & as_CodeConversion & " as_CodeOut: " & as_CodeOut
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call mo_Db.Close(lc_Cursor)
  Call ErrHandler("ConvertCodeFromAMC")
End Function

Public Function ConvertCodeToAMC(ByVal as_CodeConversion As String, ByVal as_CodeIn As String) As String
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_Request As String

  ConvertCodeToAMC = ""
  ls_Request = "SELECT AC_CodeOut "
  ls_Request = ls_Request & "FROM A_CodeTranslator "
  ls_Request = ls_Request & "WHERE "
  ls_Request = ls_Request & "AC_CodeLookup = $AC_CodeLookup$ AND "
  ls_Request = ls_Request & "AC_CodeIn = $AC_CodeIn$"
  
  ls_Request = Replace(ls_Request, "$AC_CodeLookup$", mo_Tools.SQLStr(as_CodeConversion), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$AC_CodeIn$", mo_Tools.SQLStr(as_CodeIn), , , vbTextCompare)
  
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    ConvertCodeToAMC = mo_Db.GetFields(lc_Cursor, "AC_CodeOut")
  Else
    Err.Raise ArmErr.InvalidArgument, "as_CodeIn", "Invalid conversion code as_CodeConversion: " & as_CodeConversion & " as_CodeIn: " & as_CodeIn
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call mo_Db.Close(lc_Cursor)
  Call ErrHandler("ConvertCodeToAMC")
End Function

Private Function GetATRValue(ByVal al_CursorXML As Long, ByVal al_CursorMaster As Long, ByVal al_ATR_Name As String) As Variant
On Error GoTo ErrHandler

Dim ls_Value As String
Dim ls_place As String

  GetATRValue = ""
  
  If mo_Db.Find(al_CursorXML, "ATR_Name", al_ATR_Name, 0, 1) < 0 Then
       Err.Raise ArmErr.SQLBadRowExpectedCount, "Distinct", "No SQL Data for XML export found. ATR_B7Name missing:" + al_ATR_Name
  Else
    ls_place = mo_Db.GetFields(al_CursorXML, "ATR_Value")
    If InStr(ls_place, "$") > 0 Then
        GetATRValue = mo_Db.GetFields(al_CursorMaster, Replace(ls_place, "$", ""))
    Else
        GetATRValue = ls_place
    End If
  End If
    
  Exit Function
ErrHandler:
  Call ErrHandler("GetATRValue")
End Function

Private Function SplitATRValue(ByVal as_Value As String, ByVal al_DataLength As Long) As String()
On Error GoTo ErrHandler

Dim la_StrValues() As String
Dim ll_Dimension As Integer
Dim ll_Index As Integer
Dim ll_Pos As Integer

    SplitATRValue = la_StrValues
    
    ReDim la_StrValues(0)
    ll_Index = 0
    as_Value = Replace(as_Value, vbCrLf, vbCr)
    as_Value = Replace(as_Value, vbLf, " ") 'mw 18.06.2015 - quick fix
    
    If (Len(as_Value) > al_DataLength) Or (InStr(1, as_Value, vbCr) > 0) Then
      While ((Len(as_Value) > al_DataLength) Or (InStr(1, as_Value, vbCr) > 0))
      
          ReDim Preserve la_StrValues(UBound(la_StrValues) + 1)
          ll_Pos = InStr(1, as_Value, vbCr)
          If (ll_Pos > al_DataLength + 1) Or (ll_Pos <= 0) Then
              ll_Pos = InStrRev(as_Value, " ", al_DataLength)
          End If
          If ll_Pos > 0 Then
              la_StrValues(ll_Index) = Trim(Left(as_Value, ll_Pos - 1))
              ll_Index = ll_Index + 1
              as_Value = Trim(right(as_Value, Len(as_Value) - ll_Pos))
          Else
              la_StrValues(ll_Index) = Left(as_Value, al_DataLength)
              ll_Index = ll_Index + 1
              as_Value = right(as_Value, Len(as_Value) - al_DataLength)
          End If
      Wend
      If Len(as_Value) > 0 Then
          la_StrValues(ll_Index) = Trim(as_Value)
      Else
          ReDim Preserve la_StrValues(UBound(la_StrValues) - 1)
      End If
    Else
      ReDim la_StrValues(0)
      la_StrValues(0) = as_Value
    End If
    
    SplitATRValue = la_StrValues
    
  Exit Function
ErrHandler:
  Call ErrHandler("SplitATRValue")
End Function

Private Function SAP_SalesOrderCheckOfferHeader(ByVal ac_Offer As Long, ByVal ab_SalesOrderChange As Boolean, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

  SAP_SalesOrderCheckOfferHeader = False
  If (mo_Db.GetFields(ac_Offer, "COF_DeDesc") <> "") Or _
     (mo_Db.GetFields(ac_Offer, "COF_DeAdr1") <> "") Or _
     (mo_Db.GetFields(ac_Offer, "COF_DeAdr2") <> "") Or _
     (mo_Db.GetFields(ac_Offer, "COF_DeTown") <> "") Or _
     (mo_Db.GetFields(ac_Offer, "COF_DeZip") <> "") Or _
     (mo_Db.GetFields(ac_Offer, "COF_DeCT") <> "") Then
     
    If (mo_Db.GetFields(ac_Offer, "COF_DeDesc") = "") Or _
       (mo_Db.GetFields(ac_Offer, "COF_DeAdr1") = "") Or _
       (mo_Db.GetFields(ac_Offer, "COF_DeTown") = "") Or _
       (mo_Db.GetFields(ac_Offer, "COF_DeZip") = "") Or _
       (mo_Db.GetFields(ac_Offer, "COF_DeCT") = "") Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9883, "#Delivery Name, Street, Town and Country is mandatory.")
      Exit Function
    End If
  End If
    
  If mo_Db.GetFields(ac_Offer, "CUST_Code") = "" Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9884, "#Customer must be SAP buying customer")
    Exit Function
  End If
  
  If ab_SalesOrderChange Then
    If (mo_Db.GetFields(ac_Offer, "COF_Stat") <> eOfferStatus.osSAPSalesOrderChange) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$' only", Array("$STATUS$", "#SAP Change SO"))
      Exit Function
    End If
  Else
    If (mo_Db.GetFields(ac_Offer, "COF_Stat") <> eOfferStatus.osWaitCustConfirmation) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$' only", Array("$STATUS$", "#Waiting customer confirmation"))
      Exit Function
    End If
  End If
  
  SAP_SalesOrderCheckOfferHeader = True
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_SalesOrderCheckOfferHeader")
End Function

'Private Function SAP_SalesOrderChangeCheckOfferDetail(ByVal ac_OfferDetail As Long, ByRef as_ErrorMsg As String) As Boolean
'On Error GoTo ErrHandler
'
'Dim ll_ActionChangeCount As Long
'
'  SAP_SalesOrderChangeCheckOfferDetail = False
'  ll_ActionChangeCount = 0
'  Call mo_Db.First(ac_OfferDetail)
'  While Not mo_Db.EOF(ac_OfferDetail)
'    If mo_Db.GetFields(ac_OfferDetail, "OFD_SAPAct") <> "" Then
'      ll_ActionChangeCount = ll_ActionChangeCount + 1
'    End If
'    Call mo_Db.Next(ac_OfferDetail)
'  Wend
'  If ll_ActionChangeCount = 0 Then
'    as_ErrorMsg = as_ErrorMsg & "No action code changed in sales order"
'    Exit Function
'  End If
'  SAP_SalesOrderChangeCheckOfferDetail = True
'  Exit Function
'ErrHandler:
'  Call ErrHandler("SAP_SalesOrderChangeCheckOfferDetail")
'End Function

Private Function SAP_SalesOrderCheckOfferDetail(ByVal ac_OfferDetail As Long, ByVal ab_SalesOrderChange As Boolean, ByRef ab_UsePlanningBox As Boolean, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim le_OFD_Main As eDPCOfferDetailMain
Dim le_DOF_Id As eDPCOfferDetail
Dim le_CAT_Id As eDPCCategory
Dim ls_PRD_Code As String
Dim ll_LinesCount As Long
Dim ll_LinesChangeCount As Long
Dim ls_BlockExport As String

  ls_BlockExport = ""
  SAP_SalesOrderCheckOfferDetail = False
  ab_UsePlanningBox = False
  ll_LinesCount = 0
  ll_LinesChangeCount = 0
  Call mo_Db.First(ac_OfferDetail)
  While Not mo_Db.EOF(ac_OfferDetail)
  
    le_OFD_Main = mo_Db.GetFields(ac_OfferDetail, "OFD_Main")
    le_DOF_Id = mo_Db.GetFields(ac_OfferDetail, "DOF_Id")
    le_CAT_Id = mo_Db.GetFields(ac_OfferDetail, "CAT_Id")
    ls_PRD_Code = mo_Db.GetFields(ac_OfferDetail, "PRD_Code")
    
    If ((le_DOF_Id = eDPCOfferDetail.odPosition) And _
        (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
        ((StrComp(mo_Db.GetFields(ac_OfferDetail, "VEN_BlockSAP"), "X", vbTextCompare) = 0) Or _
        (StrComp(mo_Db.GetFields(ac_OfferDetail, "SAP_Export"), "X", vbTextCompare) <> 0))) Or _
       (le_DOF_Id = eDPCOfferDetail.odManualPosition) Then
      
      ' collect info about blocked items
      'If (Not ab_SalesOrderChange) Or (ab_SalesOrderChange And Trim(mo_Db.GetFields(ac_OfferDetail, "OFD_SAPAct")) <> "") Then
        If ls_BlockExport <> "" Then
          ls_BlockExport = ls_BlockExport & ","
        End If
        ls_BlockExport = ls_BlockExport & mo_Db.GetFields(ac_OfferDetail, "PRD_Code")
      'End If
    Else
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
         (le_DOF_Id = eDPCOfferDetail.odPosition) And _
         (StrComp(mo_Db.GetFields(ac_OfferDetail, "MFGP_Code"), RANKWEIL_PLANT_CODE, vbTextCompare) = 0) Then
        ab_UsePlanningBox = True
      End If
      
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
         (le_DOF_Id = eDPCOfferDetail.odPosition) Then
        If mo_Db.GetFields(ac_OfferDetail, "PRD_StaSAP") <> eDPCInterfaceStatus.isOK Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9885, "#Not all custom materials inside sales order were successfuly exported to SAP: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          Exit Function
        End If
      End If
      
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
         (le_DOF_Id = eDPCOfferDetail.odPosition) Then
        If (mo_Db.GetFields(ac_OfferDetail, "PRD_StaBae") <> eDPCInterfaceStatus.isOK) And _
          (StrComp(mo_Db.GetFields(ac_OfferDetail, "MFGP_Code"), RANKWEIL_PLANT_CODE, vbTextCompare) = 0) Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9879, "#Not all custom materials inside sales order were successfuly exported to B7: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          Exit Function
        End If
      End If
    

      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
         (le_DOF_Id = eDPCOfferDetail.odPosition) And _
          (StrComp(mo_Db.GetFields(ac_OfferDetail, "MFGP_Code"), RANKWEIL_PLANT_CODE, vbTextCompare) = 0) Then
        If ab_SalesOrderChange Then
          If (StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestReadyForCapture, vbTextCompare) <> 0) And _
             (StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) <> 0) Then
            'as_ErrorMsg = as_ErrorMsg & "Not all custom metal materials inside sales order were successfuly planned in planning box B7: " & ls_PRD_Code & vbCrLf
            as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9886, "#Not all custom metal materials inside sales order were successfuly planned in planning box B7: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
            Exit Function
          End If
        Else
          If StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestReadyForCapture, vbTextCompare) <> 0 Then
            'as_ErrorMsg = as_ErrorMsg & "Not all custom metal materials inside sales order were successfuly planned in planning box B7: " & ls_PRD_Code & vbCrLf
            as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9886, "#Not all custom metal materials inside sales order were successfuly planned in planning box B7: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
            Exit Function
          End If
        End If
      End If
      
      'If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
      '   (le_DOF_Id = eDPCOfferDetail.odPosition) Then
      '  If ((Trim(mo_Db.GetFields(ac_OfferDetail, "OFD_OrdNrB7")) = "") Or (mo_Db.GetFields(ac_OfferDetail, "OFD_PosB7") = 0)) And _
      '    (StrComp(mo_Db.GetFields(ac_OfferDetail, "MFGP_Code"), RANKWEIL_PLANT_CODE, vbTextCompare) = 0) Then
      '    as_ErrorMsg = as_ErrorMsg & "Not all standard and custom metal materials inside sales order were planned in planning box B7: " & ls_PRD_Code
      '    Exit Function
      '  End If
      'End If
    
      If (le_DOF_Id = eDPCOfferDetail.odPosition) Or _
         (le_DOF_Id = eDPCOfferDetail.odSubconstItemAdditional) Or _
         (le_DOF_Id = eDPCOfferDetail.odSubconstItemGrid) Or _
         (le_DOF_Id = eDPCOfferDetail.odSubconstItemPanelSecurity) Or _
         (le_DOF_Id = eDPCOfferDetail.odSubconstItemSusp) Then
        
        If (mo_Db.GetFields(ac_OfferDetail, "OFD_Price") <= 0) And (mo_Db.GetFields(ac_OfferDetail, "OFD_IsFree") = "") Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9887, "#Price of item is 0, but is not marked as free of charge: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          'as_ErrorMsg = as_ErrorMsg & "Price of item is 0, but is not marked as free of charge: " & ls_PRD_Code
          Exit Function
        End If
      
        If (mo_Db.GetFields(ac_OfferDetail, "OFD_Price") > 0) And (mo_Db.GetFields(ac_OfferDetail, "OFD_IsFree") = "X") Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9888, "#Price of item greater than 0, but is marked as free of charge: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          'as_ErrorMsg = as_ErrorMsg & "Price of item greater than 0, but is marked as free of charge: " & ls_PRD_Code
          Exit Function
        End If
        
        ll_LinesCount = ll_LinesCount + 1
        
        If Trim(mo_Db.GetFields(ac_OfferDetail, "OFD_SAPAct")) <> "" Then
          ll_LinesChangeCount = ll_LinesChangeCount + 1
        End If
      End If
  
    End If
    
    Call mo_Db.Next(ac_OfferDetail)
  Wend

  If ll_LinesCount > 166 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9889, "#Order contain more than $MAXLINES$ lines. Please split order into more documents.", Array("$MAXLINES$", 166)) & vbCrLf
    'as_ErrorMsg = as_ErrorMsg & "#Order contain more than 166 lines. Please split order into more documents."
    Exit Function
  End If
  
  If ab_SalesOrderChange Then
    If ll_LinesChangeCount = 0 Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9890, "#Nothing to export.") & vbCrLf
      'as_ErrorMsg = as_ErrorMsg & "#Nothing to export to SAP"
      Exit Function
    End If
  Else
    If ll_LinesCount = 0 Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9890, "#Nothing to export.") & vbCrLf
      'as_ErrorMsg = as_ErrorMsg & "#Nothing to export to SAP"
      Exit Function
    End If
  End If
  
  If ls_BlockExport <> "" Then
    If mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9891, "#Those positions will be NOT exported to SAP: $BlockExport$. Do you want to continue ?", Array("$BlockExport$", ls_BlockExport), vbYesNo) <> vbYes Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9892, "#Export interrupted. Positions will be NOT exported to SAP: $BlockExport$", Array("$BlockExport$", ls_BlockExport))
      Exit Function
    End If
  End If
  SAP_SalesOrderCheckOfferDetail = True
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_SalesOrderCheckOfferDetail")
End Function

Public Function SAP_OfferMaterialCreate(ByVal as_COF_Id As String, ByRef al_Count As Long, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String, lc_Cursor As Long
Dim ls_OFD_Id As String, ls_PRD_Id As String, ls_PRD_Code As String
Dim le_DOF_Id As eDPCOfferDetail, le_CAT_Id As eDPCCategory
Dim le_SAP_Sta As eDPCInterfaceStatus
Dim ls_Status As String, ls_COF_Code As String
Dim lc_Offer As Long

  SAP_OfferMaterialCreate = False
  as_ErrorMsg = ""
  al_Count = 0
  
  lc_Offer = GetOfferCursor(as_COF_Id)
  If Not SAP_SalesOrderCheckOfferHeader(lc_Offer, (mo_Db.GetFields(lc_Offer, "COF_Stat") = eOfferStatus.osSAPSalesOrderChange), as_ErrorMsg) Then
    Call mo_Db.Close(lc_Offer)
    Exit Function
  End If
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  Call mo_Db.Close(lc_Offer)
  
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed") & vbCrLf
    Exit Function
  End If

  ls_Status = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  If InStr(1, ls_Status, BAE_PLABOX_RequestDeadlineTimeout, vbTextCompare) > 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9893, "#Planning Box reservation is expired") & vbCrLf
    'as_ErrorMsg = "#Planning Box reservation is expired"
    Exit Function
  End If
  
  ls_req = "exec DPC_SAPOfferDetailCheck_lst $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  While Not mo_Db.EOF(lc_Cursor)
    ls_OFD_Id = mo_Db.GetFields(lc_Cursor, "OFD_Id")
    le_DOF_Id = mo_Db.GetFields(lc_Cursor, "DOF_Id")
    le_CAT_Id = mo_Db.GetFields(lc_Cursor, "CAT_Id")
    ls_PRD_Id = mo_Db.GetFields(lc_Cursor, "PRD_Id")
    ls_PRD_Code = mo_Db.GetFields(lc_Cursor, "PRD_Code")
    le_SAP_Sta = Val(mo_Tools.SelectValue(mo_Db, "SELECT PRD_StaSAP FROM DPC_PrdCommon WHERE PRD_Id=" & mo_Tools.SQLStr(ls_PRD_Id)))
    
    If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
       (le_DOF_Id = eDPCOfferDetail.odPosition) And _
        (le_SAP_Sta <> eDPCInterfaceStatus.isOK) Then
    
      
      If mo_Db.GetFields(lc_Cursor, "SAP_View") <> 1 Then
        as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9894, "#Invalid combination of legal entity, vendor and shipping point. Product code: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
        'as_ErrorMsg = "#Invalid combination of legal entity, vendor and shipping point. Product code: " & ls_PRD_Code
        Call mo_Db.Close(lc_Cursor)
        Exit Function
      End If
      
      If (StrComp(mo_Db.GetFields(lc_Cursor, "SAP_Export"), "X", vbTextCompare) = 0) And _
         (StrComp(mo_Db.GetFields(lc_Cursor, "VEN_BlockSAP"), "X", vbTextCompare) <> 0) Then
         
         
        If (mo_Db.GetFields(lc_Cursor, "RPL_NWgh") = 0) Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9895, "#Please, generate BOM/BOR, weight of the panel is empty. Product code: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          Call mo_Db.Close(lc_Cursor)
          Exit Function
        End If
        
        If (mo_Db.GetFields(lc_Cursor, "CostCheck") = 0) Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 666, "#Please, check that generated article cost is correct.  Product code: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          Call mo_Db.Close(lc_Cursor)
          Exit Function
        End If
        
        If SAP_MaterialCreate(as_COF_Id, ls_OFD_Id, as_ErrorMsg) Then
          al_Count = al_Count + 1
          le_SAP_Sta = eDPCInterfaceStatus.isOK
  '        If ls_ErrMsg <> "" Then
  '          Call MsgBox("SAP Info Message: " & ls_ErrMsg & " Product code: " & ls_PRD_Code)
  '        End If
        Else
          le_SAP_Sta = eDPCInterfaceStatus.isFailed
        End If
      
        ls_req = "UPDATE DPC_PrdCommon SET PRD_StaSAP=$PRD_StaSAP$,PRD_InfoSAP=$PRD_InfoSAP$ WHERE PRD_Id=$PRD_Id$"
        ls_req = Replace(ls_req, "$PRD_StaSAP$", mo_Tools.SqlInt(le_SAP_Sta), , , vbTextCompare)
        ls_req = Replace(ls_req, "$PRD_InfoSAP$", mo_Tools.SQLStr(as_ErrorMsg, 250), , , vbTextCompare)
        ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SQLStr(ls_PRD_Id), , , vbTextCompare)
        Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
        
        If le_SAP_Sta = eDPCInterfaceStatus.isFailed Then
          as_ErrorMsg = as_ErrorMsg + " Code: " & ls_PRD_Code
          Call mo_Db.Close(lc_Cursor)
          Exit Function
        End If
      Else
        as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9896, "#Product vendor or shipment point view blocked to export SAP: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
        'as_ErrorMsg = as_ErrorMsg & "#Product vendor or shipment point view blocked to export SAP: " & ls_PRD_Code & vbCrLf
      End If
    End If
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)
  SAP_OfferMaterialCreate = True
  Exit Function
ErrHandler:
  Call ErrHandler("SAP_OfferMaterialCreate")
End Function

Private Function SAP_MaterialCreate(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_Xml As String
Dim ls_Response As String

        SAP_MaterialCreate = False
        
        as_ErrorMsg = ""
        
        ls_Xml = SAP_MaterialCreateGetXML(as_COF_Id, as_OFD_Id, as_ErrorMsg)
        
        If Len(as_ErrorMsg) = 0 Then
            If (SendRequest(DPC_SAP_MATERIAL_CREATE, "POST", ls_Xml, ls_Response) = True) Then
                
                'ls_Response = "<?xml version=""1.0"" encoding=""UTF-8""?><AMC_BASIC_SAP_BAPI_RESPONSE><SUCC_FAIL_IND>F</SUCC_FAIL_IND><ERRORS><ERROR_GROUP>" & _
                '    "<SEVERITY_TYPE>E</SEVERITY_TYPE><MSG_CLASS>SAP_WRAPPER_FM</MSG_CLASS><MSG_NO>999</MSG_NO><MSG_TEXT>Material already exists and changes are not permitted</MSG_TEXT>" & _
                '    "<MSG_PARM_ROW>0</MSG_PARM_ROW></ERROR_GROUP></ERRORS></AMC_BASIC_SAP_BAPI_RESPONSE>"
                
                If (SAP_ProcessBasicResponse(ls_Response, as_ErrorMsg) = True) Then
                    SAP_MaterialCreate = True
                End If
                
                Call LogInterface(mo_Db, ml_U_Code)
            Else
                as_ErrorMsg = ls_Response
            End If
        Else
            mo_ILO.ILO_Error = as_ErrorMsg
            mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
            Call LogInterface(mo_Db, ml_U_Code)
        End If
        
  Exit Function
ErrHandler:
  
  mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
  Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("SAP_MaterialCreate")
End Function

Private Function SAP_MaterialCreateGetXML(ByVal as_COF_Id As String, ByVal as_OFD_Id As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim lo_XmlDocCust As Object
Dim lo_SubNode As Object
Dim lo_parentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorMaster As Long
Dim lc_Header As Long
Dim lc_CursorXML As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Nominator As Long, ll_Denominator As Long
Dim ll_Index As Integer
Dim ls_UOM As String, ll_OFD_PU As Long
Dim ls_OFD_CurrCode, ls_RequiredCurrCode As String
Dim ld_ExRate, ld_Cost As Double

  Call ClearLogInterface
  mo_ILO.ILO_Interface = eDPCXmlExportType.etSAP_MaterialCreate
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = SAP_GetXmlCursor(eDPCXmlExportType.etSAP_MaterialCreate)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_MATERIAL_ICTP_CREATE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPMaterialCreateHeader_sel $COF_Id$,$OFD_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  Call SAP_CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "MATERIAL_NO"), lo_XMLDoc, lo_MainNode)
  
  mo_ILO.ILO_MasterId = GetATRValue(lc_CursorXML, lc_Header, "MATERIAL_NO")
  
  ls_UOM = GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM")
  If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
    Call SAP_CreateXMLNode("BASE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM_PCS"), lo_XMLDoc, lo_MainNode)
  Else
    Call SAP_CreateXMLNode("BASE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM"), lo_XMLDoc, lo_MainNode)
  End If
  Call SAP_CreateXMLNode("NET_WEIGHT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "NET_WEIGHT"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("WEIGHT_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "WEIGHT_UOM"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("SALES_ORG_CUST_ORD", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG_CUST_ORD"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("DIST_CHAN_CUST_ORD", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DIST_CHAN_CUST_ORD"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("SALES_ORG_MANUF_LOC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG_MANUF_LOC"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("DIST_CHAN_MANUF_LOC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DIST_CHAN_MANUF_LOC"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("DEL_PLANT_CUST_ORD", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DEL_PLANT_CUST_ORD"), lo_XMLDoc, lo_MainNode)
  If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
    Call SAP_CreateXMLNode("TRIANG_SO_ICTP_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_AMT_PCS"), lo_XMLDoc, lo_MainNode)
  Else
    Call SAP_CreateXMLNode("TRIANG_SO_ICTP_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_AMT"), lo_XMLDoc, lo_MainNode)
  End If
  Call SAP_CreateXMLNode("TRIANG_SO_ICTP_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_CURR"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("TRIANG_SO_ICTP_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_UNIT"), lo_XMLDoc, lo_MainNode)
  If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
    Call SAP_CreateXMLNode("TRIANG_SO_ICTP_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_UOM_PCS"), lo_XMLDoc, lo_MainNode)
  Else
    Call SAP_CreateXMLNode("TRIANG_SO_ICTP_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TRIANG_SO_ICTP_UOM"), lo_XMLDoc, lo_MainNode)
  End If
    
  'MAT DESCRIPTION
  ls_Request = "exec DPC_SAPMaterialCreateMatDesc_lst $COF_Id$,$OFD_Id$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_CursorMaster) > 0 Then
      Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "MATL_DESCRIPTIONS", "")
      
      Call mo_Db.First(lc_CursorMaster)
      
      While Not mo_Db.EOF(lc_CursorMaster)
                          
          ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "MATL_DESC")
          ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                          
          la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
          For ll_Index = 0 To UBound(la_StrValues)
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "MATL_DESC_GROUP", "")
    
            Call SAP_CreateXMLNode("MATL_DESC", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
            Call SAP_CreateXMLNode("MD_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MD_LANGU"), lo_XMLDoc, lo_SubNode)
          Next
    
          mo_Db.Next (lc_CursorMaster)
      Wend
  End If
  
  mo_Db.Close (lc_CursorMaster)
        
  
  ll_OFD_PU = mo_Db.GetFields(lc_Header, "OFD_PU")

  If (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Or (StrComp(ls_UOM, DPC_UOM_PCS, vbTextCompare) = 0) Then
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "ALT_UOMS", "")
    Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "ALT_UOM_GROUP", "")
        ll_Nominator = 1000
        ll_Denominator = Round(mo_Db.GetFields(lc_Header, "ModuleSurface") * 1000, 0)
        
        Call SAP_CreateXMLNode("ALT_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM_M2"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("NUMERATOR", lc_CursorXML, ll_Nominator, lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("DENOMINATOR", lc_CursorXML, ll_Denominator, lo_XMLDoc, lo_SubNode)
  ElseIf (StrComp(ls_UOM, DPC_UOM_PU, vbTextCompare) = 0) And (ll_OFD_PU > 0) Then
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "ALT_UOMS", "")
    Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "ALT_UOM_GROUP", "")
    ll_Nominator = ll_OFD_PU
    ll_Denominator = 1
    Call SAP_CreateXMLNode("ALT_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "BASE_UOM_PCS"), lo_XMLDoc, lo_SubNode)
    Call SAP_CreateXMLNode("NUMERATOR", lc_CursorXML, ll_Nominator, lo_XMLDoc, lo_SubNode)
    Call SAP_CreateXMLNode("DENOMINATOR", lc_CursorXML, ll_Denominator, lo_XMLDoc, lo_SubNode)
  End If
  
  'MAT ATTRIBUTES
  ls_Request = "exec DPC_SAPMaterialCreateMatAttr_lst $COF_Id$,$OFD_Id$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SQLStr(as_OFD_Id), , , vbTextCompare)
  lc_CursorMaster = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_CursorMaster) > 0 Then
      Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "MATL_ATTRIBUTES", "")
      
      Call mo_Db.First(lc_CursorMaster)
      
      While Not mo_Db.EOF(lc_CursorMaster)
                    
          ls_ATR_Value = GetATRValue(lc_CursorXML, lc_CursorMaster, "MATL_ATTRIBUTE")
          ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                    
          la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
          
          For ll_Index = 0 To UBound(la_StrValues)
      
              Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "MATL_ATTR_GROUP", "")
          
              Call SAP_CreateXMLNode("MATL_ATTRIBUTE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
              Call SAP_CreateXMLNode("MA_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_CursorMaster, "MA_LANGU"), lo_XMLDoc, lo_SubNode)
          Next
    
          mo_Db.Next (lc_CursorMaster)
      Wend
  End If
  
  mo_Db.Close (lc_CursorMaster)
  
  
  'PLANTS
  Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "PLANTS", "")
  
  For ll_Index = 1 To 4
    If mo_Db.GetFields(lc_Header, "PLANT_CODE_" & ll_Index) <> "" Or mo_Db.GetFields(lc_Header, "ORIGIN_IND_" & ll_Index) <> "" Or mo_Db.GetFields(lc_Header, "SP_PROC_TYPE_" & ll_Index) <> "" Then
           
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "PLANT_GROUP", "")
        
        Call SAP_CreateXMLNode("PLANT_CODE", lc_CursorXML, mo_Db.GetFields(lc_Header, "PLANT_CODE_" & ll_Index), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("ORIGIN_IND", lc_CursorXML, mo_Db.GetFields(lc_Header, "ORIGIN_IND_" & ll_Index), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("SP_PROC_TYPE", lc_CursorXML, mo_Db.GetFields(lc_Header, "SP_PROC_TYPE_" & ll_Index), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("COMM_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "COMM_CODE"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("COUNTRY_ORI", lc_CursorXML, mo_Db.GetFields(lc_Header, "VEN_CountryOrigin"), lo_XMLDoc, lo_SubNode)
                
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          ld_Cost = GetATRValue(lc_CursorXML, lc_Header, "STD_COST_PCS")
        Else
          ld_Cost = GetATRValue(lc_CursorXML, lc_Header, "STD_COST")
        End If
        
        ls_OFD_CurrCode = mo_Db.GetFields(lc_Header, "CURR_CODE")
        ls_RequiredCurrCode = mo_Db.GetFields(lc_Header, "CURR_CODE_" & ll_Index)
        
        If ls_OFD_CurrCode <> ls_RequiredCurrCode Then
            ld_ExRate = mo_Tools.SelectExchangeRate(mo_Db, ls_OFD_CurrCode, ls_RequiredCurrCode, mo_Db.GetFields(lc_Header, "COF_DocDat"))
            ld_Cost = ld_Cost * ld_ExRate
        End If
                
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          Call SAP_CreateXMLNode("STD_COST_PCS", lc_CursorXML, ld_Cost, lo_XMLDoc, lo_SubNode)
        Else
          Call SAP_CreateXMLNode("STD_COST", lc_CursorXML, ld_Cost, lo_XMLDoc, lo_SubNode)
        End If
                
        Call SAP_CreateXMLNode("COST_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "COST_UNIT"), lo_XMLDoc, lo_SubNode)
        
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          Call SAP_CreateXMLNode("STK_TRANS_ICTP_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_AMT_PCS"), lo_XMLDoc, lo_SubNode)
        Else
          Call SAP_CreateXMLNode("STK_TRANS_ICTP_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_AMT"), lo_XMLDoc, lo_SubNode)
        End If
        Call SAP_CreateXMLNode("STK_TRANS_ICTP_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_CURR"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("STK_TRANS_ICTP_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_UNIT"), lo_XMLDoc, lo_SubNode)
        If StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0 Then
          Call SAP_CreateXMLNode("STK_TRANS_ICTP_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_UOM_PCS"), lo_XMLDoc, lo_SubNode)
        Else
          Call SAP_CreateXMLNode("STK_TRANS_ICTP_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "STK_TRANS_ICTP_UOM"), lo_XMLDoc, lo_SubNode)
        End If
    End If
  Next
  Call mo_Db.Close(lc_Header)
  Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing
  
  SAP_MaterialCreateGetXML = SAP_SaveXMLDocument(lo_XMLDoc, "AMC_MaterialCreate", "SAPAMCMaterialCreate", as_ErrorMsg, InStr(1, mo_Tools.GetAConfigData("DPC_DEBUG_XML"), ms_PC_Name, vbTextCompare) >= 1)
  
  Exit Function
ErrHandler:
  
  If lc_CursorMaster <> 0 Then
    mo_Db.Close (lc_CursorMaster)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing

  'Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("SAP_MaterialCreateGetXML")
End Function

Public Function SAP_SalesOrderCreate(ByVal as_COF_Id As String, ByVal ab_Simulate As Boolean, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim ls_Xml As String
Dim ls_Response As String
Dim ls_req As String
Dim lc_Offer As Long
Dim lc_OfferDetail As Long
Dim ls_COF_Code As String
Dim ll_LockRowId As Long
Dim ls_ActionCode As String
Dim ls_Status As String
Dim lb_UsePlanningBox As Boolean

  SAP_SalesOrderCreate = False
  ls_ActionCode = IIf(ab_Simulate, "T", "C")
  as_ErrorMsg = ""
  
  lc_Offer = GetOfferCursor(as_COF_Id)
  
  If Not SAP_SalesOrderCheckOfferHeader(lc_Offer, False, as_ErrorMsg) Then
    Call mo_Db.Close(lc_Offer)
    Exit Function
  End If
  
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  Call mo_Db.Close(lc_Offer)
  
  ls_req = "exec DPC_SAPOfferDetailCheck_lst $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_OfferDetail = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  lb_UsePlanningBox = False
  If Not SAP_SalesOrderCheckOfferDetail(lc_OfferDetail, False, lb_UsePlanningBox, as_ErrorMsg) Then
    Call mo_Db.Close(lc_OfferDetail)
    Exit Function
  End If
  Call mo_Db.Close(lc_OfferDetail)
  
  If lb_UsePlanningBox Then
    If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
      Exit Function
    End If
    ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
    If ll_LockRowId = 0 Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress")
      Exit Function
    End If
  
    ls_Status = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
    If StrComp(ls_Status, BAE_PLABOX_RequestDeadlineTimeout, vbTextCompare) = 0 Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9893, "#Planning Box reservation is expired") & vbCrLf
      'as_ErrorMsg = "#Planning Box reservation is expired"
      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
      Exit Function
    ElseIf StrComp(ls_Status, BAE_PLABOX_RequestReadyForCapture, vbTextCompare) <> 0 Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9860, "#Planning box is not ready for Capture, current status: $STATUS$", Array("$STATUS$", ls_Status)) & vbCrLf
      Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
      Exit Function
    End If
  End If
  
  ls_Xml = SAP_SalesOrderCreateGetXML(as_COF_Id, ls_ActionCode, as_ErrorMsg)
  
  If Len(as_ErrorMsg) = 0 Then

        If (SendRequest(DPC_SAP_SALESORDER_CREATE, "POST", ls_Xml, ls_Response) = True) Then
            
            If (SAP_SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg, ab_Simulate) = True) Then
              If Not ab_Simulate Then
                If lb_UsePlanningBox Then
                  Call Bae_UpdatePlaningBoxOfferStatus(ls_COF_Code, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture, as_ErrorMsg)
                End If
                Call UpdateOfferStatus(as_COF_Id, eOfferStatus.osSAPSalesOrder)
              End If
              SAP_SalesOrderCreate = True
            Else
                mo_ILO.ILO_Error = as_ErrorMsg
                mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
            End If
            
            If Not ab_Simulate Then
              Call LogInterface(mo_Db, ml_U_Code)
            End If
        Else
            as_ErrorMsg = ls_Response
        End If
  Else
    mo_ILO.ILO_Error = as_ErrorMsg
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
    Call LogInterface(mo_Db, ml_U_Code)
  End If
  If lb_UsePlanningBox Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  End If
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If lb_UsePlanningBox And (ll_LockRowId <> 0) Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
  Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("SAP_SalesOrderCreate")
End Function

Private Function SAP_SalesOrderCreateGetXML(ByVal as_COF_Id As String, ByVal as_ActionCode As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode As Object
Dim lo_SubSubNode As Object
Dim lo_SubSubSubNode As Object
Dim lo_parentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lc_Header As Long
Dim lc_Lines As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Index As Integer
Dim ld_DelDate As Date
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory

  Call ClearLogInterface
  mo_ILO.ILO_Interface = eDPCXmlExportType.etSAP_SalesOrderCreate
  mo_ILO.ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = SAP_GetXmlCursor(eDPCXmlExportType.etSAP_SalesOrderCreate)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SALES_ORD_CREATE_SIMU", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPSalesOrderCreateHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  ls_Request = "exec DPC_SAPSalesOrderCreateLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_Lines = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  ld_DelDate = mo_Db.GetFields(lc_Lines, "OFD_DelDat")
  Do While Not mo_Db.EOF(lc_Lines)
    If ld_DelDate < mo_Db.GetFields(lc_Lines, "OFD_DelDat") Then
      ld_DelDate = mo_Db.GetFields(lc_Lines, "OFD_DelDat")
    End If
    Call mo_Db.Next(lc_Lines)
  Loop
  
  
  Call mo_Db.First(lc_Header)
        
  Call SAP_CreateXMLNode("ACTION_CODE", lc_CursorXML, as_ActionCode, lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("SALES_ORG", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("DISTR_CHAN", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DISTR_CHAN"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("SOLDTO_CUST_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SOLDTO_CUST_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CONTACT_NAME", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CONTACT_NAME"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  Call SAP_CreateXMLNode("CUST_PO_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CUST_PO_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_DATE"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("PROJ_ID_KEY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_KEY"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("AMC_PROJ_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "AMC_PROJ_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("PROJ_ID_DESC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_DESC"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "SP_CodePage"))
  Call SAP_CreateXMLNode("EPC_OFFER_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("EPC_OFFER_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_VERS_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("EPC_ORD_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_VERS_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("HDR_REQ_DEL_DATE", lc_CursorXML, ld_DelDate, lo_XMLDoc, lo_MainNode)
  
  'DELIV ADDRESS
  ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME")
  ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
  If Len(ls_ATR_Value) > 0 Then
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "DELIV_ADDRESS", "")
                
    la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
      
    If UBound(la_StrValues) = 0 Then
        Call SAP_CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        Call SAP_CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        
        If UBound(la_StrValues) = 1 Then
            Call SAP_CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        End If
    Else
        Call SAP_CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        Call SAP_CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        Call SAP_CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        
        If UBound(la_StrValues) = 1 Then
          Call SAP_CreateXMLNode("DA_NAME4", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        End If
    End If
    
              
    Call SAP_CreateXMLNode("DA_STREET", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_STREET"), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    Call SAP_CreateXMLNode("DA_CITY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_CITY"), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    Call SAP_CreateXMLNode("DA_REGION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_REGION"), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    Call SAP_CreateXMLNode("DA_POSTL_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_POSTL_CODE"), lo_XMLDoc, lo_parentNode)
    Call SAP_CreateXMLNode("DA_COUNTRY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_COUNTRY"), lo_XMLDoc, lo_parentNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
  
  End If
  
  'HDR_TEXTS
  If Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")) > 0 Or Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")) > 0 Then
                  
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "HDR_TEXTS", "")
                  
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")
    ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If Len(ls_ATR_Value) > 0 Then
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "HDR_TEXT_GROUP", "")
                
        Call SAP_CreateXMLNode("TEXT_ID1", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID1"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode)
             
        Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        For ll_Index = 0 To UBound(la_StrValues)
            Call SAP_CreateXMLNode("TEXT_LINE1", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        Next
        
        'Call SAP_CreateXMLNode("TEXT_LINE1", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
    
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")
    ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If Len(ls_ATR_Value) > 0 Then
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "HDR_TEXT_GROUP", "")
                
        Call SAP_CreateXMLNode("TEXT_ID2", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID2"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode)
             
        Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        For ll_Index = 0 To UBound(la_StrValues)
            Call SAP_CreateXMLNode("TEXT_LINE2", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        Next
        
        'Call SAP_CreateXMLNode("TEXT_LINE2", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
  End If
      
  'LINES
  If mo_Db.RowCount(lc_Lines) > 0 Then
      
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
    Call mo_Db.First(lc_Lines)
    
    While Not mo_Db.EOF(lc_Lines)
      
      ls_UOM = GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM")
      le_CAT_Id = mo_Db.GetFields(lc_Lines, "CAT_Id")
      
      Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "LINE_GROUP", "")
      Call SAP_CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "CUST_POSITION"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call SAP_CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call SAP_CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode)
      End If
      
      Call SAP_CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call SAP_CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call SAP_CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode)
      End If
      Call SAP_CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode)

      
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LINE")
      ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")

      If Len(ls_ATR_Value) > 0 Then
        Set lo_SubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXTS", "")
            
        Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXT_GROUP", "")
            
        Call SAP_CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_ID"), lo_XMLDoc, lo_SubSubNode)
        Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, "", lo_XMLDoc, lo_SubSubNode) 'GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LANGU")
            
        Set lo_SubSubSubNode = AppendElement(lo_XMLDoc, lo_SubSubNode, "TEXT_LINES", "")
                                
        la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
        
        For ll_Index = 0 To UBound(la_StrValues)
            Call SAP_CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubSubNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        Next
      End If

      mo_Db.Next (lc_Lines)
    Wend
  End If
  
  Call mo_Db.Close(lc_Lines)
  Call mo_Db.Close(lc_Header)
 
  Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing
  
  SAP_SalesOrderCreateGetXML = SAP_SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate", as_ErrorMsg, InStr(1, mo_Tools.GetAConfigData("DPC_DEBUG_XML"), ms_PC_Name, vbTextCompare) >= 1)
  Exit Function
ErrHandler:
  
  If lc_Lines <> 0 Then
    mo_Db.Close (lc_Lines)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing

  'Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("SAP_SalesOrderCreateGetXML")
End Function

Private Function Bae_SalesOrderCheckOfferHeader(ByVal ac_Offer As Long, ByVal ab_SalesOrderChange As Boolean, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

  Bae_SalesOrderCheckOfferHeader = False
  If Trim(mo_Db.GetFields(ac_Offer, "COF_Bae_Konto")) = "" Then
    as_ErrorMsg = "No customer B7 konto selected"
    Exit Function
  End If
  
  If Trim(mo_Db.GetFields(ac_Offer, "COF_CodeCus")) <> "" Then
    If Bae_CheckExistCustPurchOrderNumber(mo_Db.GetFields(ac_Offer, "COF_CodeCus"), Val(mo_Db.GetFields(ac_Offer, "COF_Bae_Konto"))) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9897, "#Current customer purchase order number already exists in B7") & vbCrLf
      Exit Function
    End If
  End If
  
  If ab_SalesOrderChange Then
    If (mo_Db.GetFields(ac_Offer, "COF_Stat") <> eOfferStatus.osBaeurerSalesOrderChange) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$' only", Array("$STATUS$", "#B7 change SO")) & vbCrLf
      Exit Function
    End If
  Else
    If (mo_Db.GetFields(ac_Offer, "COF_Stat") <> eOfferStatus.osWaitCustConfirmation) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9871, "#You can execute this operation in offer status '$STATUS$' only", Array("$STATUS$", "Waiting customer confirmation")) & vbCrLf
      Exit Function
    End If
  End If
  
  Bae_SalesOrderCheckOfferHeader = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_SalesOrderCheckOfferHeader")
End Function

Private Function Bae_SalesOrderCheckOfferDetail(ByVal as_COF_Code As String, ByVal ac_OfferDetail As Long, ByVal ab_SalesOrderChange As Boolean, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim le_OFD_Main As eDPCOfferDetailMain
Dim le_DOF_Id As eDPCOfferDetail
Dim le_CAT_Id As eDPCCategory
Dim ls_PRD_Code As String
  
  Bae_SalesOrderCheckOfferDetail = False
  
  Call mo_Db.First(ac_OfferDetail)
  While Not mo_Db.EOF(ac_OfferDetail)
  
    le_OFD_Main = mo_Db.GetFields(ac_OfferDetail, "OFD_Main")
    le_DOF_Id = mo_Db.GetFields(ac_OfferDetail, "DOF_Id")
    le_CAT_Id = mo_Db.GetFields(ac_OfferDetail, "CAT_Id")
    ls_PRD_Code = mo_Db.GetFields(ac_OfferDetail, "PRD_Code")
    
    If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
       (le_DOF_Id = eDPCOfferDetail.odPosition) Then
      If mo_Db.GetFields(ac_OfferDetail, "PRD_StaBae") <> eDPCInterfaceStatus.isOK Then
        as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9879, "#Not all custom materials inside sales order were successfuly exported to B7: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
        'as_ErrorMsg = as_ErrorMsg & "Not all custom materials inside sales order were successfuly exported to B7: " & ls_PRD_Code & vbCrLf
        Exit Function
      End If
    End If
    
    If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And _
       (le_DOF_Id = eDPCOfferDetail.odPosition) Then
      If Not ab_SalesOrderChange Then
        If StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) = 0 Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9898, "#Some position already exported in Sales order to B7: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          'as_ErrorMsg = as_ErrorMsg & "Some position already exported in Sales order to B7: " & ls_PRD_Code & vbCrLf
          Exit Function
        End If
      End If
      If ab_SalesOrderChange Then
        If (StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestReadyForCapture, vbTextCompare) <> 0) And _
           (StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) <> 0) Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9886, "#Not all standard and custom metal materials inside sales order were successfuly send and received from B7 planning box: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          'as_ErrorMsg = as_ErrorMsg & "Not all standard and custom metal materials inside sales order were successfuly send and received from B7 planning box: " & ls_PRD_Code & vbCrLf
          Exit Function
        End If
      Else
        If StrComp(mo_Db.GetFields(ac_OfferDetail, "OFD_B7Sta"), BAE_PLABOX_RequestReadyForCapture, vbTextCompare) <> 0 Then
          as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9886, "#Not all standard and custom metal materials inside sales order were successfuly send and received from B7 planning box: $PRD_Code$", Array("$PRD_Code$", ls_PRD_Code)) & vbCrLf
          'as_ErrorMsg = as_ErrorMsg & "Not all standard and custom metal materials inside sales order were successfuly send and received from B7 planning box: " & ls_PRD_Code & vbCrLf
          Exit Function
        End If
      End If
    End If
    Call mo_Db.Next(ac_OfferDetail)
  Wend
  Bae_SalesOrderCheckOfferDetail = True
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_SalesOrderCheckOfferDetail")
End Function

Public Function Bae_SalesOrderExport(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lb_Result As Boolean
Dim ll_LockRowId As Long
Dim ls_COF_Code As String
Dim ls_Status As String
Dim lc_Offer As Long
Dim lc_OfferDetail As Long

  Bae_SalesOrderExport = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed") & vbCrLf
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  If Not Bae_SalesOrderCheckOfferHeader(lc_Offer, False, as_ErrorMsg) Then
  'If Bae_CheckExistCustPurchOrderNumber(mo_Db.GetFields(lc_Offer, "COF_CodeCus"), Val(mo_Db.GetFields(lc_Offer, "LEN_BaeKonto"))) Then
  '  as_ErrorMsg = "Current customer purchase order number already exists in B7"
    Call mo_Db.Close(lc_Offer)
    Exit Function
  End If
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  Call mo_Db.Close(lc_Offer)
  
  ls_req = "exec DPC_BaeOfferDetailCheck_lst $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_OfferDetail = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  If Not Bae_SalesOrderCheckOfferDetail(ls_COF_Code, lc_OfferDetail, False, as_ErrorMsg) Then
    Call mo_Db.Close(lc_OfferDetail)
    Exit Function
  End If
  Call mo_Db.Close(lc_OfferDetail)
  
  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress") & vbCrLf
    Exit Function
  End If
  
  ls_Status = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  If StrComp(ls_Status, BAE_PLABOX_RequestReadyForCapture, vbTextCompare) <> 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9860, "#Planning box is not ready for Capture, current status: $STATUS$", Array("$STATUS$", ls_Status))
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Exit Function
  End If
  
  lb_Result = Bae_SalesOrderCreate(as_COF_Id, "A", as_ErrorMsg)
  If lb_Result Then
    Call Bae_UpdatePlaningBoxOfferStatus(ls_COF_Code, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture, as_ErrorMsg)
    Call Bae_UpdateOfferDetailStatus(as_COF_Id, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture, as_ErrorMsg)
    Call UpdateOfferStatus(as_COF_Id, eOfferStatus.osBaeurerSalesOrder)
  End If
  
  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Bae_SalesOrderExport = lb_Result
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrHandler("Bae_SalesOrderExport")
End Function

Private Function PlanningBoxStatusIsSubset(ByVal as_PlanningBoxStatus As String, ByVal av_SetStatus As Variant) As Boolean
On Error GoTo ErrHandler

Dim ls_PlanningStatus() As String
Dim ll_PlanningIdx As Long, ll_Idx As Long
Dim lb_Found As Boolean

  PlanningBoxStatusIsSubset = False
  ls_PlanningStatus = Split(as_PlanningBoxStatus, ",")
  
  If IsArray(av_SetStatus) Then
    For ll_PlanningIdx = 0 To UBound(ls_PlanningStatus)
      lb_Found = False
      For ll_Idx = 0 To UBound(av_SetStatus)
        If StrComp(ls_PlanningStatus(ll_PlanningIdx), av_SetStatus(ll_Idx), vbTextCompare) = 0 Then
          lb_Found = True
          Exit For
        End If
      Next
      If Not lb_Found Then
        Exit Function
      End If
    Next
    PlanningBoxStatusIsSubset = True
  End If
  Exit Function
ErrHandler:
  Call ErrHandler("PlanningBoxStatusContain")
End Function


Public Function Bae_SalesOrderChangeExport(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim ls_req As String
Dim lb_Result As Boolean
Dim ll_LockRowId As Long
Dim ls_COF_Code As String
Dim ls_Status As String
Dim lc_Offer As Long
Dim lc_OfferDetail As Long

  Bae_SalesOrderChangeExport = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed") & vbCrLf
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Offer = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  If Not Bae_SalesOrderCheckOfferHeader(lc_Offer, True, as_ErrorMsg) Then
  'If Bae_CheckExistCustPurchOrderNumber(mo_Db.GetFields(lc_Offer, "COF_CodeCus"), Val(mo_Db.GetFields(lc_Offer, "LEN_BaeKonto"))) Then
  '  as_ErrorMsg = "Current customer purchase order number already exists in B7"
    Call mo_Db.Close(lc_Offer)
    Exit Function
  End If
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  Call mo_Db.Close(lc_Offer)
  
  ls_req = "exec DPC_BaeOfferDetailCheck_lst $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_OfferDetail = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  If Not Bae_SalesOrderCheckOfferDetail(ls_COF_Code, lc_OfferDetail, True, as_ErrorMsg) Then
    Call mo_Db.Close(lc_OfferDetail)
    Exit Function
  End If
  Call mo_Db.Close(lc_OfferDetail)
  
  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress") & vbCrLf
    Exit Function
  End If
  
  ls_Status = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  If Not PlanningBoxStatusIsSubset(ls_Status, Array(BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture)) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9860, "#Planning box is not ready for Capture, current status: $STATUS$", Array("$STATUS$", ls_Status))
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Exit Function
  End If
  
  lb_Result = Bae_SalesOrderCreate(as_COF_Id, "A", as_ErrorMsg)
  If lb_Result Then
    Call Bae_UpdatePlaningBoxOfferStatus(ls_COF_Code, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture, as_ErrorMsg)
    Call Bae_UpdateOfferDetailStatus(as_COF_Id, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture, as_ErrorMsg)
    Call ResetActionCode(as_COF_Id)
    Call UpdateOfferStatus(as_COF_Id, eOfferStatus.osBaeurerSalesOrder)
  End If
  
  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Bae_SalesOrderChangeExport = lb_Result
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If ll_LockRowId <> 0 Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  Call ErrHandler("Bae_SalesOrderChangeExport")
End Function

Public Function Bae_SalesOrderKill(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ls_COF_Code As String
Dim ls_Status As String
Dim ll_LockRowId As Long

  Bae_SalesOrderKill = False
  If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed") & vbCrLf
    Exit Function
  End If
  
  ls_req = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  ls_COF_Code = mo_Db.GetFields(lc_Cursor, "COF_Code")
  Call mo_Db.Close(lc_Cursor)
  
  ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
  If ll_LockRowId = 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress") & vbCrLf
    Exit Function
  End If
  
  ls_Status = Bae_GetPlaningBoxStatus(ls_COF_Code, as_ErrorMsg)
  If StrComp(ls_Status, BAE_PLABOX_RequestAcceptedByCapture, vbTextCompare) <> 0 Then
    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9861, "#Planning box status is not accepted by Capture, current status: $STATUS$", Array("$STATUS$", ls_Status))
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Exit Function
  End If
  
  If Bae_SalesOrderCreate(as_COF_Id, "K", as_ErrorMsg) Then
    Call Bae_UpdateOfferCode(as_COF_Id, "")
    Call Bae_ClearOfferDetailCodePos(as_COF_Id)
    Bae_SalesOrderKill = True
  End If
  
  Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  Exit Function
ErrHandler:
  Call ErrHandler("Bae_SalesOrderKill")
End Function

Private Function Bae_SalesOrderCreate(ByVal as_COF_Id As String, ByVal as_ActionCode As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim ls_Xml As String
Dim ls_Response As String
Dim ls_Filename As String
Dim lo_ts As TextStream

  Bae_SalesOrderCreate = False
  
  as_ErrorMsg = ""
    
  ls_Filename = Bae_SalesOrderCreateGetXML(as_COF_Id, as_ActionCode, as_ErrorMsg)
  
  If Len(as_ErrorMsg) = 0 Then
        'save file content as response
        If Len(ls_Filename) > 0 Then
          Set lo_ts = mo_FSO.OpenTextFile(ls_Filename)
          mo_ILO.ILO_XMLSent = lo_ts.ReadAll
          Set lo_ts = Nothing
        End If
                      
        If TransferXMLDocument(ls_Filename, as_ErrorMsg) = True Then
          Bae_SalesOrderCreate = True
          mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
        Else
          mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
          mo_ILO.ILO_Error = as_ErrorMsg
        End If
  Else
    mo_ILO.ILO_Error = as_ErrorMsg
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
  End If
  
  Call LogInterface(mo_Db, ml_U_Code)
  
  'If (SendRequest(DPC_SAP_SALESORDER_CREATE, "POST", ls_Xml, ls_Response) = True) Then
      
      'ls_Response = "<?xml version=""1.0"" encoding=""UTF-8""?><AMC_SALES_ORD_CREATE_CHG_RElSPONSE><SUCC_FAIL_IND>F</SUCC_FAIL_IND><EPC_ORD_NO>00536.A</EPC_ORD_NO>" & _
      '    "<ERRORS><ERROR_GROUP><SEVERITY_TYPE>E</SEVERITY_TYPE><MSG_CLASS>VP</MSG_CLASS><MSG_NO>200</MSG_NO><MSG_TEXT>No customer master record exists for customer 207691</MSG_TEXT>" & _
      '    "<MSG_PARAMETER>SALES_HEADER_IN</MSG_PARAMETER><MSG_PARM_ROW/></ERROR_GROUP></ERRORS></AMC_SALES_ORD_CREATE_CHG_RESPONSE>"
     
      'If (SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg) = True) Then
      '    SalesOrderCreate = True
      'End If
      
      'Call mo_Tools.LogInterface(mo_Db, ml_U_Code, Me)
      
  'Else
      'as_ErrorMsg = ls_Response
  'End If
  Exit Function
ErrHandler:
  
  mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
  Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("Bae_SalesOrderCreate")
End Function

Private Function Bae_SalesOrderCreateGetXML(ByVal as_COF_Id As String, ByVal as_ActionCode As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode As Object
Dim lo_SubSubNode As Object
Dim lo_SubSubSubNode As Object
Dim lo_parentNode As Object
Dim lo_MainNode As Object
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lc_Header As Long
Dim lc_Lines As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ll_ATR_DataLength As Long
Dim la_StrValues() As String
Dim la_StrValues2() As String
Dim ll_Index, ll_Index2 As Integer
Dim ld_DelDate As Date
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory
Dim ll_Count, ll_CountTotal As Long
Dim ls_Filename As String

  Call ClearLogInterface
  mo_ILO.ILO_Interface = eDPCXmlExportType.etBae_SalesOrderCreate
  mo_ILO.ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = Bae_GetXmlCursor(eDPCXmlExportType.etBae_SalesOrderCreate)
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SO_DEMAND_CREATE_CHANGE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_BaeSalesOrderCreateHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  ls_Request = "exec DPC_BaeSalesOrderCreateLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_Lines = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  ld_DelDate = mo_Db.GetFields(lc_Lines, "OFD_DelDat")
  Do While Not mo_Db.EOF(lc_Lines)
    If ld_DelDate <> mo_Db.GetFields(lc_Lines, "OFD_DelDat") Then
      ld_DelDate = 0
      Exit Do
    End If
    Call mo_Db.Next(lc_Lines)
  Loop
  
  
  Call mo_Db.First(lc_Header)
        
  'Call SAP_CreateXMLNode("ACTION_CODE",mo_Db, lc_CursorXML, as_ActionCode, lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("COMP_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "COMP_CODE"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("SALES_ORG", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SALES_ORG"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("DISTR_CHAN", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DISTR_CHAN"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("SOLDTO_CUST_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SOLDTO_CUST_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CLIENT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CLIENT_ID"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CONTACT_NAME", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CONTACT_NAME"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  Call SAP_CreateXMLNode("CUST_PO_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CUST_PO_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CUST_PO_DATE"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("PROJ_ID_KEY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_KEY"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("AMC_PROJ_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "AMC_PROJ_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("PROJ_ID_DESC", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "PROJ_ID_DESC"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "SP_CodePage"))
  Call SAP_CreateXMLNode("EPC_OFFER_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("EPC_OFFER_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_OFFER_VERS_NO"), lo_XMLDoc, lo_MainNode)
  'Call SAP_CreateXMLNode("EPC_ORD_VERS_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_VERS_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("HDR_REQ_DEL_DATE", lc_CursorXML, ld_DelDate, lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("VERP_ART", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "VERP_ART"), lo_XMLDoc, lo_MainNode)
  
  'customer - sales project address
  ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "CA_NAME")
  ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
    
  If UBound(la_StrValues) = 0 Then
      Call SAP_CreateXMLNode("CA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "CA_NAME2")
      ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
              
      la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
      Call SAP_CreateXMLNode("CA_NAME2", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
      
      If UBound(la_StrValues) = 1 Then
          Call SAP_CreateXMLNode("CA_NAME3", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
      End If
  Else
      Call SAP_CreateXMLNode("CA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
      Call SAP_CreateXMLNode("CA_NAME2", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "CA_NAME2")
      ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
              
      la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
      
      Call SAP_CreateXMLNode("CA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
      
      If UBound(la_StrValues) = 1 Then
          Call SAP_CreateXMLNode("CA_NAME4", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
      End If
  End If
  Call SAP_CreateXMLNode("CA_STREET", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_STREET"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  Call SAP_CreateXMLNode("CA_CITY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_CITY"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  'Call SAP_CreateXMLNode("CA_REGION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_REGION"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CA_POSTL_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_POSTL_CODE"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("CA_COUNTRY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "CA_COUNTRY"), lo_XMLDoc, lo_MainNode, mo_Db.GetFields(lc_Header, "CCU_CodePage"))
  
  'DELIV ADDRESS
  ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME")
  ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
  If Len(ls_ATR_Value) > 0 Then
    'Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "DELIV_ADDRESS", "")
                
    la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
      
    If UBound(la_StrValues) = 0 Then
        Call SAP_CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        Call SAP_CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        
        If UBound(la_StrValues) = 1 Then
            Call SAP_CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        End If
    Else
        Call SAP_CreateXMLNode("DA_NAME", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        Call SAP_CreateXMLNode("DA_NAME2", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    
        ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "DA_NAME2")
        ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
                
        la_StrValues = SplitATRValue(ls_ATR_Value, ll_ATR_DataLength)
        
        Call SAP_CreateXMLNode("DA_NAME3", lc_CursorXML, la_StrValues(0), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        
        If UBound(la_StrValues) = 1 Then
            Call SAP_CreateXMLNode("DA_NAME4", lc_CursorXML, la_StrValues(1), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
        End If
    End If
    
              
    Call SAP_CreateXMLNode("DA_STREET", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_STREET"), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    Call SAP_CreateXMLNode("DA_CITY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_CITY"), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
    'Call SAP_CreateXMLNode("DA_REGION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_REGION"), lo_XMLDoc, lo_MainNode)
    Call SAP_CreateXMLNode("DA_POSTL_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_POSTL_CODE"), lo_XMLDoc, lo_MainNode)
    Call SAP_CreateXMLNode("DA_COUNTRY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "DA_COUNTRY"), lo_XMLDoc, lo_MainNode, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
  
  End If
  
  'HDR_TEXTS
  If Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")) > 0 Or Len(GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")) > 0 Then
                  
    'Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "HDR_TEXTS", "")
                  
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE1")
    ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If (Len(ls_ATR_Value) > 0) And (ll_ATR_DataLength > 0) Then
        'Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "HDR_TEXT_GROUP", "")
                
        Call SAP_CreateXMLNode("TEXT_ID1", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID1"), lo_XMLDoc, lo_MainNode)
        'Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_MainNode)
             
        'Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
        la_StrValues2 = Split(ls_ATR_Value, vbCrLf)
        
        ll_CountTotal = 0
                
        For ll_Index2 = 0 To UBound(la_StrValues2)
            la_StrValues = SplitATRValue(la_StrValues2(ll_Index2), ll_ATR_DataLength)
        
        ll_Count = UBound(la_StrValues)
            'If ll_Count > 2 Then ll_Count = 2
        For ll_Index = 0 To ll_Count
                If ll_CountTotal > 2 Then Exit For
                
                Call AppendElement(lo_XMLDoc, lo_MainNode, "TEXT_LINE" & (ll_CountTotal + 1), la_StrValues(ll_Index))
                ll_CountTotal = ll_CountTotal + 1
            'Call SAP_CreateXMLNode("TEXT_LINE1", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode)
        Next
            If ll_CountTotal > 2 Then Exit For
        Next
        'Call SAP_CreateXMLNode("TEXT_LINE1", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
    
    ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Header, "TEXT_LINE2")
    ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
  
    If (Len(ls_ATR_Value) > 0) And (ll_ATR_DataLength > 0) Then
        'Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "HDR_TEXT_GROUP", "")
                
        Call SAP_CreateXMLNode("TEXT_ID2", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_ID2"), lo_XMLDoc, lo_MainNode)
        'Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "TEXT_LANGU"), lo_XMLDoc, lo_MainNode)
             
        'Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINES", "")
                
        la_StrValues2 = Split(ls_ATR_Value, vbCrLf)
        
        ll_CountTotal = 0
        
        For ll_Index2 = 0 To UBound(la_StrValues2)
            la_StrValues = SplitATRValue(la_StrValues2(ll_Index2), ll_ATR_DataLength)
        
        ll_Count = UBound(la_StrValues)
        If ll_Count > 2 Then ll_Count = 2
        For ll_Index = 0 To ll_Count
                If ll_CountTotal > 2 Then Exit For
                
                Call AppendElement(lo_XMLDoc, lo_MainNode, "TEXT_LINE" & (ll_CountTotal + 1), la_StrValues(ll_Index))
                ll_CountTotal = ll_CountTotal + 1
            'Call SAP_CreateXMLNode("TEXT_LINE2", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubNode)
        Next
            If ll_CountTotal > 2 Then Exit For
        Next
        
        'Call SAP_CreateXMLNode("TEXT_LINE2", lc_CursorXML, ls_ATR_Value, lo_XMLDoc, lo_SubSubNode)
    End If
  End If
      
  'LINES
  If mo_Db.RowCount(lc_Lines) > 0 Then
      
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
    Call mo_Db.First(lc_Lines)
    
    While Not mo_Db.EOF(lc_Lines)
      
      ls_UOM = GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM")
      le_CAT_Id = mo_Db.GetFields(lc_Lines, "CAT_Id")
      
      Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "LINE_GROUP", "")
      
      If as_ActionCode = "" Then
        Call SAP_CreateXMLNode("LINE_ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_ACTION_CODE"), lo_XMLDoc, lo_SubNode)
      Else
        Call SAP_CreateXMLNode("LINE_ACTION_CODE", lc_CursorXML, as_ActionCode, lo_XMLDoc, lo_SubNode)
      End If
      
      Call SAP_CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "CUST_POSITION"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call SAP_CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY_PCS") * 1000, lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call SAP_CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY") * 1000, lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM"), lo_XMLDoc, lo_SubNode)
        Call SAP_CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode)
      End If
      
      Call SAP_CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode)
      If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
        Call SAP_CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode)
      Else
        Call SAP_CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode)
      End If
      Call SAP_CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode)
      Call SAP_CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode)

      
      ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LINE")
      ll_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")

      If (Len(ls_ATR_Value) > 0) And (ll_ATR_DataLength > 0) Then
        'Set lo_SubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXTS", "")
            
        'Set lo_SubSubNode = AppendElement(lo_XMLDoc, lo_SubNode, "ITM_TEXT_GROUP", "")
            
        Call SAP_CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_ID"), lo_XMLDoc, lo_SubNode)
        'Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LANGU"), lo_XMLDoc, lo_SubNode)
            
        'Set lo_SubSubSubNode = AppendElement(lo_XMLDoc, lo_SubSubNode, "TEXT_LINES", "")
                                
        la_StrValues2 = Split(ls_ATR_Value, vbCrLf)
        
        ll_CountTotal = 0
        
        For ll_Index2 = 0 To UBound(la_StrValues2)
            la_StrValues = SplitATRValue(la_StrValues2(ll_Index2), ll_ATR_DataLength)
        ll_Count = UBound(la_StrValues)
        If ll_Count > 2 Then ll_Count = 2
        
        For ll_Index = 0 To ll_Count
                If ll_CountTotal > 2 Then Exit For
                Call AppendElement(lo_XMLDoc, lo_SubNode, "TEXT_LINE" & (ll_CountTotal + 1), la_StrValues(ll_Index))
                ll_CountTotal = ll_CountTotal + 1
            'Call SAP_CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubSubSubNode)
        Next
            If ll_CountTotal > 2 Then Exit For
        Next
      End If

      mo_Db.Next (lc_Lines)
    Wend
  End If
  
  ls_Filename = mo_Db.GetFields(lc_Lines, "OFD_OrdNrB7") & "_" & Format(Now, "yyyymmdd_hhmmss")
  'ls_Filename = "999999" & "_" & Format(Now, "yyyymmdd_hhmmss") ' for testing
  
  Call mo_Db.Close(lc_Lines)
  Call mo_Db.Close(lc_Header)
 
  'Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing
  
  
  Bae_SalesOrderCreateGetXML = Bae_SaveXMLDocument(lo_XMLDoc, ls_Filename, as_ErrorMsg)
  
'
'#If LIVE = 0 Then
'  SalesOrderCreateGetXML_v2 = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate", False, True)
'  Exit Function
'#Else
'  SalesOrderCreateGetXML_v2 = SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderCreate", "SAPAMCSalesOrderCreate")
'#End If
  
  Exit Function
ErrHandler:
  
  If lc_Lines <> 0 Then
    mo_Db.Close (lc_Lines)
  End If
  
  If lc_CursorXML <> 0 Then
    mo_Db.Close (lc_CursorXML)
  End If

  Set lo_SubSubNode = Nothing
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing

  'Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("Bae_SalesOrderCreateGetXML")
End Function

#If LIVE = 1 Then
Private Function SAP_SalesOrderCreateProcessResponse(ByVal as_Response As String, ByRef as_ErrorMsg As String, ByVal ab_Simulate As Boolean) As Boolean
#Else
Public Function SAP_SalesOrderCreateProcessResponse(ByVal as_Response As String, ByRef as_ErrorMsg As String, ByVal ab_Simulate As Boolean) As Boolean
#End If

On Error GoTo ErrHandler

Dim lo_XMLDoc As Object
Dim lo_NodeElem As Object
Dim lo_NodeList As Object
Dim lo_NodeId As Object
Dim ls_Value As String
Dim ls_COF_Code As String
Dim ls_SAP_Code As String
Dim ll_Cursor As Long
Dim lb_inTransaction As Boolean
Dim ls_COF_ID As String
Dim ll_iConcurrency As Long
Dim ls_OFD_Pos() As String
Dim ls_OFD_PosSAP() As String
Dim ls_Request As String
Dim ll_Index As Integer
Dim ls_ValidationXSD As String
Dim ls_FormatterXML As String
Dim ls_Error As String

    SAP_SalesOrderCreateProcessResponse = False
    
    Call LoadXMLFiles("SAPAMCSalesOrderChangeResponse", ls_ValidationXSD, ls_FormatterXML)
      
    If ValidateXMLFile(as_Response, "", ls_ValidationXSD, as_ErrorMsg, True) = False Then
        Exit Function
    End If

    Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
    
    lo_XMLDoc.async = False
    Call lo_XMLDoc.loadXML(as_Response)
    
    If (lo_XMLDoc.parseError.errorCode <> 0) Then
    
        as_ErrorMsg = lo_XMLDoc.parseError.reason
        Set lo_XMLDoc = Nothing
        Exit Function
    
        'Err.Raise ArmErr.CompFncFailed, "Parse Error:", lo_XMLDoc.parseError.reason
    End If
    
    Set lo_NodeElem = lo_XMLDoc.selectSingleNode("//SUCC_FAIL_IND")
    ls_Value = lo_NodeElem.nodeTypedValue
    If ls_Value = "S" Then
                   
        If ab_Simulate Then
          SAP_SalesOrderCreateProcessResponse = True
          mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
        Else
              
              ls_COF_Code = lo_XMLDoc.selectSingleNode("//EPC_ORD_NO").nodeTypedValue
              ls_SAP_Code = lo_XMLDoc.selectSingleNode("//SAP_ORD_NO").nodeTypedValue
              
              ls_Request = "exec CAP_Offer_sel2 $COF_Code$,'E'"
              ls_Request = Replace(ls_Request, "$COF_Code$", mo_Tools.SQLStr(ls_COF_Code), , , vbTextCompare)
              ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
            
              If mo_Db.RowCount(ll_Cursor) = 1 Then
            
                    ls_COF_ID = mo_Db.GetFields(ll_Cursor, "COF_Id")
                    ll_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")

                    Call mo_Db.Close(ll_Cursor)
    
                    Set lo_NodeList = lo_XMLDoc.selectNodes("//LINE_GROUP")
                    ' double check, already handled in the xml scheme
                    If lo_NodeList.length > 0 Then
                     
                        ReDim ls_OFD_Pos(lo_NodeList.length - 1)
                        ReDim ls_OFD_PosSAP(lo_NodeList.length - 1)
                        ll_Index = 0
                     
                        For Each lo_NodeElem In lo_NodeList
                            ls_OFD_Pos(ll_Index) = lo_NodeElem.selectSingleNode("EPC_ORD_LINE_POS").nodeTypedValue
                            ls_OFD_PosSAP(ll_Index) = lo_NodeElem.selectSingleNode("SAP_ORD_LINE_POS").nodeTypedValue
                            ll_Index = ll_Index + 1
                        Next
                                 
                        Call mo_Tools.BeginTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_SAPResponse")
                        lb_inTransaction = True
                     
                        ls_Request = "exec CAP_Offer_SAPResponse_upd2 $COF_Id$,$COF_CodeSAP$,$COF_SAPStat$,$iConcurrency$,$Z_Last_Upd_User$"
                        ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(ls_COF_ID), , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$COF_CodeSAP$", mo_Tools.SQLStr(ls_SAP_Code), , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$COF_SAPStat$", 1, , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$iConcurrency$", ll_iConcurrency, , , vbTextCompare)
                        ls_Request = Replace(ls_Request, "$Z_Last_Upd_User$", ml_U_Code, , , vbTextCompare)
                        Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
                     
                        For ll_Index = 0 To lo_NodeList.length - 1
                     
                            ls_Request = "exec CAP_OfferDetail_SAPResponse_upd $COF_Id$,$OFD_Pos$,$OFD_PosSAP$,$Z_Last_Upd_User$"
                            ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(ls_COF_ID), , , vbTextCompare)
                            ls_Request = Replace(ls_Request, "$OFD_Pos$", mo_Tools.SQLStr(ls_OFD_Pos(ll_Index)), , , vbTextCompare)
                            ls_Request = Replace(ls_Request, "$OFD_PosSAP$", mo_Tools.SQLStr(ls_OFD_PosSAP(ll_Index)), , , vbTextCompare)
                            ls_Request = Replace(ls_Request, "$Z_Last_Upd_User$", ml_U_Code, , , vbTextCompare)
                            Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
                     
                        Next
                                 
                        Call mo_Tools.CommitTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_SAPResponse")
                        lb_inTransaction = False
                     
                    End If
                   
                    SAP_SalesOrderCreateProcessResponse = True
        
                    mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
                Else
                    Call mo_Db.Close(ll_Cursor)
                    as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9899, "#Response process cannot find offer for offer code: $COF_Code$", Array("$COF_Code$", ls_COF_Code)) & vbCrLf
                    'as_ErrorMsg = "SAP Response process cannot find offer for offer code: " & ls_COF_Code
                End If
        End If
    Else
        mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
    End If
       
    as_ErrorMsg = as_ErrorMsg & GenerateErrorString(lo_XMLDoc)
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
        
  Exit Function
ErrHandler:
    
    If lb_inTransaction Then
        Call mo_Tools.RollbackTran(mo_Db, ml_U_Code, SCREEN_NAME, "CAP_Offer_SAPResponse")
    End If

    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
    End If
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
    'Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("SAP_SalesOrderCreateProcessResponse")
End Function

Public Function SAP_ProcessBasicResponse(ByVal as_Response As String, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

Dim lo_XMLDoc As Object
Dim lo_NodeElem As Object
Dim lo_NodeList As Object
Dim lo_NodeId As Object
Dim ls_Value As String
Dim ls_ValidationXSD As String
Dim ls_FormatterXML As String
Dim ls_Error As String

    SAP_ProcessBasicResponse = False
    
    Call LoadXMLFiles("SAPAMCBasicResponse", ls_ValidationXSD, ls_FormatterXML)
      
    If ValidateXMLFile(as_Response, "", ls_ValidationXSD, as_ErrorMsg, True) = False Then
        mo_ILO.ILO_Error = as_ErrorMsg
        mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
        Exit Function
    End If

    Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
    
    lo_XMLDoc.async = False
    Call lo_XMLDoc.loadXML(as_Response)
    
    If (lo_XMLDoc.parseError.errorCode <> 0) Then
    
        mo_ILO.ILO_Error = lo_XMLDoc.parseError.reason
        mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
    
        'Err.Raise ArmErr.CompFncFailed, "Parse Error:", lo_XMLDoc.parseError.reason
       
    Else
       Set lo_NodeElem = lo_XMLDoc.selectSingleNode("//SUCC_FAIL_IND")
       ls_Value = lo_NodeElem.nodeTypedValue
       If ls_Value = "F" Then
       
            mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
            SAP_ProcessBasicResponse = False
       
       ElseIf ls_Value = "S" Then
       
            mo_ILO.ILO_Status = eDPCInterfaceStatus.isOK
            SAP_ProcessBasicResponse = True
       End If
              
    End If
    
    ls_Error = GenerateErrorString(lo_XMLDoc)
    
    If Trim(ls_Error) <> "" Then
      as_ErrorMsg = as_ErrorMsg & vbNewLine & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9900, "#SAP message: $SAP$", Array("$SAP$", ls_Error))
    End If
    
    mo_ILO.ILO_Error = as_ErrorMsg
    
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
  Exit Function
ErrHandler:
        
    Set lo_NodeElem = Nothing
    Set lo_NodeList = Nothing
    Set lo_XMLDoc = Nothing
    
  'Call LogInterface(mo_Db, ml_U_Code)
  
  Call ErrHandler("SAP_ProcessBasicResponse")
End Function

Public Function GenerateErrorString(ByVal ao_XMLDoc As Object) As String
On Error GoTo ErrHandler

Dim lo_NodeElem As Object
Dim lo_NodeList As Object
Dim ls_Error As String

    'read error, warrning, info messages
    Set lo_NodeList = ao_XMLDoc.selectNodes("//ERROR_GROUP")
        
    GenerateErrorString = ""
    ls_Error = ""
    
    For Each lo_NodeElem In lo_NodeList
    
         ls_Error = ls_Error & lo_NodeElem.selectSingleNode("MSG_TEXT").nodeTypedValue & vbNewLine
         
         If Not lo_NodeElem.selectSingleNode("MSG_PARM_ROW") Is Nothing Then
            If lo_NodeElem.selectSingleNode("MSG_PARM_ROW").nodeTypedValue <> "" Then
               ls_Error = ls_Error & " (" & lo_NodeElem.selectSingleNode("MSG_PARM_ROW").nodeTypedValue & ")"
            End If
         End If
         
         ls_Error = ls_Error & vbNewLine
    Next

    GenerateErrorString = ls_Error
    
  Exit Function
ErrHandler:
        
  Set lo_NodeElem = Nothing
  Set lo_NodeList = Nothing
  
  Call ErrHandler("GenerateErrorString")
End Function

Public Function SAP_SalesOrderLineCancelAddReplace(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim ls_Xml As String
Dim ls_Response As String
Dim ls_req As String
Dim lc_Offer As Long
Dim lc_OfferDetail As Long
Dim ls_COF_Code As String
Dim ll_LockRowId As Long
Dim lb_UsePlanningBox As Boolean

  SAP_SalesOrderLineCancelAddReplace = False
  
  as_ErrorMsg = ""
  
  lc_Offer = GetOfferCursor(as_COF_Id)
  
  If Not SAP_SalesOrderCheckOfferHeader(lc_Offer, True, as_ErrorMsg) Then
    Call mo_Db.Close(lc_Offer)
    Exit Function
  End If
  
  ls_COF_Code = mo_Db.GetFields(lc_Offer, "COF_Code")
  Call mo_Db.Close(lc_Offer)
  
  ls_req = "exec DPC_SAPOfferDetailCheck_lst $COF_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_OfferDetail = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  
  lb_UsePlanningBox = False
  If Not SAP_SalesOrderCheckOfferDetail(lc_OfferDetail, True, lb_UsePlanningBox, as_ErrorMsg) Then
    Call mo_Db.Close(lc_OfferDetail)
    Exit Function
  End If
  Call mo_Db.Close(lc_OfferDetail)
  
  
  ll_LockRowId = 0
  If lb_UsePlanningBox Then
    If Not mo_Tools.ReconnectSafe(mo_DbBaeurer, ms_BaeurerServer, ms_BaeurerDatabase, ms_BaeurerLoginName, ms_BaeurerPassword, ms_BaeurerSource) Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9857, "#Connection to Baeurer server failed")
      Exit Function
    End If
    
    ll_LockRowId = Bae_LockRecord(mo_DbBaeurer, "va1101", Array(ml_BaeurerFi_Nr, ls_COF_Code), "vva100")
    If ll_LockRowId = 0 Then
      as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9858, "#Manufacturing validation in progress")
      Exit Function
    End If
  End If
  
  ls_Xml = SAP_SalesOrderLineCancelAddReplaceGetXML(as_COF_Id, as_ErrorMsg)
  If Len(as_ErrorMsg) = 0 Then
    If (SendRequest(DPC_SAP_SALESORDER_CHANGE, "POST", ls_Xml, ls_Response) = True) Then
                   
      If (SAP_SalesOrderCreateProcessResponse(ls_Response, as_ErrorMsg, False) = True) Then
        If lb_UsePlanningBox Then
          Call Bae_UpdatePlaningBoxOfferStatus(ls_COF_Code, BAE_PLABOX_RequestReadyForCapture, BAE_PLABOX_RequestAcceptedByCapture, as_ErrorMsg)
        End If
        Call ResetActionCode(as_COF_Id)
        Call UpdateOfferStatus(as_COF_Id, eOfferStatus.osSAPSalesOrder)
        SAP_SalesOrderLineCancelAddReplace = True
      Else
        mo_ILO.ILO_Error = as_ErrorMsg
        mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
      End If
      
      Call LogInterface(mo_Db, ml_U_Code)
    Else
      as_ErrorMsg = ls_Response
    End If
  Else
    mo_ILO.ILO_Error = as_ErrorMsg
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
    Call LogInterface(mo_Db, ml_U_Code)
  End If
  
  If lb_UsePlanningBox Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
  End If
  Exit Function
ErrHandler:
  Call mo_Tools.UpdateError(True)
  If lb_UsePlanningBox And (ll_LockRowId <> 0) Then
    Call Bae_UnlockRecord(mo_DbBaeurer, ll_LockRowId)
    Call mo_DbBaeurer.Disconnect
  End If
  Call mo_Tools.UpdateError(False)
  
  mo_ILO.ILO_Status = eDPCInterfaceStatus.isException
  Call LogInterface(mo_Db, ml_U_Code)

  Call ErrHandler("SAP_SalesOrderLineCancelAddReplace")
End Function

Private Function SAP_SalesOrderLineCancelAddReplaceGetXML(ByVal as_COF_Id As String, ByRef as_ErrorMsg As String) As String
On Error GoTo ErrHandler

Dim lo_XmlDocCust As Object
'Dim ll_Version As Long
Dim lo_SubNode1 As Object, lo_SubNode2 As Object, lo_SubNode3 As Object, lo_SubNode4 As Object, lo_SubNode5 As Object
Dim lo_parentNode As Object, lo_SubNode As Object
Dim lo_MainNode As Object
Dim lc_Lines As Long, lc_Header As Long
Dim lc_CursorXML As Long
Dim lc_CursorGroup As Long
Dim lt_XmlSql As TXmlSql
Dim lt_XmlMaster As TXmlSql
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_Request As String
Dim ls_ATR_Value As String
Dim ls_ATR_DataLength As Long
Dim la_StrValues() As String
Dim ll_Index As Integer
Dim ls_UOM As String
Dim le_CAT_Id As eDPCCategory

On Error GoTo ErrHandler
  
  Call ClearLogInterface
  mo_ILO.ILO_Interface = eDPCXmlExportType.etSAP_SalesOrderLineCancelAddReplace
  mo_ILO.ILO_MasterId = as_COF_Id
  
  Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
  
  lc_CursorXML = SAP_GetXmlCursor(eDPCXmlExportType.etSAP_SalesOrderLineCancelAddReplace)
    
  Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
  lo_XMLDoc.appendChild lo_MainNode
    
  Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "AMC_SALES_ORD_LINE_CANCEL_ADD_REPLACE", "")
  lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
      
  ls_Request = "exec DPC_SAPSalesOrderLineChangeHeader_sel $COF_Id$,$Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$Language_Code$", "'E'", , , vbTextCompare)
  lc_Header = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
  Call mo_Db.First(lc_Header)
        
  Call SAP_CreateXMLNode("SAP_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "SAP_ORD_NO"), lo_XMLDoc, lo_MainNode)
  Call SAP_CreateXMLNode("EPC_ORD_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Header, "EPC_ORD_NO"), lo_XMLDoc, lo_MainNode)
                
  'LINES
  ls_Request = "exec DPC_SAPSalesOrderLineChangeLines_lst $COF_Id$,'E'"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  lc_Lines = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
    
  If mo_Db.RowCount(lc_Lines) > 0 Then
      
      Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "LINES", "")
      
      Call mo_Db.First(lc_Lines)
      
      While Not mo_Db.EOF(lc_Lines)
                
          ls_UOM = GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM")
          le_CAT_Id = mo_Db.GetFields(lc_Lines, "CAT_Id")
          
          If (mo_Db.GetFields(lc_Lines, "OFD_SAPAct") = "D") Or (mo_Db.GetFields(lc_Lines, "OFD_SAPAct") = "K") Then
              'DELETE GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "LINE_GROUP", "")
                  
            Call SAP_CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
            Call SAP_CreateXMLNode("SAP_CANC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SAP_CANC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
          
          ElseIf mo_Db.GetFields(lc_Lines, "OFD_SAPAct") = "A" Then
            'ADD GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "LINE_GROUP", "")
                    
            Call SAP_CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
                
            Set lo_SubNode2 = AppendElement(lo_XMLDoc, lo_SubNode, "LINE_DETAIL_GROUP", "")
                
            Call SAP_CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "CUST_POSITION"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call SAP_CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode2)
              Call SAP_CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call SAP_CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY"), lo_XMLDoc, lo_SubNode2)
              Call SAP_CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call SAP_CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call SAP_CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode2)
            End If
            Call SAP_CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call SAP_CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call SAP_CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            Call SAP_CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode2)
          
            ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LINE")
            ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
            
            If Len(ls_ATR_Value) > 0 Then
                Set lo_SubNode3 = AppendElement(lo_XMLDoc, lo_SubNode2, "ITM_TEXTS", "")
                    
                Set lo_SubNode4 = AppendElement(lo_XMLDoc, lo_SubNode3, "ITM_TEXT_GROUP", "")
                
                Call SAP_CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_ID"), lo_XMLDoc, lo_SubNode4)
                Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, "", lo_XMLDoc, lo_SubNode4)
            
                Set lo_SubNode5 = AppendElement(lo_XMLDoc, lo_SubNode4, "TEXT_LINES", "") 'GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LANGU")
              
                la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
                
                For ll_Index = 0 To UBound(la_StrValues)
                    Call SAP_CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode5, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
                Next
            End If
    
          ElseIf mo_Db.GetFields(lc_Lines, "OFD_SAPAct") = "R" Then
  'REPLACE GROUPS
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "LINE_GROUP", "")
                    
            Call SAP_CreateXMLNode("ACTION_CODE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ACTION_CODE"), lo_XMLDoc, lo_SubNode)
            Call SAP_CreateXMLNode("SAP_CANC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SAP_CANC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode)
                
            Set lo_SubNode2 = AppendElement(lo_XMLDoc, lo_SubNode, "LINE_DETAIL_GROUP", "")
                
            Call SAP_CreateXMLNode("MATERIAL_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MATERIAL_NO"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("EPC_ORD_LINE_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "EPC_ORD_LINE_POS"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("FREE_OF_CHARGE_IND", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "FREE_OF_CHARGE_IND"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("MFG_PRE_RESERV_NO", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_NO"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("MFG_PRE_RESERV_LIN_POS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "MFG_PRE_RESERV_LIN_POS"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("CUST_POSITION", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "CUST_POSITION"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call SAP_CreateXMLNode("SALES_QTY_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY_PCS"), lo_XMLDoc, lo_SubNode2)
              Call SAP_CreateXMLNode("SALES_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call SAP_CreateXMLNode("SALES_QTY", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_QTY"), lo_XMLDoc, lo_SubNode2)
              Call SAP_CreateXMLNode("SALES_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SALES_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call SAP_CreateXMLNode("LINE_PRICE_AMT_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call SAP_CreateXMLNode("LINE_PRICE_AMT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_AMT"), lo_XMLDoc, lo_SubNode2)
            End If
            Call SAP_CreateXMLNode("LINE_PRICE_CURR", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_CURR"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("LINE_PRICE_UNIT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UNIT"), lo_XMLDoc, lo_SubNode2)
            If (le_CAT_Id = eDPCCategory.cgMetalCustomRectPanel) And (StrComp(ls_UOM, DPC_UOM_M2, vbTextCompare) = 0) Then
              Call SAP_CreateXMLNode("LINE_PRICE_UOM_PCS", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM_PCS"), lo_XMLDoc, lo_SubNode2)
            Else
              Call SAP_CreateXMLNode("LINE_PRICE_UOM", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "LINE_PRICE_UOM"), lo_XMLDoc, lo_SubNode2)
            End If
            Call SAP_CreateXMLNode("SHIPPING_PLANT", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "SHIPPING_PLANT"), lo_XMLDoc, lo_SubNode2)
            Call SAP_CreateXMLNode("ITM_REQ_DEL_DATE", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "ITM_REQ_DEL_DATE"), lo_XMLDoc, lo_SubNode2)
          
            ls_ATR_Value = GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LINE")
            ls_ATR_DataLength = mo_Db.GetFields(lc_CursorXML, "ATR_DataLength")
            
            If Len(ls_ATR_Value) > 0 Then
              Set lo_SubNode3 = AppendElement(lo_XMLDoc, lo_SubNode2, "ITM_TEXTS", "")
            
              Set lo_SubNode4 = AppendElement(lo_XMLDoc, lo_SubNode3, "ITM_TEXT_GROUP", "")
              
              Call SAP_CreateXMLNode("TEXT_ID", lc_CursorXML, GetATRValue(lc_CursorXML, lc_Lines, "TEXT_ID"), lo_XMLDoc, lo_SubNode4)
              Call SAP_CreateXMLNode("TEXT_LANGU", lc_CursorXML, "", lo_XMLDoc, lo_SubNode4) 'GetATRValue(lc_CursorXML, lc_Lines, "TEXT_LANGU")
              
              Set lo_SubNode5 = AppendElement(lo_XMLDoc, lo_SubNode4, "TEXT_LINES", "")
                                    
              la_StrValues = SplitATRValue(ls_ATR_Value, ls_ATR_DataLength)
                  
              For ll_Index = 0 To UBound(la_StrValues)
                  Call SAP_CreateXMLNode("TEXT_LINE", lc_CursorXML, la_StrValues(ll_Index), lo_XMLDoc, lo_SubNode5, GetCodePageFromLanguage(mo_Db, mo_Db.GetFields(lc_Header, "COF_Lang")))
              Next
            End If
            
          End If
        
          Call mo_Db.Next(lc_Lines)
          
      Wend
   End If
          
  Call mo_Db.Close(lc_Lines)
  Call mo_Db.Close(lc_Header)
  Call mo_Db.Close(lc_CursorXML)
  
  Set lo_SubNode2 = Nothing
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing
  
  SAP_SalesOrderLineCancelAddReplaceGetXML = SAP_SaveXMLDocument(lo_XMLDoc, "AMC_SalesOrderLineCancelAddReplace", "SAPAMCSalesOrderChange", as_ErrorMsg, InStr(1, mo_Tools.GetAConfigData("DPC_DEBUG_XML"), ms_PC_Name, vbTextCompare) >= 1)
  Exit Function
ErrHandler:
  
  If lc_Header <> 0 Then
    Call mo_Db.Close(lc_Header)
  End If
  
  If lc_Lines <> 0 Then
    Call mo_Db.Close(lc_Lines)
  End If
  
  If lc_CursorXML <> 0 Then
    Call mo_Db.Close(lc_CursorXML)
  End If

  Set lo_SubNode2 = Nothing
  Set lo_SubNode = Nothing
  Set lo_parentNode = Nothing
  Set lo_MainNode = Nothing

  'Call LogInterface(mo_Db, ml_U_Code)

  Call ErrHandler("SAP_SalesOrderLineCancelAddReplaceGetXML")
End Function

Private Function SendRequest(ByVal as_RestAddress As String, ByVal as_Type As String, ByVal as_XML As String, ByRef as_Response As String) As Boolean
On Error GoTo ErrHandler

#If LIVE = 1 Then
'    Dim mo_Sys As Object
    Dim mo_XMLHttp As Object
#Else
'    Dim mo_Sys As ARMSYSCOMLib.ArmSYS
    Dim mo_XMLHttp As Object
#End If
    
    Dim ld_RequestTime As Date
    Dim lb_SendOk As Boolean
    Dim ls_WebServiceAddress As String
    
    ld_RequestTime = Now()
    SendRequest = False
    lb_SendOk = False
    
    mo_ILO.ILO_XMLSent = as_XML
    
    Set mo_XMLHttp = CreateObject("MSXML2.ServerXMLHTTP")
    
    Call mo_XMLHttp.setTimeouts(40000, 40000, 120000, 120000)
    
    'since the server i am communicating with is using a self signed certificate authority
    ' I have to ignore all ssl errors.
    'XMLHTTP.setOption 2, 13056
    
    ' I set the friendlyname of my certificate just in case i have tried with and without
    'XMLHTTP.setOption 3, "myrealfriendlynameofcrt"
    
    ls_WebServiceAddress = Trim(mo_Tools.GetAConfigData("DPC_SAP_WEB_SERVICE_ADDRESS"))
    
    If as_Type = "GET" Then
        
        mo_ILO.ILO_Connection = ls_WebServiceAddress & "/" & as_RestAddress & "?AwiApiKey=vfls9eviwzyEbgIudODJfBlQef0JCXULQ+FfuaZHZf4=&SourceSystem=Capture&SchemaVersion=1.0&ClientIdentifier=FooBar"
        Call mo_XMLHttp.Open("GET", ls_WebServiceAddress & "/" & as_RestAddress & "?AwiApiKey=vfls9eviwzyEbgIudODJfBlQef0JCXULQ+FfuaZHZf4=&SourceSystem=Capture&SchemaVersion=1.0&ClientIdentifier=FooBar", False)
        
        On Error Resume Next
        Call mo_XMLHttp.send
            
    ElseIf as_Type = "POST" Then
    
        mo_ILO.ILO_Connection = ls_WebServiceAddress & "/" & as_RestAddress
        Call mo_XMLHttp.Open("POST", ls_WebServiceAddress & "/" & as_RestAddress, False)
        
        mo_XMLHttp.setRequestHeader "Content-type", "application/xml"
        mo_XMLHttp.setRequestHeader "x-awi-ApiKey", "vfls9eviwzyEbgIudODJfBlQef0JCXULQ+FfuaZHZf4="
        mo_XMLHttp.setRequestHeader "x-awi-SourceSystem", "Capture"
        mo_XMLHttp.setRequestHeader "x-awi-SchemaVersion", "1.0"
        
        On Error Resume Next
        With mo_XMLHttp
         .send (as_XML)
        End With
    End If
    
    If Err.Number <> 0 Then
        as_Response = "Send error occured: " & Err.Description
        mo_ILO.ILO_Error = Err.Description
        mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
        Call LogInterface(mo_Db, ml_U_Code)
    Else
        lb_SendOk = True
    End If
    
    On Error GoTo ErrHandler
    
    mo_ILO.ILO_Performance = DateDiff("s", ld_RequestTime, Now())
    
    If lb_SendOk = True Then
        If mo_XMLHttp.Status < 200 Or mo_XMLHttp.Status > 202 Then
            as_Response = "Error occured : " & mo_XMLHttp.Status & " - " & mo_XMLHttp.statusText
            mo_ILO.ILO_Error = as_Response
            mo_ILO.ILO_Status = eDPCInterfaceStatus.isFailed
            Call LogInterface(mo_Db, ml_U_Code)
        Else
            as_Response = mo_XMLHttp.responseText
            mo_ILO.ILO_XMLResponse = as_Response
            mo_ILO.ILO_RespMsg = as_Response
            SendRequest = True
        End If
    End If
    
    Set mo_XMLHttp = Nothing
    
    Exit Function
  
ErrHandler:
  'Call LogInterface(mo_Db, ml_U_Code)
  Call ErrHandler("SendRequest")
End Function

#If LIVE = 1 Then
Private Function TransferXMLDocument(ByVal as_SrcFileName As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Public Function TransferXMLDocument(ByVal as_SrcFileName As String, ByRef as_ErrorMsg As String) As Boolean
#End If

On Error GoTo ErrHandler

#If LIVE = 1 Then
    Dim lo_FTP As Object
    Set lo_FTP = CreateObject("ArmSysCOM.ArmFTP")
#Else
    Dim lo_FTP As ARMSYSCOMLib.ArmFTP
    Set lo_FTP = New ARMSYSCOMLib.ArmFTP
#End If

Dim ls_Error As String
Dim ls_FTPServerIP As String, ls_FTPServerLogin As String, ls_FTPServerPswd As String, ls_FTPServerPath As String
Dim ls_Bae_FTPConn() As String
Dim ls_Filename As String
    
    TransferXMLDocument = False
    
    ls_Bae_FTPConn = Split(mo_Tools.GetAConfigData("DPC_BAE_FTP_SLSORD"), SEP1)
    
    ls_FTPServerIP = ls_Bae_FTPConn(0)
    ls_FTPServerLogin = ls_Bae_FTPConn(1)
    ls_FTPServerPswd = ls_Bae_FTPConn(2)
    ls_FTPServerPath = ls_Bae_FTPConn(3)
    ls_Error = ""
    
    ls_Filename = right(as_SrcFileName, Len(as_SrcFileName) - InStrRev(as_SrcFileName, "\"))
    If OpenFTP(lo_FTP, ls_FTPServerIP, ls_FTPServerLogin, ls_FTPServerPswd, ls_Error) Then

        ' upload file to FTP server
        If UploadFile(lo_FTP, as_SrcFileName, ls_FTPServerPath & ls_Filename, ls_Error) = True Then
            TransferXMLDocument = True
        End If
        
        Call lo_FTP.LogoffServer
    
    End If
          
    Set lo_FTP = Nothing
    
    as_ErrorMsg = ls_Error
    
    Exit Function
ErrHandler:
  Call ErrHandler("TransferXMLDocument")
End Function

#If LIVE = 1 Then
Private Function DownloadXMLDocument(ByVal as_COF_Id As String, ByRef as_FileName As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Public Function DownloadXMLDocument(ByVal as_COF_Id As String, ByRef as_FileName As String, ByRef as_ErrorMsg As String) As Boolean
#End If

On Error GoTo ErrHandler

Dim lo_ts As TextStream

#If LIVE = 1 Then
    Dim lo_FTP As Object
    Set lo_FTP = CreateObject("ArmSysCOM.ArmFTP")
#Else
    Dim lo_FTP As ARMSYSCOMLib.ArmFTP
    Set lo_FTP = New ARMSYSCOMLib.ArmFTP
#End If

Dim ls_FTPServerIP As String, ls_FTPServerLogin As String, ls_FTPServerPswd As String, ls_FTPServerOutPath As String
Dim ls_Bae_FTPConn() As String
Dim ls_Request As String
Dim lc_Lines As Long
Dim ls_Filename, ls_Name As String
Dim ll_i, ll_Success As Long
    
    DownloadXMLDocument = False
    
    ls_Request = "exec DPC_BaeSalesOrderCreateLines_lst $COF_Id$,'E'"
    ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
    lc_Lines = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
  
    If Len(mo_Db.GetFields(lc_Lines, "OFD_OrdNrB7")) <= 0 Then
        Call mo_Db.Close(lc_Lines)
        as_ErrorMsg = "XML Download failed, OFD_OrdNrB7 empty for COF_Id: " & as_COF_Id
        Exit Function
    End If
    
    ls_Filename = mo_Db.GetFields(lc_Lines, "OFD_OrdNrB7") & "-"
    
    Call mo_Db.Close(lc_Lines)
    
    ls_Bae_FTPConn = Split(mo_Tools.GetAConfigData("DPC_BAE_FTP_SLSORD"), SEP1)
    
    ls_FTPServerIP = ls_Bae_FTPConn(0)
    ls_FTPServerLogin = ls_Bae_FTPConn(1)
    ls_FTPServerPswd = ls_Bae_FTPConn(2)
    ls_FTPServerOutPath = ls_Bae_FTPConn(4)
    
    If OpenFTP(lo_FTP, ls_FTPServerIP, ls_FTPServerLogin, ls_FTPServerPswd, as_ErrorMsg) Then

         If Not lo_FTP.List(ls_FTPServerOutPath & ls_Filename & "*", FTP_PASIVE) Then
             Call lo_FTP.LogoffServer
             Set lo_FTP = Nothing
             as_ErrorMsg = "FTP command List " & ls_FTPServerOutPath & "\" & ls_Filename & "*" & " failed."
             Exit Function
         End If
         
         ls_Filename = ""
         
         For ll_i = 0 To lo_FTP.ListCount - 1
             ls_Name = lo_FTP.ListFileName(ll_i)

             If lo_FTP.ListFileSize(ll_i) > 0 And ls_Name > ls_Filename Then
                ls_Filename = ls_Name
             End If
         Next
    
        If Len(ls_Filename) > 0 Then
            ' download file from FTP server
            If DownLoadFile(lo_FTP, ls_FTPServerOutPath & ls_Filename, ms_TempDir & "\" & ls_Filename, as_ErrorMsg) = True Then
                as_FileName = ls_Filename
                
                'save file content as response
                If Len(as_FileName) > 0 Then
                    Set lo_ts = mo_FSO.OpenTextFile(as_FileName)
                    mo_ILO.ILO_XMLResponse = lo_ts.ReadAll
                    Set lo_ts = Nothing
                End If
                
                'delete files from ftp
                For ll_i = 0 To lo_FTP.ListCount - 1
                     Call lo_FTP.DeleteFile(lo_FTP.ListFileName(ll_i), ll_Success)
                Next

            DownloadXMLDocument = True
        End If
        End If
        
        Call lo_FTP.LogoffServer
    
    End If
    
    Set lo_FTP = Nothing
    
    Exit Function
ErrHandler:
  If lc_Lines <> 0 Then
    Call mo_Db.Close(lc_Lines)
  End If
  
  Call ErrHandler("DownloadXMLDocument")
End Function

Public Function CAD_GeneratePDFFiles(ByVal as_COF_Id, ByVal ao_PRD_Ids_Collection As Collection, ByRef as_ErrorMsg As String) As Boolean
On Error GoTo ErrHandler

    Dim ls_PDF_Exe As String
    Dim ls_PDF_Exe_Registry As String
    Dim ls_PDF_PC3_File As String
    Dim ls_PDF_InteropDir As String
    Dim ls_ImportXML As String
    Dim ls_DestDir As String
    Dim ll_exitCode As Long
    Dim li_NrOfGeneratedDrawings As Integer
    Dim lo_Registry As New Registry
    Dim ls_StyleSheet As String
    Dim ls_path As String
    Dim ls_Tmp As String
    Dim ll_Idx As Long
    Dim ls_PRD_Id As String
    Dim ls_PRD_Code As String
    Dim ls_Param() As String
    Dim ls_Request As String
    Dim lo_File As Object
    Dim ls_Filename As String
    
    CAD_GeneratePDFFiles = False
    
    'ls_PDF_Exe_Registry = mo_Tools.GetAConfigData("DPC_CAD_PDFGenerator_Exe_Registry")
    '
    'If ls_PDF_Exe_Registry = "" Then
    '    as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9940, "#PDFGenerator not configured in A_Config.")
    '    Exit Function
    'End If
    
    'lo_Registry.RootKey = HKEY_LOCAL_MACHINE
    'lo_Registry.OpenSubKey ls_PDF_Exe_Registry, True
    'lo_Registry.GetValue "PATH", ls_PDF_Exe
    'lo_Registry.GetValue "INTEROP", ls_PDF_InteropDir
    'lo_Registry.CloseCurrentKey
            
    ls_PDF_Exe = App.Path + "\" & INI_NETAPP_PATH & "\" & INI_DPC_CAD_PDF_GENERATOR_DIR & "\" & INI_DPC_CAD_PDF_GENERATOR_EXE
    ls_PDF_InteropDir = App.Path + "\" & INI_NETAPP_PATH & "\" & INI_DPC_CAD_PDF_GENERATOR_DIR & "\" & "Interop"

    If Not mo_FSO.FileExists(ls_PDF_Exe) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9353, "#The file $FileName$ does not exists.", Array("$FileName$", ls_PDF_Exe))
        Exit Function
    End If
    
    If Not mo_FSO.FolderExists(ls_PDF_InteropDir) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9300, "#Server directory does not exists: $PATH$", Array("$PATH$", ls_PDF_InteropDir))
        Exit Function
    End If
    
    ls_path = App.Path & "\Download\CADPDFFiles\"
      
    If Not mo_FSO.FolderExists(ls_path) Then
      Call mo_FSO.CreateFolder(ls_path)
    End If
    
    'ls_PDF_PC3_File = mo_Tools.GetAConfigData("DPC_CAD_PC3_File")
    'ls_StyleSheet = mo_Tools.GetAConfigData("DPC_CAD_PC3_File")
    
    'GET pc3 configuration file
    ls_PDF_PC3_File = "DWG_TO_PDF.pc3"
    Call mo_Tools.LoadLatestAFile("CAD_PDF_PC3", ls_path, ls_PDF_PC3_File)
    
    If Not mo_FSO.FileExists(ls_PDF_PC3_File) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9353, "#The file $FileName$ does not exists.", Array("$FileName$", ls_PDF_PC3_File))
        Exit Function
    End If

    'GET stylesheet file
    ls_StyleSheet = "Capture.ctb"
    Call mo_Tools.LoadLatestAFile("CAD_PDF_STYLE", ls_path, ls_StyleSheet)
    
    If Not mo_FSO.FileExists(ls_StyleSheet) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9353, "#The file $FileName$ does not exists.", Array("$FileName$", ls_StyleSheet))
        Exit Function
    End If
    
    as_ErrorMsg = ""
    
    If CreatePDFGeneratorXMLFile(as_COF_Id, ao_PRD_Ids_Collection, as_ErrorMsg, ls_ImportXML, li_NrOfGeneratedDrawings) = False Then
        Exit Function
    End If
    
    If as_ErrorMsg <> "" Then
        
        ls_Tmp = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9941, "#Ignore following issues and continue with PDF generation?")
        
        If MsgBox(ls_Tmp & vbNewLine & as_ErrorMsg, VbMsgBoxStyle.vbOKCancel, "Warning") = vbCancel Then
            CAD_GeneratePDFFiles = True
            Exit Function
        End If
    End If
    
    If li_NrOfGeneratedDrawings = 0 Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9942, "#No drawings generated. Nothing to export")
        Exit Function
    End If
      
    ls_DestDir = mo_Tools.GetAConfigData("DPC_CAD_DestDir")
    
    If Not mo_FSO.FileExists(ls_ImportXML) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9353, "#The file $FileName$ does not exists.", Array("$FileName$", ls_ImportXML))
        Exit Function
    End If
            
    ll_exitCode = mo_Tools.StartExternalProgram("""" + ls_PDF_Exe + """ -r """ + ls_ImportXML + """ """ + ls_DestDir + """ """ + ls_PDF_PC3_File + """ """ + ls_PDF_InteropDir + """ """ + ls_StyleSheet + """")
    
    If ll_exitCode > 1 Then
        'NEW MESSAGE
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9943, "#Program did not finish as expected. Exit Code = $ExitCode$", Array("$ExitCode$", ll_exitCode))
    Else
        CAD_GeneratePDFFiles = True
    End If

    
    If right(ls_DestDir, 1) = "\" Then
      ls_DestDir = Left(ls_DestDir, Len(ls_DestDir) - 1)
    End If
    
    For ll_Idx = 1 To ao_PRD_Ids_Collection.Count
      ls_Param = Split(ao_PRD_Ids_Collection.Item(ll_Idx), ",", , vbTextCompare)
      ls_PRD_Id = ls_Param(0)
      ls_PRD_Code = ls_Param(2)
      ls_Filename = ls_DestDir & "\" & ls_PRD_Code & ".PDF"
      If mo_FSO.FileExists(ls_Filename) Then
        Set lo_File = mo_FSO.GetFile(ls_Filename)
        If (lo_File.Size > 0) Then
          ls_Request = "UPDATE DPC_RectPanel SET RPL_DrwNr=$RPL_DrwNr$ WHERE RPL_Id=$PRD_Id$ AND RPL_DrwNr=''"
          ls_Request = Replace(ls_Request, "$PRD_Id$", mo_Tools.SQLStr(ls_PRD_Id), , , vbTextCompare)
          ls_Request = Replace(ls_Request, "$RPL_DrwNr$", mo_Tools.SQLStr(ls_PRD_Code), , , vbTextCompare)
          Call mo_Db.ExecuteSQL(ls_Request)
        End If
      End If
    Next

    Exit Function
ErrHandler:
  
  Call ErrHandler("CAD_GeneratePDFFiles")
End Function

Private Function AppendAttribute(ByRef ao_Document As MSXML2.DOMDocument, ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_Name As String, ByVal as_Value As String) As Boolean

On Error GoTo ErrHandler
    
   AppendAttribute = False
    
#If LIVE = 1 Then
    Dim lo_AttNode As Object
#Else
    Dim lo_AttNode As MSXML2.IXMLDOMElement
#End If

    Set lo_AttNode = AppendElement(ao_Document, ao_parentNode, "ATTRIBUTE", "")
    Call AppendElement(ao_Document, lo_AttNode, "NAME", as_Name)
    Call AppendElement(ao_Document, lo_AttNode, "VALUE", as_Value)
        
    AppendAttribute = True
    
    Set lo_AttNode = Nothing
    Exit Function

ErrHandler:
    Set lo_AttNode = Nothing
    Call ErrHandler("AppendAttribute")
End Function

Private Function AppendImage(ByRef ao_Document As MSXML2.DOMDocument, ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_Name As String) As Boolean

On Error GoTo ErrHandler
    
   AppendImage = False
    
#If LIVE = 1 Then
    Dim lo_ImgNode As Object
#Else
    Dim lo_ImgNode As MSXML2.IXMLDOMElement
#End If

    Set lo_ImgNode = AppendElement(ao_Document, ao_parentNode, "IMAGE", "")
    Call AppendElement(ao_Document, lo_ImgNode, "NAME", as_Name)
        
    Set lo_ImgNode = Nothing
    
    AppendImage = True
    
    Exit Function
    
ErrHandler:
    Set lo_ImgNode = Nothing
    Call ErrHandler("AppendImage")
End Function

Private Function AppendCutType(ByVal as_Pos As String, ByRef ao_DPC_Cutout As DPC_Cutout, ByRef ao_Document As MSXML2.DOMDocument, ByRef ao_parentNode As MSXML2.IXMLDOMNode, ByVal as_FileName As String, ByVal as_CutOutTemplateDir As String, ByVal as_ReferenceBlock As String, ByRef as_ErrorMsg As String) As Boolean

Dim ll_FieldIdx As Integer
Dim ls_TmpName As String
Dim lo_ImportAttributes As Object
Dim lo_BlockNode As Object
Dim ls_Value As String

On Error GoTo ErrHandler
    
    AppendCutType = False
    
    If Not mo_FSO.FileExists(as_CutOutTemplateDir + "\" + as_FileName + ".dwg") Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9939, "#The file $FileName$ does not exists. $INFO$", Array("$FileName$", as_CutOutTemplateDir + "\" + as_FileName + ".dwg", "$INFO$", "CUT_Code=" & ao_DPC_Cutout.CUT_Code))
        Exit Function
    End If
    
    Set lo_BlockNode = AppendElement(ao_Document, ao_parentNode, "BLOCK", "")
    lo_BlockNode.appendChild ao_Document.createTextNode(vbNewLine + vbTab)
                
    Call AppendElement(ao_Document, lo_BlockNode, "NAME", as_FileName)
    Call AppendElement(ao_Document, lo_BlockNode, "TEMPLATE", as_CutOutTemplateDir + "\" + as_FileName + ".dwg")
    Call AppendElement(ao_Document, lo_BlockNode, "REF_BLOCK", as_ReferenceBlock)
    
    Set lo_ImportAttributes = AppendElement(ao_Document, lo_BlockNode, "ATTRIBUTES", "")
                    
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "J" & as_Pos, CStr(Round(ao_DPC_Cutout.PCT_SizeJ, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "K" & as_Pos, CStr(Round(ao_DPC_Cutout.PCT_SizeK, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "D" & as_Pos, CStr(Round(ao_DPC_Cutout.PCT_SizeD, 2)))
    
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "C-L" & as_Pos, CStr(Round(ao_DPC_Cutout.PCT_SizeL, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "C-zL" & as_Pos, CStr(Round(ao_DPC_Cutout.BCP_C_zL, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "E-M" & as_Pos, CStr(Round(ao_DPC_Cutout.PCT_SizeM, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "E-zM" & as_Pos, CStr(Round(ao_DPC_Cutout.BCP_E_zM, 2)))

    Call AppendAttribute(ao_Document, lo_ImportAttributes, "J-z" & as_Pos, CStr(Round(ao_DPC_Cutout.BCP_J_z, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "J-Hz" & as_Pos, CStr(Round(ao_DPC_Cutout.BCP_J_Hz, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "K-z" & as_Pos, CStr(Round(ao_DPC_Cutout.BCP_K_z, 2)))
    Call AppendAttribute(ao_Document, lo_ImportAttributes, "K-Hz" & as_Pos, CStr(Round(ao_DPC_Cutout.BCP_K_Hz, 2)))
            
    AppendCutType = True
    
    Set lo_BlockNode = Nothing
    Set lo_ImportAttributes = Nothing
    
    Exit Function
ErrHandler:

    Set lo_BlockNode = Nothing
    Set lo_ImportAttributes = Nothing
    
    Call ErrHandler("AppendCutType")
End Function

Public Function CreatePDFGeneratorXMLFile(ByVal as_COF_Id As String, ByVal ao_PRD_Ids_Collection As Collection, ByRef as_ErrorMsg As String, ByRef as_XMLFile As String, ByRef ai_NrOfGeneratedDrawings As Integer) As Boolean
On Error GoTo ErrHandler
        
Dim lo_parentNode As Object
Dim lo_MainNode As Object
Dim lo_SubNode As Object
Dim lo_ImportBlocks As Object
Dim lo_ImportAttributes As Object
Dim lo_ImportImages As Object
Dim lo_BlockNode As Object
Dim lo_XMLDoc As MSXML2.DOMDocument
Dim ls_TempPath As String
Dim ll_Index, ll_FieldIdx As Integer
Dim ls_RefFile As String
Dim ls_RefFileName As String
Dim ls_LayoutTemplateDir As String
Dim ls_BaseTemplateDir As String
Dim ls_PrfTemplateDir As String
Dim ls_CutOutTemplateDir As String
Dim ls_Request As String
Dim lc_Cursor As Long
Dim ls_BlockName As String
Dim lb_Error As Boolean
Dim lb_CurrentDrawingError As Boolean
Dim ls_NamePrefix As String
Dim ls_TmpName As String
Dim ls_PRD_Id As String
Dim ls_OFD_Id As String
Dim ls_Tmp() As String
Dim lo_DPC_Product As DPC_Product
Dim lo_Cutout As DPC_Cutout
Dim ls_Value As String
Dim lv_Gasket As Variant, lv_Spacer As Variant, lv_Side As Variant
Dim ll_Idx As Integer
Dim ls_CodePerf As String, ls_CodeUnPerf As String
Dim ls_CadFilePrf As String
Dim le_PanelType As eDPCPanelType
Dim ls_LayCADFile As String, ls_CADFile As String
Dim ls_CUT_CADFile As String

    lb_Error = False
    ai_NrOfGeneratedDrawings = 0
    
    CreatePDFGeneratorXMLFile = False
    
    ls_RefFile = mo_Tools.GetAConfigData("DPC_CAD_RefFile")
    If Not mo_FSO.FileExists(ls_RefFile) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9353, "#The file $FileName$ does not exists.", Array("$FileName$", ls_RefFile))
        Exit Function
    End If
    ls_RefFileName = Left(ls_RefFile, Len(ls_RefFile) - 4)
    ls_RefFileName = right(ls_RefFileName, Len(ls_RefFileName) - InStrRev(ls_RefFileName, "\", , vbTextCompare))
    
    ls_LayoutTemplateDir = mo_Tools.GetAConfigData("DPC_CAD_LayoutTemplatesDir")
    If Not mo_FSO.FolderExists(ls_LayoutTemplateDir) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9300, "#Server directory does not exists: $PATH$", Array("$PATH$", ls_LayoutTemplateDir))
        Exit Function
    End If
    
    ls_BaseTemplateDir = mo_Tools.GetAConfigData("DPC_CAD_BaseTemplatesDir")
    If Not mo_FSO.FolderExists(ls_BaseTemplateDir) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9300, "#Server directory does not exists: $PATH$", Array("$PATH$", ls_BaseTemplateDir))
        Exit Function
    End If
    
    ls_CutOutTemplateDir = mo_Tools.GetAConfigData("DPC_CAD_CutOutTemplatesDir")
    If Not mo_FSO.FolderExists(ls_BaseTemplateDir) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9300, "#Server directory does not exists: $PATH$", Array("$PATH$", ls_CutOutTemplateDir))
        Exit Function
    End If
    
    ls_PrfTemplateDir = mo_Tools.GetAConfigData("DPC_CAD_PerfTemplatesDir")
    If Not mo_FSO.FolderExists(ls_BaseTemplateDir) Then
        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9300, "#Server directory does not exists: $PATH$", Array("$PATH$", ls_PrfTemplateDir))
        Exit Function
    End If
    
    ls_TempPath = mo_Tools.GetAndCreateTempDir(mo_FSO, SCREEN_NAME, True) & "\import.xml"
    
    Set lo_XMLDoc = CreateObject("MSXML2.DOMDocument")
      
    Set lo_MainNode = lo_XMLDoc.createProcessingInstruction("xml", "version='1.0' encoding='utf-8'")
    lo_XMLDoc.appendChild lo_MainNode
    
    Set lo_MainNode = AppendElement(lo_XMLDoc, Nothing, "IMPORT_INFO", "")
    lo_MainNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
    
    'DRAWINGS
    Set lo_parentNode = AppendElement(lo_XMLDoc, lo_MainNode, "DRAWINGS", "")
    
    ls_CodePerf = mo_Tools.ConvertCodeToBaeurer(mo_Db, eDPCCodeConversionBaeurer.ccPBorder, "2")
    ls_CodeUnPerf = mo_Tools.ConvertCodeToBaeurer(mo_Db, eDPCCodeConversionBaeurer.ccPBorder, "1")
        
    For ll_Index = 1 To ao_PRD_Ids_Collection.Count
                                
        lb_CurrentDrawingError = False
        
        ls_Tmp = Split(ao_PRD_Ids_Collection.Item(ll_Index), ",", , vbTextCompare)
        
        ls_PRD_Id = ls_Tmp(0)
        ls_OFD_Id = ls_Tmp(1)
        
        ls_Request = "exec DPC_CAD_DataAttrib_lst2 $COF_Id$, $OFD_Id$, $PRD_Id$, $Language_Code$, $U_Code$"
        ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SqlStrKey(as_COF_Id), , , vbTextCompare)
        ls_Request = Replace(ls_Request, "$OFD_Id$", mo_Tools.SqlStrKey(ls_OFD_Id), , , vbTextCompare)
        ls_Request = Replace(ls_Request, "$PRD_Id$", mo_Tools.SqlStrKey(ls_PRD_Id), , , vbTextCompare)
        ls_Request = ReplaceCommonPlaceholders(ls_Request)
        lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
        
        If mo_Db.RowCount(lc_Cursor) <> 1 Then
            as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9946, "#No SQL Data for PRD_Id: $PRD_Id$ and OFD_Id: $OFD_Id$", Array("$PRD_Id$", ls_PRD_Id, "OFD_Id$", ls_OFD_Id))
             lb_Error = True
             GoTo Clean
        End If
                
        'If mo_Db.Find(lc_Cursor, Array("PRD_Id", "OFD_Id"), Array(ls_PRD_Id, ls_OFD_Id), 0, 1) < 0 Then
        'End If
                
        Set lo_DPC_Product = Nothing
        Set lo_DPC_Product = New DPC_Product
        Set lo_DPC_Product.ArmDb = mo_Db
        lo_DPC_Product.CT_Code = ms_CT_Code
        lo_DPC_Product.CURR_Code = "EUR"
        lo_DPC_Product.ValidityDate = ValidityDate
        lo_DPC_Product.Language_Code = ms_Language_Code
        lo_DPC_Product.COF_Id = as_COF_Id
        lo_DPC_Product.OFD_IdPar = ls_OFD_Id
        Set lo_DPC_Product.Tools = mo_Tools
        Call lo_DPC_Product.Load_A_COM
        Call lo_DPC_Product.InitOffer
    
        Call lo_DPC_Product.Load(ls_PRD_Id)
        
        If StrComp(mo_Db.GetFields(lc_Cursor, "SYS_Fix"), "X", vbTextCompare) = 0 Then
          le_PanelType = eDPCPanelType.ptSquare
        Else
          le_PanelType = eDPCPanelType.ptRectangular
        End If
        
        If le_PanelType = eDPCPanelType.ptRectangular Then
          Call lo_DPC_Product.LoadRectangularBendCutParam
        ElseIf le_PanelType = eDPCPanelType.ptSquare Then
          Call lo_DPC_Product.LoadSquareBendCutParam
        End If
        
        'check Gasket settings
        If lo_DPC_Product.HasGasket Then
        
            lv_Gasket = lo_DPC_Product.GetGasketArray()
            
            ls_Value = lv_Gasket(0, 0)
            
            For ll_Idx = 0 To UBound(lv_Gasket, 2)
            
                If ls_Value <> lv_Gasket(0, ll_Idx) Then
                    as_ErrorMsg = as_ErrorMsg & vbNewLine & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9944, "#Multiple Gaskets selected. Drawing for product PRD_Code: $PRD_Code$ will be not generated!", Array("$PRD_Code$", lo_DPC_Product.PRD_Code))
                    lb_CurrentDrawingError = True
                End If
            Next
                       
        End If
        
        'check spacer settings
        
        lv_Spacer = lo_DPC_Product.GetSpacerArray
        
        ls_Value = lv_Spacer(0, 0)
        
        For ll_Idx = 0 To UBound(lv_Spacer, 2)
        
            If ls_Value <> lv_Spacer(0, ll_Idx) Then
                as_ErrorMsg = as_ErrorMsg & vbNewLine & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9945, "#Multiple Spacers selected. Drawing for product PRD_Code: $PRD_Code$ will be not generated!", Array("$PRD_Code$", lo_DPC_Product.PRD_Code))
                lb_CurrentDrawingError = True
            End If
        Next
                            
        If lb_CurrentDrawingError = False Then
        
            lo_parentNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
        
            Set lo_SubNode = AppendElement(lo_XMLDoc, lo_parentNode, "DRAWING", "")
            
            'ls_NamePrefix = ll_Index
            'ls_NamePrefix = Left("00", 3 - Len(ls_NamePrefix)) + ls_NamePrefix + "_"
            If Trim(mo_Db.GetFields(lc_Cursor, "RPL_DrwNr")) = "" Then
              Call AppendElement(lo_XMLDoc, lo_SubNode, "NAME", mo_Db.GetFields(lc_Cursor, "PRD_Code"))
            Else
              Call AppendElement(lo_XMLDoc, lo_SubNode, "NAME", mo_Db.GetFields(lc_Cursor, "RPL_DrwNr"))
            End If
            
            Call AppendElement(lo_XMLDoc, lo_SubNode, "TEMPLATE", ls_RefFile)
            
            Set lo_ImportBlocks = AppendElement(lo_XMLDoc, lo_SubNode, "IMPORT_BLOCKS", "")
                       
            'Layout Block
            Set lo_BlockNode = AppendElement(lo_XMLDoc, lo_ImportBlocks, "BLOCK", "")
            lo_BlockNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
            
            If le_PanelType = eDPCPanelType.ptRectangular Then
              ls_LayCADFile = mo_Db.GetFields(lc_Cursor, "SYS_LayCADFile")
            ElseIf le_PanelType = eDPCPanelType.ptSquare Then
              ls_LayCADFile = mo_Db.GetFields(lc_Cursor, "PRD_LayCADFile")
            End If
                        
            If Not mo_FSO.FileExists(ls_LayoutTemplateDir + "\" + ls_LayCADFile + ".dwg") Then
                as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9939, "#The file $FileName$ does not exists. $INFO$", Array("$FileName$", ls_LayCADFile, "$INFO$", "PRD_Code=" & lo_DPC_Product.PRD_Code))
                lb_Error = True
                GoTo Clean
            End If
    
            ls_BlockName = Left(ls_LayCADFile, Len(ls_LayCADFile))
            
            Call AppendElement(lo_XMLDoc, lo_BlockNode, "NAME", ls_BlockName)
            Call AppendElement(lo_XMLDoc, lo_BlockNode, "TEMPLATE", ls_LayoutTemplateDir + "\" + ls_LayCADFile + ".dwg")
            Call AppendElement(lo_XMLDoc, lo_BlockNode, "REF_BLOCK", ls_RefFileName)
                            
            Set lo_ImportImages = AppendElement(lo_XMLDoc, lo_BlockNode, "IMAGES", "")
            Call AppendImage(lo_XMLDoc, lo_ImportImages, ls_LayoutTemplateDir + "\ArmLogoR-BLK_314.jpg")
                            
            Set lo_ImportAttributes = AppendElement(lo_XMLDoc, lo_BlockNode, "ATTRIBUTES", "")
            
            For ll_FieldIdx = 1 To mo_Db.FieldCount(lc_Cursor)
                
                ls_TmpName = mo_Db.GetFieldName(lc_Cursor, ll_FieldIdx)
                If Left(ls_TmpName, 2) = "L." Then
                
                    ls_Value = mo_Db.GetFields(lc_Cursor, ls_TmpName)
                    
                    If ls_TmpName = "L.FUGENBAND" Then
                    
                        ls_Value = ""
                        If lo_DPC_Product.HasGasket Then
                        
                            'lv_Gasket = lo_DPC_Product.GetGasketArray()
                            'ls_Value = lv_Gasket(2, 0) ' get first gasket, for PDF generator, all have to be the same
                            
                            ls_Value = mo_Db.GetFields(lc_Cursor, "GskDescC")
                            If ls_Value = "" Then
                                ls_Value = mo_Db.GetFields(lc_Cursor, "GskDescD")
                                If ls_Value = "" Then
                                    ls_Value = mo_Db.GetFields(lc_Cursor, "GskDescE")
                                    If ls_Value = "" Then
                                        ls_Value = mo_Db.GetFields(lc_Cursor, "GskDescF")
                                    End If
                                End If
                            End If
                            
                        End If
                    End If
                    
                    If ls_TmpName = "L.FUGENBAND_LAGE" Then
                    
                        ls_Value = ""
                        If lo_DPC_Product.HasGasket Then
                            ls_Value = lo_DPC_Product.GSK_Pos
                        End If
                    End If
                    
                    If ls_TmpName = "L.DISTANZNOCKE" Then
                    
                        ls_Value = ""
                        If lo_DPC_Product.HasSpacer Then
                        
                            'lv_Spacer = lo_DPC_Product.GetSpacerArray
                            'ls_Value = lv_Spacer(2, 0) ' get first spacer, for PDF generator, all have to be the same
                            
                            ls_Value = mo_Db.GetFields(lc_Cursor, "SpcDescC")
                            If ls_Value = "" Then
                                ls_Value = mo_Db.GetFields(lc_Cursor, "SpcDescD")
                                If ls_Value = "" Then
                                    ls_Value = mo_Db.GetFields(lc_Cursor, "SpcDescE")
                                    If ls_Value = "" Then
                                        ls_Value = mo_Db.GetFields(lc_Cursor, "SpcDescF")
                                    End If
                                End If
                            End If
                            
                        End If
                    End If
                    
                    If ls_TmpName = "L.DISTANZNOCKE_LAGE" Then
                                        
                        ls_Value = ""
                        If lo_DPC_Product.HasSpacer Then
                            ls_Value = lo_DPC_Product.GSK_Pos2
                        End If
                    End If
                    
                    Call AppendAttribute(lo_XMLDoc, lo_ImportAttributes, right(ls_TmpName, Len(ls_TmpName) - 2), ls_Value)
                End If
            
            Next
                  
            'Base Block
            Set lo_BlockNode = AppendElement(lo_XMLDoc, lo_ImportBlocks, "BLOCK", "")
            lo_BlockNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
            
            If le_PanelType = eDPCPanelType.ptRectangular Then
              ls_CADFile = mo_Db.GetFields(lc_Cursor, "SYS_CADFile")
            ElseIf le_PanelType = eDPCPanelType.ptSquare Then
              ls_CADFile = mo_Db.GetFields(lc_Cursor, "PRD_CADFile")
            End If

            If Not mo_FSO.FileExists(ls_BaseTemplateDir + "\" + ls_CADFile + ".dwg") Then
                as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9939, "#The file $FileName$ does not exists. $INFO$", Array("$FileName$", ls_CADFile, "$INFO$", "PRD_Code=" & lo_DPC_Product.PRD_Code))
                lb_Error = True
                GoTo Clean
            End If
    
            ls_BlockName = Left(ls_CADFile, Len(ls_CADFile))
            
            Call AppendElement(lo_XMLDoc, lo_BlockNode, "NAME", ls_BlockName)
            Call AppendElement(lo_XMLDoc, lo_BlockNode, "TEMPLATE", ls_BaseTemplateDir + "\" + ls_CADFile + ".dwg")
            Call AppendElement(lo_XMLDoc, lo_BlockNode, "REF_BLOCK", ls_RefFileName)
            
            Set lo_ImportAttributes = AppendElement(lo_XMLDoc, lo_BlockNode, "ATTRIBUTES", "")
            
            For ll_FieldIdx = 1 To mo_Db.FieldCount(lc_Cursor)
                
                ls_TmpName = mo_Db.GetFieldName(lc_Cursor, ll_FieldIdx)
                If Left(ls_TmpName, 2) = "B." Then
                
                    ls_Value = mo_Db.GetFields(lc_Cursor, ls_TmpName)
                    'ls_Value = ""
                    
                    If ls_TmpName = "B.Cx" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Cx)
                    End If
                    If ls_TmpName = "B.Cy" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Cy)
                    End If
                    If ls_TmpName = "B.Cz" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Cz)
                    End If
                    If ls_TmpName = "B.Dx" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Dx)
                    End If
                    If ls_TmpName = "B.Dy" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Dy)
                    End If
                    If ls_TmpName = "B.Dz" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Dz)
                    End If
                    If ls_TmpName = "B.Ex" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Ex)
                    End If
                    If ls_TmpName = "B.Ey" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Ey)
                    End If
                    If ls_TmpName = "B.Ez" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Ez)
                    End If
                    If ls_TmpName = "B.Fx" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Fx)
                    End If
                    If ls_TmpName = "B.Fy" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Fy)
                    End If
                    If ls_TmpName = "B.Fz" Then
                        ls_Value = CStr(lo_DPC_Product.BBP_Fz)
                    End If
                    Call AppendAttribute(lo_XMLDoc, lo_ImportAttributes, right(ls_TmpName, Len(ls_TmpName) - 2), ls_Value)
                End If
            
            Next
                    
            If lo_DPC_Product.HasPerforation() Then
            
                'Perforation Block
                
                ls_CadFilePrf = ""
                
                If le_PanelType = eDPCPanelType.ptRectangular Then
                  If lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated Then
                      ls_CadFilePrf = mo_Db.GetFields(lc_Cursor, "PRF_CADFileStdPerf")
                  ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides Then
                      ls_CadFilePrf = mo_Db.GetFields(lc_Cursor, "PRF_CADFileOverPerf")
                  ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOther Then
                      ls_CadFilePrf = mo_Db.GetFields(lc_Cursor, "PRF_CADFileOtherPerf")
                  End If
                ElseIf le_PanelType = eDPCPanelType.ptSquare Then
                  If lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated Then
                      ls_CadFilePrf = mo_Db.GetFields(lc_Cursor, "PRF_CADFileStdPerf2")
                  ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides Then
                      ls_CadFilePrf = mo_Db.GetFields(lc_Cursor, "PRF_CADFileOverPerf2")
                  ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOther Then
                      ls_CadFilePrf = mo_Db.GetFields(lc_Cursor, "PRF_CADFileOtherPerf2")
                  End If
                End If

                If ls_CadFilePrf <> "" Then
                    Set lo_BlockNode = AppendElement(lo_XMLDoc, lo_ImportBlocks, "BLOCK", "")
                    lo_BlockNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
                    
                    If Not mo_FSO.FileExists(ls_PrfTemplateDir + "\" + ls_CadFilePrf + ".dwg") Then
                        as_ErrorMsg = mo_Tools.MsgText(mo_Db, ms_Language_Code, 9939, "#The file $FileName$ does not exists $INFO$", Array("$FileName$", ls_PrfTemplateDir + "\" + ls_CadFilePrf + ".dwg", "$INFO$", "PRD_Code=" & lo_DPC_Product.PRD_Code & ",PRF_Code=" & lo_DPC_Product.PRF_Code))
                        lb_Error = True
                        GoTo Clean
                    End If
                    
                    ls_BlockName = Left(ls_CadFilePrf, Len(ls_CadFilePrf))
                    
                    Call AppendElement(lo_XMLDoc, lo_BlockNode, "NAME", ls_BlockName)
                    Call AppendElement(lo_XMLDoc, lo_BlockNode, "TEMPLATE", ls_PrfTemplateDir + "\" + ls_CadFilePrf + ".dwg")
                    Call AppendElement(lo_XMLDoc, lo_BlockNode, "REF_BLOCK", ls_RefFileName)
                    
                    Set lo_ImportAttributes = AppendElement(lo_XMLDoc, lo_BlockNode, "ATTRIBUTES", "")
                    
                    For ll_FieldIdx = 1 To mo_Db.FieldCount(lc_Cursor)
                        
                        ls_TmpName = mo_Db.GetFieldName(lc_Cursor, ll_FieldIdx)
                        If Left(ls_TmpName, 2) = "P." Then
                        
                            ls_Value = mo_Db.GetFields(lc_Cursor, ls_TmpName)
                            
                            If ls_TmpName = "P.AP" Then
                                ls_Value = CStr(Round(lo_DPC_Product.GetPrfA(), 2))
                            End If
                            If ls_TmpName = "P.BP" Then
                                ls_Value = CStr(Round(lo_DPC_Product.GetPrfB(), 2))
                            End If
                            If ls_TmpName = "P.C-zPR" Then
                                ls_Value = CStr(Round(lo_DPC_Product.BBP_CzPR, 2))
                            End If
                            If ls_TmpName = "P.D-zPR" Then
                                ls_Value = CStr(Round(lo_DPC_Product.BBP_DzPR, 2))
                            End If
                            If ls_TmpName = "P.E-zPR" Then
                                ls_Value = CStr(Round(lo_DPC_Product.BBP_EzPR, 2))
                            End If
                            If ls_TmpName = "P.F-zPR" Then
                                ls_Value = CStr(Round(lo_DPC_Product.BBP_FzPR, 2))
                            End If
                                                    
                            If ls_TmpName = "P.C_Rand" Then
                                
                                If lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOther Then
                                    ls_Value = IIf(lo_DPC_Product.RPL_UBor(eDPCSide.esSideC) >= 0, ls_CodeUnPerf, ls_CodePerf)
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides Then
                                    ls_Value = ls_CodePerf
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated Then
                                    ls_Value = ls_CodeUnPerf
                                End If
                                
                            End If
                            
                            If ls_TmpName = "P.D_Rand" Then
                                
                                If lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOther Then
                                    ls_Value = IIf(lo_DPC_Product.RPL_UBor(eDPCSide.esSideD) >= 0, ls_CodeUnPerf, ls_CodePerf)
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides Then
                                    ls_Value = ls_CodePerf
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated Then
                                    ls_Value = ls_CodeUnPerf
                                End If
                                
                            End If
                            
                            If ls_TmpName = "P.E_Rand" Then
                            
                                If lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOther Then
                                    ls_Value = IIf(lo_DPC_Product.RPL_UBor(eDPCSide.esSideE) >= 0, ls_CodeUnPerf, ls_CodePerf)
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides Then
                                    ls_Value = ls_CodePerf
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated Then
                                    ls_Value = ls_CodeUnPerf
                                End If
                            End If
                            
                            If ls_TmpName = "P.F_Rand" Then
                                If lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOther Then
                                    ls_Value = IIf(lo_DPC_Product.RPL_UBor(eDPCSide.esSideF) >= 0, ls_CodeUnPerf, ls_CodePerf)
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbOverperforatedAllSides Then
                                    ls_Value = ls_CodePerf
                                ElseIf lo_DPC_Product.RPL_PBord = eDPCPerforationBorderType.pbStandardUnperforated Then
                                    ls_Value = ls_CodeUnPerf
                                End If
                            End If
                            
                            'If ls_TmpName = "P.Perforationsschritt" Then
                            '    ls_Value = CStr(Round(lo_DPC_Product.RPL_SCorr, 1))
                            'End If
                            
                            Call AppendAttribute(lo_XMLDoc, lo_ImportAttributes, right(ls_TmpName, Len(ls_TmpName) - 2), ls_Value)
                        End If
                    
                    Next
                                
                End If
            End If
                                    
            'Process cutouts
            ll_Idx = 1
            For Each lo_Cutout In lo_DPC_Product.Cutouts
                
                If le_PanelType = eDPCPanelType.ptRectangular Then
                  ls_CUT_CADFile = lo_Cutout.CUT_CADFile
                ElseIf le_PanelType = eDPCPanelType.ptSquare Then
                  ls_CUT_CADFile = lo_Cutout.CUT_CADFile2
                End If

                If AppendCutType(CStr(ll_Idx), lo_Cutout, lo_XMLDoc, lo_ImportBlocks, ls_CUT_CADFile + "_POS" + CStr(ll_Idx), ls_CutOutTemplateDir, ls_RefFileName, as_ErrorMsg) = False Then
                    lb_Error = True
                    GoTo Clean
                End If
                ll_Idx = ll_Idx + 1
            Next
          
            ai_NrOfGeneratedDrawings = ai_NrOfGeneratedDrawings + 1
            
        End If ' lb_CurrentDrawingError
    
        Call mo_Db.Close(lc_Cursor)
        lc_Cursor = 0
        
        If Not lo_DPC_Product Is Nothing Then
            lo_DPC_Product.Unload_A_COM
            Set lo_DPC_Product = Nothing
        End If
    Next
    
    lo_parentNode.appendChild lo_XMLDoc.createTextNode(vbNewLine + vbTab)
    
    Call lo_XMLDoc.Save(ls_TempPath)
    
    as_XMLFile = ls_TempPath

Clean:

    If Not lo_DPC_Product Is Nothing Then
        lo_DPC_Product.Unload_A_COM
        Set lo_DPC_Product = Nothing
    End If
    
    If (lc_Cursor <> 0) Then
        Call mo_Db.Close(lc_Cursor)
    End If
    
    Set lo_ImportAttributes = Nothing
    Set lo_ImportImages = Nothing
    Set lo_BlockNode = Nothing
    Set lo_ImportBlocks = Nothing
    Set lo_SubNode = Nothing
    Set lo_parentNode = Nothing
    Set lo_MainNode = Nothing
    Set lo_XMLDoc = Nothing
    
    If lb_Error = False Then
        CreatePDFGeneratorXMLFile = True
    End If

    Exit Function
ErrHandler:
    
    If (lc_Cursor <> 0) Then
        mo_Db.Close (lc_Cursor)
    End If
    
    Set lo_ImportAttributes = Nothing
    Set lo_ImportImages = Nothing
    Set lo_BlockNode = Nothing
    Set lo_ImportBlocks = Nothing
    Set lo_SubNode = Nothing
    Set lo_parentNode = Nothing
    Set lo_MainNode = Nothing
    
    Call ErrHandler("CreatePDFGeneratorXMLFile")
End Function

' ************************************************************************************
' ******************************* FTP FUNCTIONS **************************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function OpenFTP(ByRef ao_FTP As Object, ByVal as_IP As String, as_Login As String, as_Password As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Private Function OpenFTP(ByRef ao_FTP As ARMSYSCOMLib.ArmFTP, ByVal as_IP As String, as_Login As String, as_Password As String, ByRef as_ErrorMsg As String) As Boolean
#End If
On Error GoTo ErrHandler
    OpenFTP = False
    
    If Not ao_FTP.LogOnToServer(as_IP, , as_Login, as_Password) Then
        as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9901, "#Cannot connect to FTP Server: $SERVER$", Array("$SERVER$", as_IP)) & vbCrLf
        Exit Function
    End If
        
    Dim ll_i As Long
    ll_i = InStr(1, as_Login, "/")
    If ll_i <> 0 Then
        ms_FTPRoot = right(as_Login, Len(as_Login) - ll_i) & "\"
    Else
        ms_FTPRoot = ""
    End If

    OpenFTP = True
    Exit Function
ErrHandler:
    Call ErrHandler("OpenFTP()")
End Function

#If LIVE = 1 Then
Private Function UploadFile(ByVal ao_FTP As Object, ByVal as_FileName As String, ByVal as_UploadedFile As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Private Function UploadFile(ByVal ao_FTP As ARMSYSCOMLib.ArmFTP, ByVal as_FileName As String, ByVal as_UploadedFile As String, ByRef as_ErrorMsg As String) As Boolean
#End If
On Error GoTo ErrHandler
    Dim ll_BytesTransfered As Long
    Dim ll_BytesTotal As Long
    Dim ll_Result As Long
    
    UploadFile = False
           
    If Not ao_FTP.UploadFileAsynch(as_FileName, as_UploadedFile, FTP_PASIVE) Then
        as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9902, "#FTP file transfer failed. File name:\\$FILENAME$", Array("$FILENAME$", as_FileName)) & vbCrLf
        Exit Function
    Else
        ' set global value
        ms_copyFile = as_FileName
        ' this consume most of the time of file upload
        While ao_FTP.AsynchOperationProgress(ll_BytesTransfered, ll_BytesTotal, ll_Result) And Not mb_copyAbort
            'll_Result = DoEvents()
            DoEvents
            'Debug.Print ll_BytesTransfered & " : " & ll_BytesTotal & " Result: " & ll_Result
        Wend
        Debug.Print ll_BytesTransfered & " : " & ll_BytesTotal & " Result: " & ll_Result
        
        If ll_BytesTransfered = ll_BytesTotal And Not mb_copyAbort And ll_Result <> 0 Then
                        
            ms_copyFile = ""
        Else
            ' transfer interrupted for some reason
            If mb_copyAbort Then
                ' stop download
                Call ao_FTP.AbortAsynch
                
                as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9903, "#FTP file transfer interupted. File name:\\$FILENAME$", Array("$FILENAME$", as_FileName)) & vbCrLf
                Exit Function
            Else
                ' other FTP transfer abort
                
                as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9903, "#FTP file transfer interupted. File name:\\$FILENAME$", Array("$FILENAME$", as_FileName)) & vbCrLf
                Exit Function
            End If
        End If
    End If
    
    UploadFile = True
    Exit Function
ErrHandler:
    Call ErrHandler("UploadFile()")
End Function

#If LIVE = 1 Then
Private Function DownLoadFile(ByVal ao_FTP As Object, ByVal as_FileName As String, ByVal as_DownloadedFile As String, ByRef as_ErrorMsg As String) As Boolean
#Else
Private Function DownLoadFile(ByVal ao_FTP As ARMSYSCOMLib.ArmFTP, ByVal as_FileName As String, ByVal as_DownloadedFile As String, ByRef as_ErrorMsg As String) As Boolean
#End If
On Error GoTo ErrHandler
    Dim ll_BytesTransfered As Long
    Dim ll_BytesTotal As Long
    Dim ll_Result As Long
    
    DownLoadFile = False
           
    If Not ao_FTP.DownloadFileAsynch(as_DownloadedFile, as_FileName, FTP_PASIVE) Then
        as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9902, "#FTP file transfer failed. File name:\\$FILENAME$", Array("$FILENAME$", as_FileName)) & vbCrLf
        Exit Function
    Else
        ' set global value
        ms_copyFile = as_DownloadedFile
        ' this consume most of thloade time of file upload
        While ao_FTP.AsynchOperationProgress(ll_BytesTransfered, ll_BytesTotal, ll_Result) And Not mb_copyAbort
            'll_Result = DoEvents()
            DoEvents
            'Debug.Print ll_BytesTransfered & " : " & ll_BytesTotal & " Result: " & ll_Result
        Wend
        'Debug.Print ll_BytesTransfered & " : " & ll_BytesTotal & " Result: " & ll_Result
        
        If ll_BytesTransfered = ll_BytesTotal And Not mb_copyAbort And ll_Result <> 0 Then
                        
            ms_copyFile = ""
        Else
            ' transfer interrupted for some reason
            If mb_copyAbort Then
                ' stop download
                Call ao_FTP.AbortAsynch
                
                as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9903, "#FTP file transfer interupted. File name:\\$FILENAME$", Array("$FILENAME$", as_FileName)) & vbCrLf
                Exit Function
            Else
                ' other FTP transfer abort
                
                as_ErrorMsg = as_ErrorMsg & mo_Tools.MsgText(mo_Db, ms_Language_Code, 9903, "#FTP file transfer interupted. File name:\\$FILENAME$", Array("$FILENAME$", as_FileName)) & vbCrLf
                Exit Function
            End If
        End If
    End If
    
    DownLoadFile = True
    Exit Function
ErrHandler:
    Call ErrHandler("DownloadFile()")
End Function

#If LIVE = 1 Then
Private Function LogInterface(ByVal ao_Db As Object, ByVal al_U_Code As Long) As Boolean
#Else
Private Function LogInterface(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal al_U_Code As Long) As Boolean
#End If

Dim ll_errNumber As Long
Dim ls_ErrSource As String
Dim ls_errDescription As String
Dim ls_LogMessage As String
Dim ls_ILO_Error

  ll_errNumber = Err.Number
  ls_ErrSource = Err.Source
  ls_errDescription = Err.Description
  
  If Err.Number > 0 Then
    ls_ILO_Error = mo_ILO.ILO_Error + Err.Description
  Else
    ls_ILO_Error = mo_ILO.ILO_Error
  End If
  
On Error GoTo ErrHandler

Const SQL_LOG_INS = "exec DPC_LogInterface_ins $ILO_Interface$,$ILO_MasterId$,$ILO_Status$,$ILO_RespMsg$,$ILO_Error$,$ILO_Connection$,$ILO_XMLSent$,$ILO_DateSent$,$ILO_XMLResponse$,$ILO_Performance$,$U_Code$"

Dim ls_Request As String

    LogInterface = False
        
    ls_Request = Replace(SQL_LOG_INS, "$ILO_Interface$", mo_Tools.SqlInt(mo_ILO.ILO_Interface), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_MasterId$", mo_Tools.SQLStr(mo_ILO.ILO_MasterId), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_Status$", mo_Tools.SqlInt(mo_ILO.ILO_Status), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_RespMsg$", mo_Tools.SQLStr(mo_ILO.ILO_RespMsg), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_Error$", mo_Tools.SQLStr(ls_ILO_Error), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_Connection$", mo_Tools.SQLStr(mo_ILO.ILO_Connection), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_XMLSent$", "N" & mo_Tools.SQLStr(mo_ILO.ILO_XMLSent), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_DateSent$", mo_Tools.SqlDate(mo_ILO.ILO_DateSent), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_XMLResponse$", mo_Tools.SQLStr(mo_ILO.ILO_XMLResponse), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$ILO_Performance$", mo_Tools.SqlDbl(mo_ILO.ILO_Performance), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$U_Code$", mo_Tools.SqlInt(al_U_Code), , , vbTextCompare)

    Call mo_Tools.ExecuteSQLSafe(ao_Db, ls_Request)
    
    LogInterface = True
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSource
    Err.Description = ls_errDescription
    
    Exit Function
  
ErrHandler:
    
  Call ErrHandler("LogInterface")
End Function

Private Function ClearLogInterface() As Boolean
On Error GoTo ErrHandler

    ClearLogInterface = False
            
    mo_ILO.ILO_Interface = 0
    mo_ILO.ILO_MasterId = ""
    mo_ILO.ILO_Status = eDPCInterfaceStatus.isNone
    mo_ILO.ILO_RespMsg = ""
    mo_ILO.ILO_Error = ""
    mo_ILO.ILO_Connection = ""
    mo_ILO.ILO_XMLSent = ""
    mo_ILO.ILO_DateSent = Now()
    mo_ILO.ILO_XMLResponse = ""
    mo_ILO.ILO_Performance = 0
        
    ClearLogInterface = True
    
    Exit Function
ErrHandler:
  Call ErrHandler("ClearLogInterface")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrHandler("ReplaceCommonPlaceholders")
End Function

' Standard error handler
Private Sub ErrHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub



